package org.tizen.gwt.sample.raphaelpaint.client.overlay;

import com.google.gwt.core.client.JavaScriptObject;

public class JsBag extends JavaScriptObject {
	
	public static JsBag create() {
		return JavaScriptObject.createObject().cast();
	}
	
	protected JsBag() {}
	
	public final native int getInt(String key) /*-{
		return +this[key] || 0;
	}-*/;
	
	public final native double getDouble(String key) /*-{
		return +this[key] || 0;
	}-*/;
	
	public final native float getFloat(String key) /*-{
		return +this[key] || 0;
	}-*/;
	
	public final native boolean getBoolean(String key) /*-{
		return !!this[key];
	}-*/;
	
	public final native <T> T get(String key) /*-{
		return this[key] || null;
	}-*/;
	
	public final native JsBag put(String key, int value) /*-{
		this[key] = value;
		return this;
	}-*/;
	
	public final native JsBag put(String key, float value) /*-{
		this[key] = value;
		return this;
	}-*/;
	
	public final native JsBag put(String key, double value) /*-{
		this[key] = value;
		return this;
	}-*/;
	
	public final native JsBag put(String key, boolean value) /*-{
		this[key] = value;
		return this;
	}-*/;
	
	public final native JsBag put(String key, Object value) /*-{
		this[key] = value;
		return this;
	}-*/;
}