package org.tizen.gwt.sample.raphaelpaint.client.overlay;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;

public class JQueryEvent extends JavaScriptObject {
	
	public static final String CHANGE = "change";
	public static final String CLICK = "click";
	public static final String KEY_UP = "keyup";
	
	protected JQueryEvent() {}
	
	/**
	 *  The current DOM element within the event bubbling phase.
	 */
	public final native Element currentTarget() /*-{
		return this.currentTarget;
	}-*/;

	/**
	 *	An optional object of data passed to an event method when the current executing handler is bound. 
	 */
	public final native JavaScriptObject data() /*-{
		return this.data;
	}-*/;

	/**
	 * The element where the currently-called jQuery event handler was attached.
	 * 
	 */
	public final native Element delegateTarget() /*-{
		return this.delegateTarget;
	}-*/;

	/**
	 * Returns whether event.preventDefault() was ever called on this event object.
	 */
	public final native boolean isDefaultPrevented() /*-{ 
		return this.isDefaultPrevented();
	}-*/;

	/**
	 * Returns whether event.stopImmediatePropagation() was ever called on this event object.
	 */
	public final native boolean isImmediatePropagationStopped() /*-{ 
		return this.isImmediatePropagationStopped();
	}-*/;

	/**
	 * Returns whether event.stopPropagation() was ever called on this event object.
	 */
	public final native boolean isPropagationStopped() /*-{
		return this.isPropagationStopped();
	}-*/;

	/**
	 * Indicates whether the META key was pressed when the event fired.
	 */
	public final native boolean metaKey()/*-{
		return this.metaKey;
	}-*/;
	
	/**
	 * The namespace specified when the event was triggered.		
	 */
	public final native String namespace() /*-{
		return this.namespace;
	}-*/;

	/**
	 * The mouse position relative to the left edge of the document.
	 */
	public final native double pageX() /*-{
		return this.pageX;
	}-*/;
	 
	/**
	 * The mouse position relative to the top edge of the document.
	 */
	public final native double pageY() /*-{
		return this.pageY;
	}-*/;
	
	/**
	 * If this method is called, the default action of the event will not be triggered.
	 */
	public final native void preventDefault() /*-{
		this.preventDefault();
	}-*/;
	
	/**
	 * The other DOM element involved in the event, if any.
	 */
	public final native Element relatedTarget() /*-{
		return this.relatedTarget;
	}-*/;
	
	/**
	 * The last value returned by an event handler that was triggered by this event, unless the value was undefined.
	 */
	public final native Object result() /*-{
		return this.result;
	}-*/;
	
	/**
	 * Keeps the rest of the handlers from being executed and prevents the event from bubbling up the DOM tree.
	 */
	public final native void stopImmediatePropagation() /*-{
		this.stopImmediatePropagation();
	}-*/;
	
	/**
	 * Prevents the event from bubbling up the DOM tree, preventing any parent handlers from being notified of the event.
	 */
	public final native void stopPropagation()/*-{
		return this.stopPropagation()
	}-*/;
	
	/**
	 * The DOM element that initiated the event.
	 */
	public final native Element target() /*-{
		return this.target;
	}-*/;
	
	/**
	 * The difference in milliseconds between the time the browser created the event and January 1, 1970.
	 */
	public final native double timestamp() /*-{
		return this.timeStamp;
	}-*/;
	
	/**
	 * Describes the nature of the event.
	 */
	public final native String type() /*-{
		 return this.type;
	}-*/;
	 
	/**
	 * For key or mouse events, this property indicates the specific key or button that was pressed.
	 */
	public final native int which() /*-{
		return this.which;
	}-*/;
}