package org.tizen.gwt.sample.raphaelpaint.client.overlay;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;

public class JQuery extends JavaScriptObject {
	
	public static class Css {
		
		public static final String BACKGROUND_COLOR = "background-color";
		public static final String COLOR = "color";
	}
	
	public static final native JQuery jQuery(Element element) /*-{
		return $wnd.$(element);
	}-*/;
	
	public static final JQuery jQuery(Element[] elements) {
		JsArray<Element> jsArray = JavaScriptObject.createArray().cast();
		for(Element e : elements) {
			jsArray.push(e);
		}
		return jQuery(elements);
	};
	
	public static final native JQuery jQuery(JsArray<? extends Element> elements) /*-{
		return $wnd.$(elements);
	}-*/;
	
	public static final native JQuery jQuery(String selector) /*-{
		return $wnd.$(selector);
	}-*/;
	
	public static final native JQuery jQuery(String selector, Node context) /*-{
		return $wnd.$(selector, context);
	}-*/;
	
	protected JQuery(){}
	
	public final JQuery on(String eventType, JQueryHandler handler) {
		return on(eventType, handler.jsFunction);
	}
	
	public final native JQuery on(String eventType, JavaScriptObject handler) /*-{
		return this.on(eventType, handler);
	}-*/;
	
	public final JsArray<Element> asElements() {
		return cast();
	}

	public final native JQuery show() /*-{
		return this.show();
	}-*/;

	public final native JQuery hide() /*-{
		return this.hide();
	}-*/;

	public final native JQuery add(String selector) /*-{
		return this.add(selector);
	}-*/;
	
	public final native JQuery add(Element element) /*-{
		return this.add(element);
	}-*/;

	public final Element get(int i) {
		return asElements().get(i);
	}

	public final native String text() /*-{
		return this.text();
	}-*/;

	public final native JQuery text(String text) /*-{
		return this.text(text);
	}-*/;
	
	public final native JQuery val(String val) /*-{
		return this.val(val);
	}-*/;
	
	public final native JQuery val(int val) /*-{
		return this.val(val);
	}-*/;
	
	public final native JQuery val(float val) /*-{
		return this.val(val);
	}-*/;
	
	public final native String valString() /*-{
		return this.val();
	}-*/;
	
	public final native int valInt() /*-{
		var v = parseInt(this.val(), 10);
		return $wnd.isNaN(v) ? 0 : v;
	}-*/;
	
	public final native float valFloat() /*-{
		var v = parseFloat(this.val(), 10);
		return $wnd.isNaN(v) ? 0 : v;
	}-*/;

	public native final JQuery css(String property, String value) /*-{
		return this.css(property, value);
	}-*/;
}