package org.tizen.gwt.sample.raphaelpaint.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;

public class Enums {

	public enum Tool {

		arrow, eraser, clear, 
		rectangle, square, triangle, circle, ellipse, star;
		
		public static JsArray<Element> getElements() {
			return getElementsByEnumNames(Tool.class);
		}
		
		public static Tool forElement(Element element) {
			return valueOf(element.getId());
		}
	}
	
	public enum Operation {
		
		move, scale, rotate;
		
		public static JsArray<Element> getElements() {
			return getElementsByEnumNames(Operation.class);
		}
		
		public static Operation forElement(Element element) {
			return valueOf(element.getId());
		}
	}
	
	static JsArray<Element> getElementsByEnumNames(Class<? extends Enum<?>> enumType) {
		final JsArray<Element> elements = JavaScriptObject.createArray().cast();
		Element e;
		for(Enum<?> tool : enumType.getEnumConstants()) {
			e = DOM.getElementById(tool.name());
			if(e != null) {
				elements.push(e);
			}
		}
		return elements;
	}
}
