package org.tizen.gwt.sample.raphaelpaint.client.overlay;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.NativeEvent;

public class RaphaelElement extends JavaScriptObject {
	
	public interface DragCallback {
		
		void onDragStart(RaphaelElement context, float x, float y, NativeEvent event);
		
		void onDragMove(RaphaelElement context, float x, float y, float dx, float dy, NativeEvent event);
		
		void onDragEnd(RaphaelElement context, NativeEvent event);
	}
	
	public static final class BBox extends JavaScriptObject {
		
		protected BBox() {}
		
		public final native float getX() /*-{
			return this.x;
		}-*/;
		
		public final native float getY() /*-{
			return this.y;
		}-*/;
		
		public final native float getX2() /*-{
			return this.x2;
		}-*/;
		
		public final native float getY2() /*-{
			return this.y2;
		}-*/;
		
		public final native float getWidth() /*-{
			return this.width;
		}-*/;
	
		public final native float getHeight() /*-{
			return this.height;
		}-*/;
	}
	
	protected RaphaelElement() {}
	
	public final native RaphaelElement attr(String attr, String value) /*-{
		return this.attr(attr, value);
	}-*/;
	
	public final native String attr(String attr) /*-{
		return this.attr(attr);
	}-*/;

	public final native void animate(JsBag params, int ms) /*-{
		this.animate(params, ms);
	}-*/;

	public final native void transform(String transformString)/*-{
		this.transform(transformString);
	}-*/;

	public final native void remove() /*-{
		this.remove();
	}-*/;
	
	public final BBox getBBox() {
		return this.getBBox(false);
	};
	
	public final native BBox getBBox(boolean isWithoutTransform) /*-{
		return this.getBBox(isWithoutTransform);
	}-*/;
	
	public final native void setDragCallback(DragCallback callback) /*-{
		this.drag(
			function (dx, dy, x, y, event) {
				callback.@org.tizen.gwt.sample.raphaelpaint.client.overlay.RaphaelElement.DragCallback::onDragMove(Lorg/tizen/gwt/sample/raphaelpaint/client/overlay/RaphaelElement;FFFFLcom/google/gwt/dom/client/NativeEvent;)(this, x, y, dx, dy, event)
			},
			function (x, y, event) {
				callback.@org.tizen.gwt.sample.raphaelpaint.client.overlay.RaphaelElement.DragCallback::onDragStart(Lorg/tizen/gwt/sample/raphaelpaint/client/overlay/RaphaelElement;FFLcom/google/gwt/dom/client/NativeEvent;)(this, x, y, event);
			},
			function (event) {
				callback.@org.tizen.gwt.sample.raphaelpaint.client.overlay.RaphaelElement.DragCallback::onDragEnd(Lorg/tizen/gwt/sample/raphaelpaint/client/overlay/RaphaelElement;Lcom/google/gwt/dom/client/NativeEvent;)(this, event);
			});
	}-*/;
}
