package org.tizen.gwt.sample.raphaelpaint.client.overlay;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;

public class ColorPicker extends JavaScriptObject {

	public interface ChangeCallback {

		void onChange(String color);
	}
	
	public static final native ColorPicker create(int x, int y, int size, String color, Element element) /*-{
		 return $wnd.Raphael.colorpicker(x, y, size, color, element);
	}-*/;
	
	protected ColorPicker() {}
	
	public final native String getColor() /*-{
		return this.color();
	}-*/;
	
	public final native void setColor(String color) /*-{
		this.color(color);
	}-*/;
	
	public final native void remove() /*-{
		this.remove();
	}-*/;
	
	public final native void setChangeCallback(ChangeCallback callback) /*-{
		this.onchange = function(color) {
			callback.@org.tizen.gwt.sample.raphaelpaint.client.overlay.ColorPicker.ChangeCallback::onChange(Ljava/lang/String;)(color);
		};
	}-*/;
}
