package org.tizen.gwt.sample.raphaelpaint.client;

import org.tizen.gwt.sample.raphaelpaint.client.Enums.Tool;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.RaphaelAttr;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.JsBag;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.RaphaelElement;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.Raphael;

public class ShapeDrawer {

	public static class Props {
		
		public static final String TRANSLATE_X = "translateX";
		public static final String TRANSLATE_Y = "translateY";
		public static final String SCALE_X = "scaleX";
		public static final String SCALE_Y = "scaleY";
		public static final String ROTATION = "rotation";
		public static final String TOOL_NAME = "toolName";
	}
	
	private final Raphael mPaper;
	private final Transforms mTransforms;

	public ShapeDrawer(Raphael paper, Transforms transforms) {
		mPaper = paper;
		mTransforms = transforms;
	}
	
	public RaphaelElement draw (Tool tool, String fillColor, String strokeColor, double x, double y) {
		RaphaelElement element;
		switch(tool) {
			case circle:
				element = mPaper.circle(x, y, 30);
				break;
			case ellipse:
				element = mPaper.ellipse(x, y, 60, 30);
				break;
			case rectangle:
				element = mPaper.rect(x, y, 80, 50);
				break;
			case square:
				element = mPaper.rect(x, y, 50, 50);
				break;
			case star:
				String starPath = "M " + x + " " + y + " l 14 20 l 24 0 l -15 19 l 8 23 l -23 -8 l -20 14 l 0 -24 l -20 -14 l 24 -7 z";
				element = mPaper.path(starPath);
				break;
			case triangle:
				String trianglePath = "M " + x + " " + y + " l 30 -60 l 30 60 z";
				element = mPaper.path(trianglePath);
				break;
				
			case arrow:
			case clear:
			case eraser:
			default:
				return null;
		
		}
		
		element.attr(RaphaelAttr.FILL, fillColor);
		element.attr(RaphaelAttr.STROKE, strokeColor);
		
		element.<JsBag> cast()
			.put(Props.TOOL_NAME, tool.name())
			.put(Props.TRANSLATE_X, 0)
			.put(Props.TRANSLATE_Y, 0)
			.put(Props.SCALE_X, 1)
			.put(Props.SCALE_Y, 1)
			.put(Props.ROTATION, 0);
		
		element.setDragCallback(mTransforms);
		return element;
	}
}
