package org.tizen.gwt.sample.raphaelpaint.client;

import static org.tizen.gwt.sample.raphaelpaint.client.Constants.SELECTOR_ROTATE_DIV;
import static org.tizen.gwt.sample.raphaelpaint.client.Constants.SELECTOR_ROTATION_SLIDER;

import org.tizen.gwt.sample.raphaelpaint.client.overlay.JQMSlider;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.JQuery;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.JQueryEvent;
import org.tizen.gwt.sample.raphaelpaint.client.overlay.JQueryHandler;

public class MyRotationSlider extends JQueryHandler {
	
	private final RaphaelPaint mRaphaelPaint;
	private final JQMSlider mSlider;
	private final JQuery mDiv;
	
	public MyRotationSlider(RaphaelPaint raphaelPaint) {
		mRaphaelPaint = raphaelPaint;
		mDiv = JQuery.jQuery(SELECTOR_ROTATE_DIV).hide();
		mSlider = JQuery.jQuery((SELECTOR_ROTATION_SLIDER)).cast();
		mSlider.on(JQueryEvent.CHANGE, this);
	}
	
	@Override
	public void onEvent(JQueryEvent event) {
		mRaphaelPaint.onRotationChange(getRotation());
	}

	public int getRotation() {
		return mSlider.valInt();
	}

	public void setRotation(int rotation) {
		mSlider.val(rotation);
	}

	public void hide() {
		mDiv.hide();
	}

	public void show() {
		mDiv.show();
	}
}