/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.gwt.bootstrap;

public class GwtModuleInfo {
    public static final String MODULE_NAME_REGEXP = "(?:[_\\$a-zA-Z][_\\$a-zA-Z0-9]*\\.)+[_\\$a-zA-Z0-9]+";
    private final String mPackageName;
    private final String mEntryPointName;

    public static GwtModuleInfo forName(String moduleName) throws IllegalArgumentException {
        int lastDotIndex = moduleName.lastIndexOf(".");
        GwtModuleInfo.validateModuleName(moduleName);
        return new GwtModuleInfo(moduleName.substring(0, lastDotIndex), moduleName.substring(lastDotIndex + 1));
    }

    public static void validateModuleName(String value) throws IllegalArgumentException {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Gwt Module Name must not be empty!");
        }
        if (!value.matches(MODULE_NAME_REGEXP)) {
            throw new IllegalArgumentException("Gwt Module Name should match regexp: (?:[_\\$a-zA-Z][_\\$a-zA-Z0-9]*\\.)+[_\\$a-zA-Z0-9]+");
        }
    }

    protected GwtModuleInfo(String packageName, String entryPointName) {
        this.mPackageName = packageName;
        this.mEntryPointName = entryPointName;
    }

    public String toString() {
        return this.mPackageName.length() == 0 ? this.mEntryPointName : this.mPackageName + "." + this.mEntryPointName;
    }

    public String getEntryPointName() {
        return this.mEntryPointName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getClientPackageName() {
        return this.mPackageName.length() == 0 ? "client" : this.mPackageName + ".client";
    }

    public String getEntryPointFullName() {
        return this.getClientPackageName() + "." + this.mEntryPointName;
    }

    public String getModuleRenameTo() {
        return this.mEntryPointName.toLowerCase();
    }

    public String getW3CWidgetId() {
        String[] splitted = this.mPackageName.split("\\.");
        if (splitted.length > 0) {
            int i;
            StringBuilder sb = new StringBuilder().append(splitted[0]);
            for (i = 1; i < splitted.length && i < 3; ++i) {
                sb.insert(0, ".").insert(0, splitted[i]);
            }
            sb.insert(0, "http://");
            while (i < splitted.length) {
                sb.append("/").append(splitted[i]);
                ++i;
            }
            return sb.append("/").append(this.mEntryPointName).toString();
        }
        return this.mEntryPointName;
    }
}

