/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.gwt.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XpathUtil {
    public static int replaceByXpath(Document doc, String xpath, String value) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().compile(xpath).evaluate(doc, XPathConstants.NODESET);
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                nodeList.item(i).setNodeValue(value);
            }
            return nodeList.getLength();
        }
        return 0;
    }

    public static int replaceByXpath(File file, File newfile, String xpath, String value) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        int replaced = 0;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(file);
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(newfile == null ? file : newfile));
        return replaced += XpathUtil.replaceByXpath(doc, xpath, value);
    }

    public static int replaceByXpath(File file, File newfile, List<ReplaceEntry> replacements) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        int replaced = 0;
        if (replacements != null && replacements.size() > 0) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(file);
            for (ReplaceEntry entry : replacements) {
                replaced += XpathUtil.replaceByXpath(doc, entry.mXpath, entry.mValue);
            }
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(newfile == null ? file : newfile));
        }
        return replaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryByXpath(File file, String xpath) throws FileNotFoundException, XPathExpressionException {
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(file);
            String string = XPathFactory.newInstance().newXPath().evaluate(xpath, new InputSource(istream));
            return string;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static final class ReplaceEntry {
        String mValue;
        String mXpath;

        public void setValue(String value) {
            this.mValue = value;
        }

        public void setXpath(String xpath) {
            this.mXpath = xpath;
        }
    }
}

