/*******************************************************************************
 *
 * Initializes all QUnit tests
 *
 * @author Zaneta Szymanska <<ahref='mailto:z.szymanska@samsung.com'>z.szymanska@samsung.com</a>>
 *
 * ******************************************************************************************************************
 *
 * Copyright (c) 2012-2013 Samsung Electronics All Rights Reserved.
 *
 ******************************************************************************/
// Initialize function
var init = function () {
    console.log("init() called");

    // add eventListener for tizenhwkey
    document.addEventListener('tizenhwkey', function (e) {
        if (e.keyName === "back") {
            tizen.application.getCurrentApplication().exit();
        }
    });

    test("ok test", function () {
        ok(true, "We expect true succeeds");
        ok("abc", "We expect non-empty string succeeds");
        ok(false, "We expect false fails");
        ok(0, "We expect 0 fails");
        ok(NaN, "We expect NaN fails");
        ok("", "We expect empty string fails");
        ok(null, "We expect null fails");
        ok(undefined, "We expect undefined fails");
    });

    test("equal test", function () {
        equal(1, 1, "1 equals 1");
        equal("", 0, "empty string and 0 succeeds");
        equal("", "", "empty string is equal empty string");
        equal("two", 2, "two is not equal 2");
        equal(null, false, "null is not equal false");
    });

    test("notEqual test", function () {
        notEqual(5, "6", "String '6' is not equal 5; succeeds");
    });

    test("strictEqual test", function () {
        strictEqual(2, 2, "2 and 2 have the same type and value");
    });

    test("notstrictEqual test", function () {
        notStrictEqual(2, "2",
            "String '2' and number 2 don't have the same type");
    });

    test("deepEqual test", function () {
        var obj = {
            foo: "bar"
        };

        deepEqual(obj, {
            foo: "bar"
        }, "This two objects are the same");
    });

    test("notDeepEqual test", function () {
        var obj = {
            foo: "bar"
        };

        notDeepEqual(obj, {
            foo: "bla"
        }, "Two different object, same key, but different value, not equal");
    });

    module("First module test");
    test("ok test", function () {
        ok(true, "true succeeds");
    });

    module("Second module test");
    test("ok test", function () {
        ok(true, "true succeeds");
    });

    module("");

    asyncTest("asynchronous test", function () {
        expect(1);

        setTimeout(function () {
            ok(true, "Passed and ready to resume!");
            start();
        }, 500);
    });

    test("my module test", function () {
        equal(add(2, 3), 5, "add function succeeds");
        equal(add("2", 3), 5, "add function fails");
    });
};
// window.onload can work without <body onload="">
window.onload = init;