/*******************************************************************************
 *
 *
 * @author Karolina Krolik
 *
 *
 * **************************************************************************************
 *
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 *
 ******************************************************************************/
// Screen shown when game is completed
"use strict";
var quizCompletedScreen = function($) {
    return {
        dimRectangle : null,
        quizEndText : null,
        playAgainBtn : null,
        playAgainText : null,
        questionMarkHappy : null,
        questionMarkSad : null,
        pointsDigit1 : null,
        pointsDigit2 : null,

        initialize : function() {
            var that = this;

            // POINTS
            this.pointsDigit1 = Crafty.e(
                    "2D, DOM, numberL0,SpriteAnimation, HideShow").attr({
                x : 670,
                y : 175,
                z : 0,
                alpha : 0.001
            });
            reusableElements.addPointsAnim1(this.pointsDigit1);

            this.pointsDigit2 = Crafty.e(
                    "2D, DOM, numberR0,SpriteAnimation, HideShow").attr({
                x : 725,
                y : 175,
                z : 0,
                alpha : 0.001
            });
            reusableElements.addPointsAnim2(this.pointsDigit2);

            // DIM RECTANGLE
            this.dimRectangle = Crafty.e("2D, DOM, Color, HideShow").attr({
                w : quiz.config.width,
                h : quiz.config.height,
                z : 0,
                alpha : 0.001
            }).color("black");

            // TEXT
            this.quizEndText = Crafty.e(
                    "2D, DOM, quizEndText, HideShow, SpriteAnimation").attr({
                x : 200,
                y : 105,
                z : 0,
                alpha : 0.01
            }).animate("quizCompleted", [ [ 101, 228 ] ]).animate("timesUp",
                    [ [ 101, 254 ] ]);

            // BUTTONS
            this.playAgainBtn = Crafty.e(
                    "2D, DOM, startBtn, HideShow, SpriteAnimation, Mouse")
                    .attr({
                        x : 455,
                        y : 275,
                        z : 0,
                        alpha : 0.01
                    }).animate("press", [ [ 74, 0 ] ]).animate("release",
                            [ [ 0, 0 ] ]).bind('MouseDown', function() {
                        that.buttonAnimate("press");
                    });

            this.playAgainText = Crafty.e(
                    "2D, DOM, playAgainText, HideShow, SpriteAnimation, Mouse")
                    .attr({
                        x : 455,
                        y : 275,
                        z : 0,
                        alpha : 0.01
                    }).animate("press", [ [ 74, 110 ] ]).animate("release",
                            [ [ 74, 88 ] ]).bind('MouseDown', function() {
                        that.buttonAnimate("press");
                    }).bind('MouseOut', function() {
                        that.buttonAnimate("release");
                    });

            // QUESTION MARKS
            this.questionMarkHappy = Crafty.e(
                    "2D, DOM, questionMarkHappy, HideShow").attr({
                x : 1055,
                y : 420,
                z : 0,
                alpha : 0.01
            });

            this.questionMarkSad = Crafty.e(
                    "2D, DOM, questionMarkSad, HideShow").attr({
                x : 1055,
                y : 420,
                z : 0,
                alpha : 0.01
            });
        },

        // Animate button with given actions
        buttonAnimate : function(action) {
            this.playAgainBtn.animate(action, 1, 1);
            this.playAgainText.animate(action, 1, 1);
        },

        // show game over screen
        // completed - if true show quiz completed screen, if false show timesup
        // screen
        // points - score
        show : function(completed, points) {
            this.dimRectangle.addComponent("Mouse");
            reusableElements.setPoints(points, this.pointsDigit1,
                    this.pointsDigit2);
            this.dimRectangle.attr({
                z : 1,
                alpha : 0.8
            });

            switch (completed) {
            case true:
                this.quizEndText.animate("quizCompleted", 1, 1);
                this.questionMarkHappy.show();
                break;
            case false:
                this.quizEndText.animate("timesUp", 1, 1);
                this.questionMarkSad.show();
                break;
            default:
                break;
            }

            this.quizEndText.show();
            this.playAgainBtn.show();
            this.playAgainText.show();
            this.pointsDigit1.show();
            this.pointsDigit2.show();

            this.playAgainText.bind('Click', function() {
                Crafty.scene("menu");
            });
        }

    };

}($);