/*******************************************************************************
 *
 *
 * @author Karolina Krolik
 *
 *
 * **************************************************************************************
 *
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 *
 ******************************************************************************/
// Scene shown when user wants to exit active game
"use strict";
var exitGameScreen = function($) {

    return {

        dimRectangle : null,
        resumeButton : null,
        quitButton : null,
        resumeText : null,
        quitText : null,
        questionMark : null,

        initialize : function() {

            var that = this;

            // DIM RECTANGLE
            this.dimRectangle = Crafty.e("2D, DOM, Color, HideShow").attr({
                w : quiz.config.width,
                h : quiz.config.height,
                z : 0,
                alpha : 0.001
            }).color("black");

            // RESUME BUTTON
            this.resumeButton = Crafty.e("2D, DOM, startBtn, HideShow").attr({
                x : 455,
                y : 225,
                z : 0,
                alpha : 0.01
            });

            this.resumeText = Crafty.e("2D, DOM, resumeText,  HideShow, Mouse")
                    .attr({
                        x : 455,
                        y : 225,
                        z : 0,
                        alpha : 0.01
                    });

            // QUIT BUTTON
            this.quitButton = Crafty.e("2D, DOM, normalBtn,  HideShow").attr({
                x : 455,
                y : 340,
                z : 0,
                alpha : 0.01
            });

            this.quitText = Crafty.e("2D, DOM, quitText,  HideShow, Mouse")
                    .attr({
                        x : 455,
                        y : 340,
                        z : 0,
                        alpha : 0.01
                    });

            this.questionMark = Crafty.e("2D, DOM, questionMark, HideShow")
                    .attr({
                        x : 1055,
                        y : 420,
                        z : 0,
                        alpha : 0.01
                    });
        },

        // exit the scene screen
        show : function() {
            this.dimRectangle.addComponent("Mouse");
            this.dimRectangle.attr({
                z : 1,
                alpha : 0.8
            });
            this.resumeButton.show();
            this.quitButton.show();
            this.resumeText.show();
            this.quitText.show();
            this.questionMark.show();

            this.resumeText.bind('Click', function() {
                that.cancelExit();
            });

            this.quitText.bind('Click', function() {
                Crafty.scene("menu");
            });
        },

        // return to the game (from exit screen)
        cancelExit : function() {
            this.dimRectangle.removeComponent("Mouse");
            this.dimRectangle.hide();
            this.resumeButton.hide();
            this.quitButton.hide();
            this.resumeText.hide();
            this.quitText.hide();
            this.questionMark.hide();

            this.resumeText.unbind('Click');
            this.quitText.unbind('Click');
        }

    };

}($);