/***************************************************************************************************************************************************************
 * 
 * 
 * @author Karolina Krolik
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 * 
 **************************************************************************************************************************************************************/
"use strict";
Crafty.scene("options", function() {
	tlib.logger.info("Scene: options");

	// TITLE
	Crafty.e("2D, DOM, optionsTitle").attr({
		x : 295,
		y : 65,
	});

	// BACK BUTTON
	var backButton = Crafty.e("2D, DOM, greenCircleButton,SpriteAnimation");

	var backArrow = Crafty.e("2D, DOM, backArrow, SpriteAnimation, Mouse").bind('Click', function() {
		Crafty.scene("menu");
	});

	reusableElements.addBackButtonProperties(backButton, backArrow);

	// LABELS
	// main
	Crafty.e("2D, DOM, numberText").attr({
		x : 100,
		y : 245,
	});
	Crafty.e("2D, DOM, timeText").attr({
		x : 100,
		y : 400,
	});
	Crafty.e("2D, DOM, soundText").attr({
		x : 100,
		y : 555,
	});
	// number of questions
	Crafty.e("2D, DOM, questionsNumber5").attr({
		x : 818,
		y : 330,
	});
	Crafty.e("2D, DOM, questionsNumber15").attr({
		x : 966,
		y : 330,
	});
	Crafty.e("2D, DOM, questionsNumber30").attr({
		x : 1111,
		y : 330,
	});

	// time for a question
	Crafty.e("2D, DOM, questionTime10").attr({
		x : 818,
		y : 485,
	});
	Crafty.e("2D, DOM, questionTime30").attr({
		x : 966,
		y : 485,
	});
	Crafty.e("2D, DOM, questionTime60").attr({
		x : 1111,
		y : 485,
	});

	// sound
	Crafty.e("2D, DOM, soundOn").attr({
		x : 818,
		y : 640,
	});
	Crafty.e("2D, DOM, soundOff").attr({
		x : 966,
		y : 640,
	});

	// NUBMER OF QUESTIONS CONTROLS

	// set properties (animations, event listeners)
	var setNumberOfQestionProperties = function(button, type) {
		button.animate("press", [ [ 293, 228 ] ]).animate("release", [ [ 277, 228 ] ]).animate("clicked", [ [ 309, 228 ] ]).bind('MouseDown', function() {
			if (quiz.config.numberOfQuestions != type)
				button.animate("press", 1, 0);
		}).bind('MouseOut', function() {
			if (quiz.config.numberOfQuestions != type)
				button.animate("release", 1, 0);
		}).bind('Click', function() {
			quiz.config.numberOfQuestions = type;
			refreshQuestionsNumberButtons();
		});
	};

	var questionsNumButton1 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 810,
		y : 245,
	});
	setNumberOfQestionProperties(questionsNumButton1, quiz.questionsNumberValues.FIRST);

	var questionsNumButton2 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 955,
		y : 245,
	});
	setNumberOfQestionProperties(questionsNumButton2, quiz.questionsNumberValues.SECOND);

	var questionsNumButton3 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 1100,
		y : 245,
	});
	setNumberOfQestionProperties(questionsNumButton3, quiz.questionsNumberValues.THIRD);

	// refresh controls according to the data from quiz.config
	var refreshQuestionsNumberButtons = function() {
		questionsNumButton1.animate("release", 1, 0);
		questionsNumButton2.animate("release", 1, 0);
		questionsNumButton3.animate("release", 1, 0);
		switch (quiz.config.numberOfQuestions) {
		case quiz.questionsNumberValues.FIRST:
			questionsNumButton1.animate("clicked", 1, 0);
			break;
		case quiz.questionsNumberValues.SECOND:
			questionsNumButton2.animate("clicked", 1, 0);
			break;
		case quiz.questionsNumberValues.THIRD:
			questionsNumButton3.animate("clicked", 1, 0);
			break;
		}
	}

	// QUESTION TIME CONTROLS

	// set properties (animations, event listeners)
	var setQestionTimeProperties = function(button, type) {
		button.animate("press", [ [ 293, 228 ] ]).animate("release", [ [ 277, 228 ] ]).animate("clicked", [ [ 309, 228 ] ]).bind('MouseDown', function() {
			if (quiz.config.timeForQuestion != type)
				button.animate("press", 1, 0);
		}).bind('MouseOut', function() {
			if (quiz.config.timeForQuestion != type)
				button.animate("release", 1, 0);
		}).bind('Click', function() {
			quiz.config.timeForQuestion = type;
			refreshQuestionsTimeButtons();
		})
	}
	var questionsTimeButton1 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 810,
		y : 400,
	});
	setQestionTimeProperties(questionsTimeButton1, quiz.questionsTimeValues.FIRST);

	var questionsTimeButton2 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 955,
		y : 400,
	});
	setQestionTimeProperties(questionsTimeButton2, quiz.questionsTimeValues.SECOND);

	var questionsTimeButton3 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 1100,
		y : 400,
	});
	setQestionTimeProperties(questionsTimeButton3, quiz.questionsTimeValues.THIRD);

	// refresh controls according to the data from quiz.config
	var refreshQuestionsTimeButtons = function() {
		questionsTimeButton1.animate("release", 1, 0);
		questionsTimeButton2.animate("release", 1, 0);
		questionsTimeButton3.animate("release", 1, 0);

		switch (quiz.config.timeForQuestion) {
		case quiz.questionsTimeValues.FIRST:
			questionsTimeButton1.animate("clicked", 1, 0);
			break;
		case quiz.questionsTimeValues.SECOND:
			questionsTimeButton2.animate("clicked", 1, 0);
			break;
		case quiz.questionsTimeValues.THIRD:
			questionsTimeButton3.animate("clicked", 1, 0);
			break;
		}
	}

	// SOUND CONTROLS

	// set properties (animations, event listeners)
	var setSoundButtonProperties = function(button, value) {
		button.animate("press", [ [ 293, 228 ] ]).animate("release", [ [ 277, 228 ] ]).animate("clicked", [ [ 309, 228 ] ]).bind('MouseDown', function() {
			if (quiz.config.sound != value)
				button.animate("press", 1, 0);
		}).bind('MouseOut', function() {
			if (quiz.config.sound != value)
				button.animate("release", 1, 0);
		}).bind('Click', function() {
			quiz.config.sound = value;
			refreshSoundButtons();
		})
	};
	var soundButton1 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 810,
		y : 555,
	});
	setSoundButtonProperties(soundButton1, false);

	var soundButton2 = Crafty.e("2D, DOM, blueCircleButton, SpriteAnimation, Mouse").attr({
		x : 955,
		y : 555,
	});
	setSoundButtonProperties(soundButton2, true);

	// refresh controls according to the data from quiz.config
	var refreshSoundButtons = function() {
		soundButton1.animate("release", 1, 0);
		soundButton2.animate("release", 1, 0);

		switch (quiz.config.sound) {
		case false:
			soundButton1.animate("clicked", 1, 0);
			break;
		case true:
			soundButton2.animate("clicked", 1, 0);
			break;

		}
	}

	// refresh controls according to the data from quiz.config
	refreshQuestionsNumberButtons();
	refreshQuestionsTimeButtons();
	refreshSoundButtons();

});