/***************************************************************************************************************************************************************
 * 
 * 
 * @author Karolina Krolik
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 * 
 **************************************************************************************************************************************************************/
"use strict";
Crafty.scene("help", function() {

	tlib.logger.info("Scene: help");

	// current hint page
	var page = 1;

	// TITLE
	Crafty.e("2D, DOM, helpTitle").attr({
		x : 295,
		y : 65,
	});

	// QUESTION MARK
	Crafty.e("2D, DOM, questionMarkBig").attr({
		x : 135,
		y : 310,
	});

	// BACK BUTTON
	var backButton = Crafty.e("2D, DOM, greenCircleButton,SpriteAnimation");

	var backArrow = Crafty.e("2D, DOM, backArrow, SpriteAnimation, Mouse").bind('Click', function() {
		Crafty.scene("menu");
	});

	reusableElements.addBackButtonProperties(backButton, backArrow);

	// HELP HINT
	var helpHint = Crafty.e("2D, DOM, helpHint, SpriteAnimation").attr({
		x : 355,
		y : 225,
	}).animate("page1", [ [ 0, 0 ] ]).animate("page2", [ [ 168, 0 ] ]).animate("page3", [ [ 0, 81 ] ]).animate("page4", [ [ 168, 81 ] ]);

	// ARROWS
	var leftArrow = Crafty.e("2D, DOM, arrowLeft, SpriteAnimation, HideShow, Mouse").attr({
		x : 490,
		y : 400,
		z : 0,
		alpha : 0.01
	}).animate("press", [ [ 218, 209.5 ] ]).animate("release", [ [ 206, 209.5 ] ]).bind('MouseDown', function() {
		this.animate("press", 1, 1);
	}).bind('MouseOut', function() {
		this.animate("release", 1, 1);
	}).bind('Click', function() {
		changePage(-1);
	});

	var rightArrow = Crafty.e("2D, DOM, arrowRight, SpriteAnimation, HideShow, Mouse").attr({
		x : 1105,
		y : 400,
		z : 2,
		alpha : 1
	}).animate("press", [ [ 194, 209 ] ]).animate("release", [ [ 182, 209 ] ]).bind('MouseDown', function() {
		this.animate("press", 1, 0);
	}).bind('MouseOut', function() {
		this.animate("release", 1, 0);
	}).bind('Click', function() {
		changePage(1);
	});

	// Change page for the next (val=1) or the previous one (val=-1)
	var changePage = function(val) {
		page += val;
		switch (page) {
		case 1:
			leftArrow.hide();
			break;
		case 2:
			leftArrow.show();
			break;
		case 3:
			rightArrow.show();
			break;
		case 4:
			rightArrow.hide();
			break;
		}
		if (page == 4) {
			rightArrow.hide();
		} else if (page == 1) {
			leftArrow.hide();
		}

		helpHint.animate("page" + page, 1, 0);
	}

});