/***************************************************************************************************************************************************************
 * 
 * 
 * @author Karolina Krolik
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 * 
 **************************************************************************************************************************************************************/

// Reusable entities, animations and functions (used in more than one scene)
"use strict";
var reusableElements = function($) {

	return {

		// add properties for backButtons
		addBackButtonProperties : function(button, arrow) {
			button.attr({
				x : 55,
				y : 40,
			}).animate("press", [ [ 301, 244 ] ]).animate("release", [ [ 277, 244 ] ]);

			arrow.attr({
				x : 55,
				y : 40,
			}).bind('MouseDown', function() {
				button.animate("press", 1, 1);
			}).bind('MouseOut', function() {
				button.animate("release", 1, 1);
			});
		},

		// animations for point entities
		addPointsAnim1 : function(entity) {
			entity.animate("num0", [ [ 138, 132 ] ]).animate("num1", [ [ 149, 132 ] ]).animate("num2", [ [ 160, 132 ] ]).animate("num3", [ [ 171, 132 ] ])
					.animate("num4", [ [ 182, 132 ] ]).animate("num5", [ [ 193, 132 ] ]).animate("num6", [ [ 204, 132 ] ]).animate("num7", [ [ 215, 132 ] ])
					.animate("num8", [ [ 226, 132 ] ]).animate("num9", [ [ 237, 132 ] ]);
		},

		addPointsAnim2 : function(entity) {
			entity.animate("num0", [ [ 138, 144 ] ]).animate("num1", [ [ 149, 144 ] ]).animate("num2", [ [ 160, 144 ] ]).animate("num3", [ [ 171, 144 ] ])
					.animate("num4", [ [ 182, 144 ] ]).animate("num5", [ [ 193, 144 ] ]).animate("num6", [ [ 204, 144 ] ]).animate("num7", [ [ 215, 144 ] ])
					.animate("num8", [ [ 226, 144 ] ]).animate("num9", [ [ 237, 144 ] ]);
		},

		// set number of points
		setPoints : function(number, digit1, digit2) {
			var sNumber = number.toString();
			if (number < 10) {
				digit2.animate("num" + sNumber.charAt(0), 1, 1);
				digit1.animate("num0", 1, 1);
			} else {
				digit2.animate("num" + sNumber.charAt(1), 1, 1);
				digit1.animate("num" + sNumber.charAt(0), 1, 1);
			}
		}

	};

}($);