/***************************************************************************************************************************************************************
 * 
 * 
 * @author Karolina Krolik
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 * 
 **************************************************************************************************************************************************************/
"use strict";
Crafty.scene("menu", function() {
	tlib.logger.info("Scene: menu");

	// four buttons available in menus
	var buttons = {
		START : 0,
		OPTIONS : 1,
		HELP : 2,
		ABOUT : 3
	}

	var questionMark = Crafty.e("2D, DOM, questionMark, Tween").attr({
		x : quiz.config.width,
		y : quiz.config.height
	});

	// TITLE
	Crafty.e("2D, DOM, gameTitle, Tween").attr({
		x : 295,
		y : 0
	}).tween({
		y : 65
	}, 60).bind("TweenEnd", function() {
		this.unbind("TweenEnd");
		this.tween({
			y : 55
		}, 20);
		this.bind("TweenEnd", function() {
			this.tween({
				y : 65,
			}, 20);
			questionMark.tween({
				x : 1055,
				y : 420
			}, 50);

		});
	});

	// START BUTTON
	var startButton = Crafty.e("2D, DOM, startBtn, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 225
	}).animate("press", [ [ 74, 0 ] ]).animate("release", [ [ 0, 0 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.START, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.START, "release");
	});

	var startText = Crafty.e("2D, DOM, startText, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 225
	}).animate("press", [ [ 0, 66 ] ]).animate("release", [ [ 0, 44 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.START, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.START, "release");
	}).bind('Click', function() {
		Crafty.scene("game");
	});

	// OPTIONS BUTTON
	var optionsButton = Crafty.e("2D, DOM, normalBtn, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 350
	}).animate("press", [ [ 74, 22 ] ]).animate("release", [ [ 0, 22 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.OPTIONS, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.OPTIONS, "release");
	});

	var optionsText = Crafty.e("2D, DOM, optionsText, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 350
	}).animate("press", [ [ 74, 66 ] ]).animate("release", [ [ 74, 44 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.OPTIONS, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.OPTIONS, "release");
	}).bind('Click', function() {
		Crafty.scene("options");
	});

	// HELP BUTTON
	var helpButton = Crafty.e("2D, DOM, normalBtn, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 465
	}).animate("press", [ [ 74, 22 ] ]).animate("release", [ [ 0, 22 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.HELP, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.HELP, "release");
	});

	var helpText = Crafty.e("2D, DOM, helpText, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 465
	}).animate("press", [ [ 148, 66 ] ]).animate("release", [ [ 148, 44 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.HELP, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.HELP, "release");
	}).bind('Click', function() {
		Crafty.scene("help");
	});

	// ABOUT BUTTON
	var aboutButton = Crafty.e("2D, DOM, normalBtn, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 580
	}).animate("press", [ [ 74, 22 ] ]).animate("release", [ [ 0, 22 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.ABOUT, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.ABOUT, "release");
	});

	var aboutText = Crafty.e("2D, DOM, aboutText, SpriteAnimation, Mouse").attr({
		x : 455,
		y : 580
	}).animate("press", [ [ 0, 110 ] ]).animate("release", [ [ 0, 88 ] ]).bind('MouseDown', function() {
		buttonAnimate(buttons.ABOUT, "press");
	}).bind('MouseOut', function() {
		buttonAnimate(buttons.ABOUT, "release");
	}).bind('Click', function() {
		Crafty.scene("about");
	});

	// animate buttons (press or release)
	var buttonAnimate = function(btn, action) {
		var button, text;
		switch (btn) {
		case buttons.START:
			button = startButton;
			text = startText;
			break;
		case buttons.OPTIONS:
			button = optionsButton;
			text = optionsText;
			break;
		case buttons.HELP:
			button = helpButton;
			text = helpText;
			break;
		case buttons.ABOUT:
			button = aboutButton;
			text = aboutText;
			break;
		}
		button.animate(action, 1, 0);
		text.animate(action, 1, 0);
	}

});