/***************************************************************************************************************************************************************
 * 
 * 
 * @author Karolina Krolik
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 * 
 **************************************************************************************************************************************************************/
"use strict";
// Game scene
Crafty.scene("game", function() {
	tlib.logger.info("Scene: game");

	var correctAnswer = null; // number of correct answer for the current question
	var points = 0; // current points cound
	var questionNumber = 0; // current question number
	var questionSequence = []; // array holding sequence of question numbers (it is shullfed at the beggining so that questions show in random order)
	var alreadyAnswered = false; // show if user has already chosen an answer (set to false when a new question shows)

	// Initialize array with qestion sequence
	for ( var i = 0; i < quiz.questions.length; i++)
		questionSequence[i] = i;

	// Shuffle array with question sequence
	for (i = questionSequence.length - 1; i > 0; i--) {
		var j = Math.floor(Math.random() * (i + 1));
		var temp = questionSequence[i];
		questionSequence[i] = questionSequence[j];
		questionSequence[j] = temp;
	}

	// BACK BUTTON
	var backButton = Crafty.e("2D, DOM, greenCircleButton,SpriteAnimation");

	var backArrow = Crafty.e("2D, DOM, backArrow, SpriteAnimation, Mouse").bind('Click', function() {
		exitGameScreen.show();
	});

	reusableElements.addBackButtonProperties(backButton, backArrow);

	// POINTS AND TIME LABELS
	Crafty.e("2D, DOM, pointsText").attr({
		x : 595,
		y : 80,
	});

	Crafty.e("2D, DOM, timeText").attr({
		x : 930,
		y : 80,
	});

	// CLOCK
	Crafty.e("2D, DOM, clock").attr({
		x : 1090,
		y : 40,
	});

	var clockHand = Crafty.e("2D, DOM, clockHand, Tween").origin(3, 60).attr({
		x : 1155,
		y : 48,
		w : 5,
		h : 60,
		rotation : 0
	})

	// QUESTION
	var questionText = Crafty.e("2D, DOM, Text").attr({
		w : 1170,
		h : 200,
		x : 55,
		y : 185
	}).textFont({
		size : '20px'
	}).text("The country famous for Samba dance is?").css({
		"text-align" : "left",
		"font-size" : "60px",
		"font-family" : "Droid Sans",
		"font-weight" : "bold",
		"color" : "#06000b"
	});

	// POINTS
	var pointsDigit1 = Crafty.e("2D, DOM, numberL0,SpriteAnimation").attr({
		x : 805,
		y : 70,
	});
	reusableElements.addPointsAnim1(pointsDigit1);

	var pointsDigit2 = Crafty.e("2D, DOM, numberR0,SpriteAnimation").attr({
		x : 860,
		y : 70,
	});
	reusableElements.addPointsAnim2(pointsDigit2);

	// BUTTONS

	var answerButtons = [];// array of button entities
	var answerTexts = [];// array of text entities

	answerButtons[0] = Crafty.e("2D, DOM, answerBtn, SpriteAnimation").attr({
		x : 55,
		y : 420
	});
	answerTexts[0] = Crafty.e("2D, DOM, Text, Mouse").attr({
		x : 55,
		y : 420
	}).bind('MouseDown', function() {
		answerButtons[0].animate("press", 1, 0);
	}).bind('MouseOut', function() {
		answerButtons[0].animate("release", 1, 0);
	}).bind('Click', function() {
		questionAnswered(0);
	});

	answerButtons[1] = Crafty.e("2D, DOM, answerBtn, SpriteAnimation").attr({
		x : 665,
		y : 420
	});
	answerTexts[1] = Crafty.e("2D, DOM, Text, Mouse").attr({
		x : 665,
		y : 420
	}).bind('MouseDown', function() {
		answerButtons[1].animate("press", 1, 0);
	}).bind('MouseOut', function() {
		answerButtons[1].animate("release", 1, 0);
	}).bind('Click', function() {
		questionAnswered(1);
	});

	answerButtons[2] = Crafty.e("2D, DOM, answerBtn, SpriteAnimation").attr({
		x : 55,
		y : 555
	});
	answerTexts[2] = Crafty.e("2D, DOM, Text, Mouse").attr({
		x : 55,
		y : 555
	}).bind('Click', function() {
		questionAnswered(2);
	}).bind('MouseDown', function() {
		answerButtons[2].animate("press", 1, 0);
	}).bind('MouseOut', function() {
		answerButtons[2].animate("release", 1, 0);
	});

	answerButtons[3] = Crafty.e("2D, DOM, answerBtn, SpriteAnimation").attr({
		x : 665,
		y : 555
	});
	answerTexts[3] = Crafty.e("2D, DOM, Text, Mouse").attr({
		x : 665,
		y : 555
	}).bind('Click', function() {
		questionAnswered(3);
	}).bind('MouseDown', function() {
		answerButtons[3].animate("press", 1, 0);
	}).bind('MouseOut', function() {
		answerButtons[3].animate("release", 1, 0);
	});

	// set width, height and font for question texts and bind click event
	for (i = 0; i < 4; i++) {
		answerTexts[i].attr({
			w : 560,
			h : 125
		}).textFont({
			size : '20px'
		}).css({
			"text-align" : "center",
			"font-size" : "50px",
			"font-family" : "Droid Sans",
			"font-weight" : "bold",
			"color" : "#ffffff",
			"vertical-align" : "middle",
			"padding-top" : "37px"
		});
	}

	// add animations for answerButtons
	for (i = 0; i < 4; i++) {
		answerButtons[i].animate("press", [ [ 222, 25 ] ]).animate("release", [ [ 222, 0 ] ]).animate("red", [ [ 222, 100 ] ]).animate("greenBlink",
				[ [ 222, 50 ], [ 222, 75 ], [ 222, 50 ], [ 222, 75 ], [ 222, 50 ], [ 222, 75 ] ]);
	}

	// called when user answers a question
	function questionAnswered(response) {
		clockHand.unbind("TweenEnd");
		clockHand.tween({
			rotation : 0
		}, 1);
		if (!alreadyAnswered) {
			alreadyAnswered = true;
			answerButtons[correctAnswer].animate("greenBlink", 50, 0);
			if (response != correctAnswer) {
				if (quiz.config.sound) {
					Crafty.audio.play("wrongAnswer");
				}
				answerButtons[response].animate("red", 50, 0);
			} else {
				if (quiz.config.sound) {
					Crafty.audio.play("correctAnswer");
				}
				points++;
				reusableElements.setPoints(points, pointsDigit1, pointsDigit2);
			}
			setTimeout(function() {
				nextQuestion();
			}, 3000);
		}
	}

	// reset all the buttons
	function buttonsReset() {
		for ( var i = 0; i < 4; i++)
			answerButtons[i].animate("release", 1, 0);
	}

	// shuffle question answers
	function shuffleQuestion(array) {
		// shuffle questions 2-4
		var j, temp;
		for ( var i = array.length - 1; i > 0; i--) {
			j = Math.floor(Math.random() * i + 1);
			temp = array[i];
			array[i] = array[j];
			array[j] = temp;
		}

		// shuffle the first question
		j = Math.floor(Math.random() * (array.length));
		temp = array[0];
		array[0] = array[j];
		array[j] = temp;
		correctAnswer = j;
		return array;
	}

	// show question on the screen
	var showQuestion = function(question) {
		var tempQestion = jQuery.extend(true, {}, question);
		tempQestion.ans = shuffleQuestion(tempQestion.ans);

		questionText.text(tempQestion.text);
		for ( var i = 0; i < 4; i++) {
			answerTexts[i].text(tempQestion.ans[i]);
		}

		clockHand.tween({
			rotation : 360
		}, quiz.config.timeForQuestion * Crafty.timer.getFPS());
		clockHand.bind("TweenEnd", function() {
			exitGameScreen.cancelExit();
			quizCompletedScreen.show(false, points);
		});

	}

	// show the first question
	showQuestion(quiz.questions[questionSequence[questionNumber]]);

	// select and show next question. If quiz is over show quizCompletedScreen
	var nextQuestion = function() {
		questionNumber++;
		alreadyAnswered = false;

		if (questionNumber < quiz.config.numberOfQuestions) {
			showQuestion(quiz.questions[questionSequence[questionNumber]]);
			buttonsReset();
		} else {
			quizCompletedScreen.show(true, points);
		}
	}

	// initialize exitGameScreen and quizCompletedScreen
	exitGameScreen.initialize();
	quizCompletedScreen.initialize();

});
