/***************************************************************************************************************************************************************
 * 
 * 
 * @author Karolina Krolik
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2013 Samsung Electronics All Rights Reserved.
 * 
 **************************************************************************************************************************************************************/

// Main quiz module, load resources, store config, run the first scene
"use strict";
var quiz = function($) {

	return {

		// posible values of question number per quiz
		questionsNumberValues : {
			FIRST : 5,
			SECOND : 15,
			THIRD : 30
		},

		// posible values of time for question
		questionsTimeValues : {
			FIRST : 10,
			SECOND : 30,
			THIRD : 60
		},

		config : {
			width : 1280,
			height : 720,
			numberOfQuestions : 1, // value set in initialize
			timeForQuestion : 1, // value set in initialize
			sound : true
		},

		questions : null, // array with questions

		/**
		 * Initializes Quiz application
		 */
		initialize : function() {
			tlib.logger.changeLogLevel(3);
			tlib.logger.info("Quiz.initialize()");

			// init Crafty
			Crafty.init(this.config.width, this.config.height);
			Crafty.canvas.init();

			// set basic config
			this.config.numberOfQuestions = this.questionsNumberValues.FIRST;
			this.config.timeForQuestion = this.questionsTimeValues.FIRST;

			// set bacgroundd
			Crafty.background("url('images/game_bg.png')");

			// Run intro
			Crafty.scene("intro");

			// load main sprite sheet
			Crafty.sprite(5, "images/quiz_sprite.png", {
				// menu scene buttons
				startBtn : [ 0, 0, 74, 22 ],
				normalBtn : [ 0, 22, 74, 22 ],
				startText : [ 0, 44, 74, 22 ],
				optionsText : [ 74, 44, 74, 22 ],
				helpText : [ 148, 44, 74, 22 ],
				aboutText : [ 0, 88, 74, 22 ],

				questionMarkHappy : [ 293, 132, 45, 62 ],
				questionMarkSad : [ 248, 132, 45, 62 ],

				// cancel scene
				resumeText : [ 148, 88, 74, 22 ],
				quitText : [ 148, 110, 74, 22 ],

				// titles
				gameTitle : [ 0, 132, 138, 24 ],
				optionsTitle : [ 0, 156, 138, 24 ],
				helpTitle : [ 0, 180, 138, 24 ],
				aboutTitle : [ 0, 204, 138, 24 ],

				// options scene
				blueCircleButton : [ 277, 228, 16, 16 ],
				greenCircleButton : [ 277, 244, 24, 22 ],
				backArrow : [ 277, 266, 24, 22 ],

				// help scene
				questionMarkBig : [ 138, 156, 44, 72 ],
				arrowRight : [ 182, 209, 12, 15 ],
				arrowLeft : [ 206, 209, 12, 15 ],

				// options scene
				numberText : [ 0, 228, 101, 23 ],
				soundText : [ 0, 274, 101, 23 ],
				questionsNumber5 : [ 182, 203, 13, 6 ],
				questionsNumber15 : [ 195, 203, 13, 6 ],
				questionsNumber30 : [ 208, 203, 13, 6 ],
				questionTime10 : [ 221, 203, 13, 6 ],
				questionTime30 : [ 234, 203, 13, 6 ],
				questionTime60 : [ 247, 203, 13, 6 ],
				soundOn : [ 260, 203, 13, 6 ],
				soundOff : [ 273, 203, 13, 6 ],

				// quiz completed
				quizEndText : [ 101, 228, 176, 26 ],
				playAgainText : [ 74, 88, 74, 22 ],

				// game scene
				numberL0 : [ 138, 132, 11, 12 ],
				numberR0 : [ 138, 144, 11, 12 ],
				clock : [ 182, 174, 27, 29 ],
				answerBtn : [ 222, 0, 116, 25 ],
				timeText : [ 182, 156, 29, 9 ],
				pointsText : [ 182, 165, 42, 9 ],
				clockHand : [ 209, 174, 1, 12 ]

			});

			// load sprite sheet with hits
			Crafty.sprite(5, "images/quiz_sprite_help.png", {
				helpHint : [ 0, 0, 168, 81 ],
			});

			// add sounds
			Crafty.audio.add("wrongAnswer", "sounds/game_wrong.wav");
			Crafty.audio.add("correctAnswer", "sounds/game_correct.wav");

			// load json with questions
			var that = this;
			this.questions = new Array();

			$.getJSON("questions.json", function(data) {
				for ( var i = 0; i < data.questions.length; i++) {
					var text = data.questions[i].text;
					var ans = [];
					ans[0] = data.questions[i].answer1;
					ans[1] = data.questions[i].answer2;
					ans[2] = data.questions[i].answer3;
					ans[3] = data.questions[i].answer4;
					that.questions[i] = new question(text, ans);
				}

			});

			// Define component "HideShow" (functions to hide/show entity by setting z and alpha values)
			Crafty.c("HideShow", {
				hide : function() {
					this.attr({
						z : 0,
						alpha : 0.01
					});
				},

				show : function() {
					this.attr({
						z : 2,
						alpha : 1
					});
				}

			});
		},

	};

}($);