/*******************************************************************************
 *
 * @author Zaneta Szymanska <<ahref='mailto:z.szymanska@samsung.com'>z.szymanska@samsung.com</a>>
 *
 *
 * **************************************************************************************
 *
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 *
 ******************************************************************************/
"use strict";
var filters = function() {
    // if 'Drop Shadow' tab is on
    var dropShadowTabOn = false;
    // if shadow is applied to image
    var shadowOn = false;

    // Values of available filter effects
    var filterValues = {
        grayscale : 0,
        sepia : 0,
        saturate : 100,
        hueRotate : 0,
        invert : 0,
        opacity : 100,
        brightness : 0,
        contrast : 100,
        blur : 0,
        dropShadow : {
            r : 0,
            g : 0,
            b : 0,
            a : 0.6,
            x : 0,
            y : 0,
            z : 0
        }
    };

    /**
     * Sets proper value for '-webkit-filter' and changes css for image element
     */
    var changePhoto = function() {
        var css = "";

        if (filterValues.grayscale !== 0) {
            css += "grayscale(" + filterValues.grayscale + "%) ";
        }
        if (filterValues.sepia !== 0) {
            css += "sepia(" + filterValues.sepia + "%) ";
        }
        if (filterValues.saturate !== 100) {
            css += "saturate(" + filterValues.saturate + "%) ";
        }
        if (filterValues.hueRotate !== 0) {
            css += "hue-rotate(" + filterValues.hueRotate + "deg) ";
        }
        if (filterValues.invert !== 0) {
            css += "invert(" + filterValues.invert + "%) ";
        }
        if (filterValues.opacity !== 100) {
            css += "opacity(" + filterValues.opacity + "%) ";
        }
        if (filterValues.brightness !== 0) {
            css += "brightness(" + filterValues.brightness + "%) ";
        }
        if (filterValues.contrast !== 100) {
            css += "contrast(" + filterValues.contrast + "%) ";
        }
        if (filterValues.blur !== 0) {
            css += "blur(" + filterValues.blur + "px)";
        }
        if (shadowOn) {
            css += "drop-shadow(" + filterValues.dropShadow.x + "px "
                    + filterValues.dropShadow.y + "px "
                    + filterValues.dropShadow.z + "px " + "rgba("
                    + filterValues.dropShadow.r + ", "
                    + filterValues.dropShadow.g + ", "
                    + filterValues.dropShadow.b + ", "
                    + filterValues.dropShadow.a + ") " + ") ";
        }

        $('#filtered-image').css('-webkit-filter', css);
        // Display filters applied to photo (below this photo)
        $('#used-filters').val(css);
    };

    /**
     * Sets values for all displayed sliders and refreshes them
     */
    var setDefault = function() {

        $('#grayscale-range').val(filterValues.grayscale);
        $('#sepia-range').val(filterValues.sepia);
        $('#saturate-range').val(filterValues.saturate);
        $('#hue-rotate-range').val(filterValues.hueRotate);
        $('#invert-range').val(filterValues.invert);
        $('#opacity-range').val(filterValues.opacity);
        $('#brightness-range').val(filterValues.brightness);
        $('#contrast-range').val(filterValues.contrast);
        $('#blur-range').val(filterValues.blur);
        $('#red-range').val(filterValues.dropShadow.r);
        $('#green-range').val(filterValues.dropShadow.g);
        $('#blue-range').val(filterValues.dropShadow.b);
        $('#alpha-range').val(filterValues.dropShadow.a);
        $('#x-range').val(filterValues.dropShadow.x);
        $('#y-range').val(filterValues.dropShadow.y);
        $('#z-range').val(filterValues.dropShadow.z);

        // Refreshes all sliders
        $('.filter-range').slider("refresh");
    };

    /**
     * Sets value returned by slider to proper filter
     *
     * @param slider Changed slider
     */
    var setSlideValue = function(slider) {

        switch (slider) {
        case "grayscale-range":
            filterValues.grayscale = $('#grayscale-range').val();
            break;

        case "sepia-range":
            filterValues.sepia = $('#sepia-range').val();
            break;

        case "saturate-range":
            filterValues.saturate = $('#saturate-range').val();
            break;

        case "hue-rotate-range":
            filterValues.hueRotate = $('#hue-rotate-range').val();
            break;

        case "invert-range":
            filterValues.invert = $('#invert-range').val();
            break;

        case "opacity-range":
            filterValues.opacity = $('#opacity-range').val();
            break;

        case "brightness-range":
            filterValues.brightness = $('#brightness-range').val();
            break;

        case "contrast-range":
            filterValues.contrast = $('#contrast-range').val();
            break;

        case "blur-range":
            filterValues.blur = $('#blur-range').val();
            break;

        case "red-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.r = $('#red-range').val();
        }
            break;

        case "green-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.g = $('#green-range').val();
        }
            break;

        case "blue-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.b = $('#blue-range').val();
        }
            break;

        case "alpha-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.a = $('#alpha-range').val();
        }
            break;

        case "x-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.x = $('#x-range').val();
        }
            break;

        case "y-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.y = $('#y-range').val();
        }
            break;

        case "z-range": {
            if (!shadowOn) {
                shadowOn = true;
            }
            filterValues.dropShadow.z = $('#z-range').val();
        }
            break;

        default:
            break;
        }
    };

    return {
        /**
         *
         * @returns
         */
        initialize : function() {
            // Sets initial slider's value
            setDefault();

            $('.filter-range').on("slidestop", function() {
                /**
                 * On 'slidestop' event updates value of filter and refreshes
                 * image
                 */
                setSlideValue(this.name);
                changePhoto();
            });

            $('#default')
                    .unbind()
                    .bind(
                            "click",
                            function() {
                                /**
                                 * Restores original image
                                 */
                                // Sets default values of filters
                                filterValues.grayscale = filterValues.sepia = filterValues.hueRotate = filterValues.invert = filterValues.brightness = filterValues.blur = 0;
                                filterValues.saturate = filterValues.opacity = filterValues.contrast = 100;

                                // Turn off shadow applied to photo
                                shadowOn = false;

                                // Set default values of drop-shadow filter
                                filterValues.dropShadow.r = filterValues.dropShadow.g = filterValues.dropShadow.b = 0;
                                filterValues.dropShadow.x = filterValues.dropShadow.y = filterValues.dropShadow.z = 0;
                                filterValues.dropShadow.a = 0.6;

                                // Updates photo (the input image without any
                                // filters)
                                changePhoto();
                                // Updates displayed sliders
                                setDefault();

                                $('#used-filters').val("-webkit-filter: none;");
                            });

            $('#drop-shadow-other').unbind().bind(
                    "click",
                    function() {
                        /**
                         * Changes displayed tab (one for 'Drop shadow'
                         * properties and one for 'Other filters')
                         */
                        if (!dropShadowTabOn) {
                            dropShadowTabOn = true;
                            $('#drop-shadow').show();
                            $('#css-filters').hide();
                            $('#drop-shadow-other').val("Other filters")
                                    .button("refresh");
                        } else {
                            dropShadowTabOn = false;
                            $('#drop-shadow').hide();
                            $('#css-filters').show();
                            $('#drop-shadow-other').val("Drop shadow").button(
                                    "refresh");
                        }
                    });
        }
    };
}();