#include "parsing.h"
#include <libxml/parser.h>
#include <libxml/tree.h>
typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
	bool value_begin;
	int value_type;
    char buffer[1024];
} appdata_s;

static void
win_delete_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}

void getParsedData(xmlNode * a_node, appdata_s *ad) {
	xmlNode *cur_node = NULL;
	xmlChar *value = NULL;
	for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
		if (!strcmp((const char*) cur_node->name, "name"))
			ad->value_type = 1;
		if (!strcmp((const char*) cur_node->name, "price"))
			ad->value_type = 2;
		if (!strcmp((const char*) cur_node->name, "calories"))
			ad->value_type = 3;
		if (!strcmp((const char*) cur_node->name, "text")) {
			if (ad->value_type == 1) {
				value = cur_node->content;
				strcat(ad->buffer, "Name : ");
				strcat(ad->buffer, (char*) value);
				strcat(ad->buffer, "<br/>");
				dlog_print(DLOG_DEBUG, "GG", "%s\n", ad->buffer);
				ad->value_type = 0;
			} else if (ad->value_type == 2) {
				value = cur_node->content;
				strcat(ad->buffer, "  Price : ");
				strcat(ad->buffer, (char*) value);
				strcat(ad->buffer, "<br/>");
				ad->value_type = 0;
			}
			else if (ad->value_type == 3) {
				value = cur_node->content;
				strcat(ad->buffer, "  Calories : ");
				strcat(ad->buffer, (char*) value);
				strcat(ad->buffer, "<br/>");
				ad->value_type = 0;
			}
		}
		getParsedData(cur_node->children, ad);
	}
}

static void
create_base_gui(appdata_s *ad, xmlDoc *doc, xmlNode *root_element)
{
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);
	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);


	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);


	ad->buffer[0] = '\0';
	ad->value_type = 0;

	getParsedData(root_element, ad);

	ad->label = elm_label_add(ad->conform);
	elm_object_text_set(ad->label, ad->buffer);
	evas_object_size_hint_weight_set(ad->label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_content_set(ad->conform, ad->label);

	evas_object_show(ad->win);
}

static bool
app_create(void *data)
{

	appdata_s *ad = data;

	xmlDoc *doc = NULL;
	xmlNode *root_element = NULL;
	char *loc = "http://www.xmlfiles.com/examples/simple.xml";

	doc = xmlReadFile(loc, NULL, 0);

	if (doc == NULL) {
	   dlog_print(DLOG_DEBUG, "GG", "error: could not parse file.");
	 }

	root_element = xmlDocGetRootElement(doc);
	create_base_gui(ad, doc,root_element);

	xmlFreeDoc(doc);

	xmlCleanupParser();

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
