#include <app.h>
#include "obj_parser.h"

void
getDataModelSizes(char* path, _model_s *model)
{
//	LOGI("getDataModelSizes");
	FILE *file = fopen(path, "r");

	if (file == NULL) {
		LOGE("ERROR OPENING OBJ FILE");
		exit(1);
	} else {
		char line[128]; /* or other suitable maximum line size */
		char *result = fgets(line, sizeof line, file);
		while (result != NULL ) /* read a line */
		{
//			LOGI("line: %s", line);
			if (eina_str_has_prefix(line, "v "))
				model->positions++;
			else if (eina_str_has_prefix(line, "vt "))
				model->texels++;
			else if (eina_str_has_prefix(line, "f "))
				model->faces++;

			result = fgets(line, sizeof line, file);
		}
		fclose(file);
	}

	model->vertices = model->faces * 3;
}

void
getDataModel(char* path, float *v, unsigned short *iB, float *tc, _model_s model)
{
	float positions[model.positions][3];
	float texels[model.texels][2];
	int faces[model.faces][6];

	int posIndex = 0;
	int texIndex = 0;
	int faceIndex = 0;
	int faceIndex2 = 0;

	char **arr;
	char **arr2;
	int i, j;

	FILE *file = fopen(path, "r");

	/* Read data from the file */
	if (file == NULL) {
		LOGE("ERROR OPENING OBJ FILE");
		exit(1);
	} else {
		char line[128]; /* or other suitable maximum line size */
		char *result = fgets(line, sizeof line, file);
		while (result != NULL ) /* read a line */
		{
//			LOGI("line: %s", line);
			if (eina_str_has_prefix(line, "v ")) {
				/* Vertices positions */
				arr = eina_str_split(line, " ", 0);

				positions[posIndex][0] = atof(arr[1]);
				positions[posIndex][1] = atof(arr[2]);
				positions[posIndex][2] = atof(arr[3]);
				posIndex++;

				free(arr[0]);
				free(arr);
			} else if (eina_str_has_prefix(line, "vt ")) {
				/* Texture coordinates */
				arr = eina_str_split(line, " ", 0);

				texels[texIndex][0] = atof(arr[1]);
				texels[texIndex][1] = atof(arr[2]);
				texIndex++;

				free(arr[0]);
				free(arr);
			} else if (eina_str_has_prefix(line, "f ")) {
				/* Faces */
				arr = eina_str_split(line, " ", 0);

				faceIndex2 = 0;

				for (i = 1; arr[i]; i++) {
					arr2 = eina_str_split(arr[i], "/", 0);
					for (j = 0; arr2[j]; j++) {
						faces[faceIndex][faceIndex2] = atoi(arr2[j]);
						faceIndex2++;
					}
				}
				faceIndex++;

				free(arr2[0]);
				free(arr2);

				free(arr[0]);
				free(arr);
			}

			result = fgets(line, sizeof line, file);
		}
		fclose(file);
	}

	/* Format data in a proper way */
	float vertices[texIndex][3];

	for (i = 0; i < faceIndex; i++) {
		for (j = 0; j < 3; j++) {
			vertices[faces[i][1] - 1][j] = positions[faces[i][0] - 1][j];
			vertices[faces[i][3] - 1][j] = positions[faces[i][2] - 1][j];
			vertices[faces[i][5] - 1][j] = positions[faces[i][4] - 1][j];
		}
	}

	int k = 0;

	for (i = 0; i < 24; i++)
		for (j = 0; j < 3; j++) {
			v[k++] = vertices[i][j];
		}

	for (i = 0; i < 12; i++) {
		for (j = 0; j < 3; j++) {
			iB[3 * i + j] = (unsigned short) (faces[i][2 * j + 1] - 1);
		}
	}

	k = 0;

	for (i = 0; i < 24; i++)
		for (j = 0; j < 2; j++) {
			tc[k++] = texels[i][j];
		}
}
