// set variables
var adapter = tizen.nfc.getDefaultAdapter();
var modeListenerId = 0, aseListenerId = 0, transListenerId = 0;
var data;

//Initialize function
	var init = function () {
		 var data = document.getElementById("content-text");
		 console.log("init() called");
		 data.innerHTML = "init() called";
		
		 data.innerHTML = adapter.powered;
		
		 if (adapter.powered)
		 {
		    console.log("NFC is already enabled");
		    data.innerHTML = "NFC is already enabled";
		 }
		 else{
			adapter.cardEmulationMode = "ALWAYS_ON";
			data.innerHTML = "NFC is not enabled";
		 }
		
		
		
		 //data.innerHTML = adapter.cardEmulationMode;
		 
		modeListenerId = adapter.addCardEmulationModeChangeListener(function(mode)
		{
		   if (mode === "ALWAYS_ON")
		   {
		      console.log("We are ready to go now");
		      data.innerHTML = "We are ready to go now";
		   }
		});
		
		 var onSuccessCB = {onattach : function(nfcTag) {
		     console.log("NFC Tag's type is " + nfcTag.type);
		   }, ondetach : function() {
		     console.log("NFC Tag is detached");
		   }};
		 adapter.setTagListener(onSuccessCB);
		
		
		
		aseListenerId = adapter.addActiveSecureElementChangeListener(function(seType)
		{
		   console.log("Active secure element is " + seType);
		   data.innerHTML = "Active secure element is " + seType;
		});
		
		function onDetected(appletId, datas)
		{
		   console.log("NFC secure element transaction detected. Application: " + appletId + ". Protocol data: " + datas);
		   data.innerHTML = "NFC secure element transaction detected. Application: " + appletId + ". Protocol data: " + datas;
		};
		transListenerId = adapter.addTransactionEventListener("UICC", onDetected);
		
		adapter.removeActiveSecureElementChangeListener(aseListenerId);
		adapter.removeTransactionEventListener(transListenerId);
		adapter.removeCardEmulationModeChangeListener(modeListenerId);
		adapter.cardEmulationMode = "OFF";

	// add eventListener for tizenhwkey
	document.addEventListener('tizenhwkey', function(e) {
		if(e.keyName == "back") {
			try {
				tizen.application.getCurrentApplication().exit();
			} catch (error) {
				console.error("getCurrentApplication(): " + error.message);
			}
		}
	});
};
// window.onload can work without <body onload="">
window.onload = init;

