#include "naviframe.h"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
	Evas_Object *nf;
} appdata_s;

static void
win_delete_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}

static void
object_pack(Evas_Object *box, Evas_Object *child, double horizontal_size,double vertical_size,double horizontal_position,double vertical_position)
{

	//This is a hint on how a container object should resize a given child within its area
	evas_object_size_hint_weight_set(child,horizontal_size,vertical_size);
	//Sets the hints for an object's alignment
	evas_object_size_hint_align_set(child,horizontal_position,vertical_position);
	//Makes the given Evas Object Visible
	evas_object_show(child);

	//Put the child to the end of the box
	elm_box_pack_end(box,child);

}

static Evas_Object *
create_naviframe(Evas_Object *parent)
{
	Evas_Object *nf;
	nf = elm_naviframe_add(parent);

	// Add back button automatically on naviframe views when created
	// This API cannot affect naviframe views already created
	elm_naviframe_prev_btn_auto_pushed_set(nf, EINA_TRUE);

	return nf;
}

// Left button click callback
static void
prev_btn_clicked_cb(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *nf = data;
	elm_naviframe_item_pop(nf);
}

// View pop callback
// If the callback returns EINA_FALSE, item popping is canceled and item is not deleted
static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	return EINA_TRUE;
}

//customized callback for the first view
static Eina_Bool
naviframe_pop_first_view_cb(void *data, Elm_Object_Item *it)
{
	ui_app_exit();
	return EINA_FALSE;
}


static Evas_Object*
create_tabbar_with_title(Evas_Object *parent)
{
	Evas_Object *toolbar;
	toolbar = elm_toolbar_add(parent);
	elm_object_style_set(toolbar, "tabbar_with_title");
	elm_toolbar_shrink_mode_set(toolbar, ELM_TOOLBAR_SHRINK_EXPAND);
	elm_toolbar_transverse_expanded_set(toolbar, EINA_TRUE);
	elm_toolbar_item_append(toolbar, NULL, "Tab1", NULL, parent);
	elm_toolbar_item_append(toolbar, NULL, "Tab2", NULL, parent);
	elm_toolbar_select_mode_set(toolbar, ELM_OBJECT_SELECT_MODE_ALWAYS);

	return toolbar;
}

static void
third_page_cb(Evas_Object *nf1)
{
	Evas_Object *content, *tabbar, *nf = nf1;
	Elm_Object_Item *nf_it;

	// Set nocontents layout
	content = elm_layout_add(nf);

	// Push the second view with tabbar style
	nf_it = elm_naviframe_item_push(nf, "Using tabbar", NULL, NULL, content, "tabbar");

	// Create and set a toolbar into the tabbar part
	tabbar = create_tabbar_with_title(nf);
	elm_object_item_part_content_set(nf_it, "tabbar", tabbar);

}


static void
second_page_cb(Evas_Object *nf)
{
	Evas_Object *content, *btn;
	Elm_Object_Item *nf_it;

	// Set nocontents layout
	content = elm_layout_add(nf);
	elm_layout_theme_set(content, "layout", "nocontents", "default");
	elm_object_part_text_set(content, "elm.text", "Second Page" );

	// Push the first view
	nf_it = elm_naviframe_item_push(nf, "Using Naviframe", NULL, NULL, content, NULL);

	// Set left button on the title
	btn = elm_button_add(nf);
	elm_object_style_set(btn, "naviframe/title_left");
	elm_object_item_part_content_set(nf_it, "title_left_btn", btn);
	elm_object_text_set(btn, "Prev");
	evas_object_smart_callback_add(btn, "clicked", prev_btn_clicked_cb, nf);

	// Set right button on the title
	btn = elm_button_add(nf);
	elm_object_style_set(btn, "naviframe/title_right");
	elm_object_item_part_content_set(nf_it, "title_right_btn", btn);
	elm_object_text_set(btn, "Next");
	evas_object_smart_callback_add(btn, "clicked", third_page_cb, nf);


	// Set a callback for when a naviframe view is popped (hidden from the screen)
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, nf);

}


static void
first_page(void *data)
{
	appdata_s *ad = data;
	Evas_Object *btn;
	Elm_Object_Item *nf_it;

	Evas_Object *box;
	box = elm_box_add(ad->nf);
	elm_box_horizontal_set(box, EINA_FALSE);
	elm_box_homogeneous_set(box, EINA_TRUE);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_show(box);
	elm_win_resize_object_add(ad->nf, box);

	Evas_Object * entry = elm_entry_add(box);
	elm_object_text_set(entry,"entry");
	evas_object_show(entry);
	object_pack(box,entry,0.0,1.0,-1.0,0.9);

	Evas_Object * btn1 = elm_button_add(box);
	elm_object_text_set(btn1,"Click Here");
	evas_object_show(btn1);
	object_pack(box,btn1,0.0,1.0,-1.0,0.7);

	// Push the first view
	nf_it = elm_naviframe_item_push(ad->nf, "Using Naviframe", NULL, NULL, box, NULL);

	// Set left button on the title
	btn = elm_button_add(ad->nf);
	elm_object_style_set(btn, "naviframe/title_left");
	elm_object_item_part_content_set(nf_it, "title_left_btn", btn);
	elm_object_text_set(btn, "Prev");
	evas_object_smart_callback_add(btn, "clicked", prev_btn_clicked_cb, ad->nf);

	// Set right button on the title
	btn = elm_button_add(ad->nf);
	elm_object_style_set(btn, "naviframe/title_right");
	elm_object_item_part_content_set(nf_it, "title_right_btn", btn);
	elm_object_text_set(btn, "Next");
	evas_object_smart_callback_add(btn, "clicked", second_page_cb, ad->nf);


	// Set a callback for when a naviframe view is popped (hidden from the screen)
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_first_view_cb, ad->nf);

}

static void
create_base_gui(appdata_s *ad)
{
	/* Window */
	/* Create and initialize elm_win.
	   elm_win is mandatory to manipulate window. */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);
	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	/* Create and initialize elm_conformant.
	   elm_conformant is mandatory for base gui to have proper size
	   when indicator or virtual keypad is visible. */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	// Add the naviframe

	ad->nf = create_naviframe(ad->conform);
	elm_object_content_set(ad->conform, ad->nf);

	// Create the first view
	first_page(ad);

	/* Show window after base gui is set up */
	evas_object_show(ad->win);
}




static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
