#include "multiplescreenssupport.h"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *labelTitle;
	Evas_Object *image;
	Evas_Object *buttonOk;
	Evas_Object *buttonPrev;
	Evas_Object *buttonNext;
	Evas_Object *text;
} appdata_s;


static void
rotation_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	int current_degree = elm_win_rotation_get(obj);

	if (current_degree != 0 && current_degree != 180) {
		elm_grid_pack_set(ad->labelTitle, 15, 10, 30, 20);
		elm_grid_pack_set(ad->image, 50, 10, 35, 55);
		elm_grid_pack_set(ad->buttonOk, 50, 70, 35, 20);
		elm_grid_pack_set(ad->buttonPrev, 5, 30, 5, 40);
		elm_grid_pack_set(ad->buttonNext, 90, 30, 5, 40);

		evas_object_show(ad->text);
	} else {
		elm_grid_pack_set(ad->labelTitle, 20, 10, 60, 30);
		elm_grid_pack_set(ad->image, 20, 25, 60, 50);
		elm_grid_pack_set(ad->buttonOk, 20, 80, 60, 10);
		elm_grid_pack_set(ad->buttonPrev, 5, 35, 10, 30);
		elm_grid_pack_set(ad->buttonNext, 85, 35, 10, 30);

		evas_object_hide(ad->text);
	}
}

static void
win_delete_request_cb(void *data , Evas_Object *obj , void *event_info)
{
	elm_exit();
}

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}



static Evas_Object *
create_conform(Evas_Object *parent)
{
	Evas_Object *conform;

	if (parent == NULL)
		return NULL;

	conform = elm_conformant_add(parent);
	elm_win_indicator_mode_set(parent, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(parent, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(parent, conform);
	evas_object_show(conform);

	return conform;
}

static Evas_Object *
create_panel(Evas_Object *parent, appdata_s *ad)
{
	Evas_Object *panel, *grid;

	char buf[PATH_MAX], txt[60];


	/* Panel */
	panel = elm_panel_add(parent);
	elm_panel_orient_set(panel, ELM_PANEL_ORIENT_BOTTOM);
	evas_object_show(panel);

	/* Grid */
	grid = elm_grid_add(panel);
	evas_object_size_hint_weight_set(grid, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_content_set(panel, grid);

	/* Title label */
	ad->labelTitle = elm_label_add(grid);
	evas_object_size_hint_weight_set(ad->labelTitle, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(ad->labelTitle, EVAS_HINT_FILL, EVAS_HINT_FILL);
	snprintf(txt, sizeof(txt), "<font_size=%d><color=#000000>TITLE</color></font_size>", ELM_SCALE_SIZE(60));
	elm_object_text_set(ad->labelTitle, txt);
	elm_object_style_set(ad->labelTitle, "marker");
	evas_object_show(ad->labelTitle);
	elm_grid_pack(grid, ad->labelTitle, 20, 10, 60, 10);//30);

	/* Image */
	ad->image = elm_image_add(grid);
    snprintf(buf, sizeof(buf), "%s/img.png", ICON_DIR);
    elm_image_file_set(ad->image, buf, NULL);
	evas_object_show(ad->image);
	elm_grid_pack(grid, ad->image, 20, 25, 60, 50);

	/* Button OK */
	ad->buttonOk = elm_button_add(grid);
	evas_object_size_hint_weight_set(ad->buttonOk, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(ad->buttonOk, EVAS_HINT_FILL, EVAS_HINT_FILL);
	snprintf(txt, sizeof(txt), "<font_size=%d>OK</font_size>", ELM_SCALE_SIZE(50));
	elm_object_text_set(ad->buttonOk, txt);
	evas_object_show(ad->buttonOk);
	elm_grid_pack(grid, ad->buttonOk, 20, 80, 60, 10);


	/* Navigation buttons */
	ad->buttonPrev = elm_image_add(grid);
    snprintf(buf, sizeof(buf), "%s/nav_prev.png", ICON_DIR);
    elm_image_file_set(ad->buttonPrev, buf, NULL);
	evas_object_show(ad->buttonPrev);
	elm_grid_pack(grid, ad->buttonPrev, 5, 35, 10, 30);

	ad->buttonNext = elm_image_add(grid);
    snprintf(buf, sizeof(buf), "%s/nav_next.png", ICON_DIR);
    elm_image_file_set(ad->buttonNext, buf, NULL);
	evas_object_show(ad->buttonNext);
	elm_grid_pack(grid, ad->buttonNext, 85, 35, 10, 30);

	/* Text (only visible in landscape orientation) */
	ad->text = elm_label_add(grid);
	elm_object_text_set(ad->text, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
	elm_label_line_wrap_set(ad->text, ELM_WRAP_WORD);
	elm_label_ellipsis_set(ad->text, EINA_TRUE);
	elm_grid_pack(grid, ad->text, 15, 25, 30, 65);

	return panel;
}

static void
create_base_gui(appdata_s *ad)
{
	Evas_Object *grid, *panel;

	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	evas_object_smart_callback_add(ad->win, "wm,rotation,changed", rotation_cb, ad);
	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);
	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);


	/* Conformant */
	ad->conform = create_conform(ad->win);

	/* Grid */
	grid = elm_grid_add(ad->conform);
	evas_object_size_hint_weight_set(grid, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(grid, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_content_set(ad->conform, grid);

	/* Panel */
	panel = create_panel(grid, ad);
	elm_grid_pack(grid, panel, 0, 0, 100, 100);


	evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	appdata_s *ad = data;

	//elm_app_base_scale_set(1.8); // WVGA
	elm_app_base_scale_set(2.4); // HD


	create_base_gui(ad);

	return true;
}

static void
app_language_changed(void *data)
{
	/* Set the current language */
	char *locale = NULL;
	runtime_info_get_value_string(RUNTIME_INFO_KEY_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	app_event_callback_s event_callback = {0,};
	int ret = 0;

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;
	event_callback.language_changed = app_language_changed;

	event_callback.low_memory = NULL;
	event_callback.low_battery = NULL;
	event_callback.device_orientation = NULL;
	event_callback.region_format_changed = NULL;

	ret = app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
