window.onload = function() {

    function init() {

        // Fetch the HTML element
        var body = document.querySelector("body");

        // Assign Matter.js aliases to variables for easier usage
        var Engine = Matter.Engine,
            World = Matter.World,
            Body = Matter.Body,
            Bodies = Matter.Bodies,
            Composite = Matter.Composite,
            Composites = Matter.Composites,
            Constraint = Matter.Constraint,
            MouseConstraint = Matter.MouseConstraint,
            Events = Matter.Events;

        // Create the simulation engine, describe parameters and sets the rendering options
        var engine = Engine.create(body, {
            density: 0.0005,
            frictionAir: 0.06,
            restitution: 0.3,
            friction: 0.06,
            render: {
                options: {
                    showAngleIndicator: false,
                    isStatic: true,
                    wireframes: false,
                    width: 360,
                    height: 640,
                    background: "images/bg.png",
                    visible: false
                }
            }
        });

        // Static bodies - walls
        var ceiling = Bodies.rectangle(0, -28, 720, 60, {
            isStatic: true,
            render: {
                visible: false
            }
        });
        var ground = Bodies.rectangle(40, 650, 720, 60, {
            isStatic: true,
            render: {
                visible: false
            }
        });
        var wallLeft = Bodies.rectangle(-28, 310, 60, 650, {
            isStatic: true,
            render: {
                visible: false
            }
        });
        var wallRight = Bodies.rectangle(388, 310, 60, 650, {
            isStatic: true,
            render: {
                visible: false
            }
        });

        // Dynamic bodies
        var pencil = Bodies.rectangle(130, 200, 39, 227, {
            render: {
                sprite: {
                    texture: "images/p1.png"
                }
            }
        });

        var marker = Bodies.rectangle(160, 50, 39, 227, {
            render: {
                sprite: {
                    texture: "images/p2.png"
                }
            }
        });


        var chip = Bodies.circle(250, 50, 65, {
            render: {
                sprite: {
                    texture: "images/chip_20.png"
                }
            }
        });

        var chamferedBox = Bodies.rectangle(100, 100, 74, 138, {
            chamfer: {
                radius: [25, 25, 25, 25]
            },
            render: {
                sprite: {
                    texture: "images/eraser.png"
                }
            }
        });

        // Rope
        var group = Body.nextGroup(true);

        var rope = Composites.stack(180, -10, 3, 2, 0, 0, function(x, y) {
            return Bodies.rectangle(x, y, 50, 20, {
                collisionFilter: {
                    group: group
                },
                render: {
                    sprite: {
                        texture: "images/rope2.png"
                    }
                }
            });
        });

        Composites.chain(rope, 0.5, 0, -0.4, 0, {
            stiffness: 0.8,
            length: 2
        });
        Composite.add(rope, Constraint.create({
            bodyB: rope.bodies[0],
            pointB: {
                x: -25,
                y: 0
            },
            pointA: {
                x: 180,
                y: 0
            },
            stiffness: 0.5
        }));

        var counter = 0;

        Events.on(engine, "beforeUpdate", function(event) {
            counter += 1;

            if (counter >= 60 * 3) {
                Body.setVelocity(chip, {
                    x: 0,
                    y: -20
                });
                Body.setAngle(chip, -Math.PI * 0.2);
                Body.setAngularVelocity(chip, 0.2);

                // reset counter
                counter = 0;
            }

        });


        // Mouse constraint (touching and moving bodies)
        var mouseConstraint = MouseConstraint.create(engine);

        // add all of the bodies to the world
        World.add(engine.world, [pencil, marker, chip, ceiling, ground, wallLeft, wallRight, chamferedBox, rope, mouseConstraint]);

        // Fire up the 2D engine
        Engine.run(engine);

    }

    init();

    // add eventListener for tizenhwkey
    document.addEventListener("tizenhwkey", function(e) {
        if (e.keyName === "back") {
            try {
                tizen.application.getCurrentApplication().exit();
            } catch (ignore) {}
        }
    });

};