var FUEL_CYCLE_LENGTH = 6;
var GRAVITY = 10;
var FILTER_NUM = 18;

var stage;

var background, background_image;
var lander, lander_image;

var backGroundLayer;
var gameLayer;
var uiLayer;
var padLayer;

var carrier

var accelerationX, accelerationY;
var intX, intY, intZ;

var acc;
var gravAcc = 0;

var microFuelCycle = 0;

var altitude, currentAlt, lastAlt;

var inAir = true;

var meters, speedMeter, fuelMeter, rotationMeter;
var timer;
var speed;

var filtertxt, filter_button;

var carrier_tween;

var textpath;

var fuel = 100;

var currentFilter = 0;

var images = {};

//Initialize function
var init = function () {
    // TODO:: Do your initialization job
    console.log("init() called");
   
    // ********* REQUEST ANIMATION FRAME SHIM *********
    
    window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame ||
    window.webkitRequestAnimationFrame || window.oRequestAnimationFrame;
    
    gameWidth = window.innerWidth;
    gameHeight = window.innerHeight;
    
    // ********* ACCELEROMETER ********
    
 // ADD AN ACCELEROMETER EVENT TO THE WINDOW OBJECT IN ORDER TO GATHER THE ACCELEROMETER DATA FROM THE DEVICE   
	   window.addEventListener("devicemotion", accelerometerUpdate, true);
    
    //window.ondevicemotion = accelerometer; // START USING THE ACCELEROMETER
    
    function accelerometerUpdate(event) {

		var	accelerationX = event.accelerationIncludingGravity.x;
		var	accelerationY = event.accelerationIncludingGravity.y;
		var accelerationZ = event.accelerationIncludingGravity.z;

			intX = Math.floor(accelerationX);
			intY = Math.floor(accelerationY) - 3;
			intZ = Math.floor(accelerationZ);

    }
    
    // ********* LOAD ASSETS *********    
   
    var sources = {
            bg: 'images/bg.png',
            lander: 'images/landerspritesheet.png',
            landingpad: 'images/landingpad.png',
            button: 'images/button.png',
            carrier: 'images/carrier.png'
          };

    loadImages(sources);
    
    function loadImages(sources) {
        
    	console.log("load images");
    	
        var loadedImages = 0;
        var numImages = 0;
        for(var src in sources) {
          numImages++;
        }
        for(var src in sources) {
          images[src] = new Image();
          images[src].onload = function() {
            if(++loadedImages >= numImages) {
            	
            	buildGame();
            	
            }
          };
          images[src].src = sources[src];
         
        }
      }
    
    function buildGame() {
    
    	console.log("build the game");
    	
    // ********* CREATE THE STAGE *********
    
        stage = new Kinetic.Stage({
        container: 'container',
        width: gameWidth,
        height: gameHeight
      });
    
        
    // ********* CREATE THE LAYERS *********
    
	    backGroundLayer = new Kinetic.Layer();
	    gameLayer = new Kinetic.Layer();
	    padLayer = new Kinetic.Layer();
	    uiLayer = new Kinetic.Layer();
	    
	// ********* CREATE THE CARRIER BACKGROUND CRAFT ****************
	    
	    carrier = new Kinetic.Image({
	        x: gameWidth + 100,
	        y: 300,
	        image: images.carrier,
	        width: 66,
	        height: 81
        });
	    
	    gameLayer.add(carrier);
	    
	// ********* TWEEN THE CARRIER WITH KINETIC.JS INTERNAL TWEEN ENGINE ********
        
        carrier_tween = new Kinetic.Tween({
            node: carrier, 
            duration: 9,
            x: -200,
            easing: Kinetic.Easings.EaseInOut,
            onFinish: function() { // generate a random position for the carrier ship
            	
            	var randY = 200 + Math.round(Math.random()*200);
            	
                carrier.setX(gameWidth+100);
                carrier.setY(randY);
                
                carrier_tween.seek(0); // get the postition of the tween to the 0th second of its animation
                carrier_tween.play();
            }
        });        
    
        carrier_tween.play();
        
    // ********* CREATE GAME OBJECTS - JS PROTOTYPED CLASSESS ********
    
    function Ship(_x, _y) { // our lander ship class
    	
    		this.lander = new Kinetic.Sprite({
	           x: _x,
	           y: _y,
	           image: images.lander,
	           animation: 'propulsion_off',
	           animations: {
	             propulsion_off: [
	               // x, y, width, height (4 frames)
	               0,0,33,61
	             ],
	             propulsion_on: [
	               // x, y, width, height (3 frames)
	               33,0,33,61,
	               66,0,33,61,
	               99,0,33,61
	             ]
	           },
	           frameRate: 25,
	           frameIndex: 0
	         });
    	
    		gameLayer.add(this.lander);
    		this.lander.start();
    		

    		this.getX = function() {
    			
    			return this.lander.getPosition().x;
    			
    		}
    		
    		this.getY = function() {
    			
    			return this.lander.getPosition().y;
    			
    		}
    		
    		this.setX = function(_x) {
    			
    			this.lander.x(_x);
    			
    		}
    		
    		this.setY = function(_y) {
    			
    			this.lander.y(_y);
    			
    		}
    		
    		this.setPos = function(_x,_y) {
    			
    			this.lander.x(_x);
    			this.lander.y(_y);
    			
    		}
    		
    		this.setRotation = function(_r) {
    			
    			this.lander.rotation(_r);
    			
    		}
    		
    		this.getRotation = function() {
    			
    			return this.lander.rotation();
    			
    		}
    		
    		this.setThrust = function(_thrust) {
    			
    			switch(_thrust) {
    				
	    			case "up":
	    				this.lander.animation('propulsion_on');
	    			break;
	    			
	    			case "down":
	    				this.lander.animation('propulsion_off');
	    			break;
    				
    			}
    		}
    			
    }
    
    // ********* LANDING PAD CLASS ********
    
    function LandingPad() {
    	
    	this.landingPad = new Kinetic.Image({
	        x: -200,
	        y: gameHeight - 46,
	        image: images.landingpad,
	        width: 85,
	        height: 37
       });
    	
       padLayer.add(this.landingPad);
       
       this.generateRandomLocation = function() {
    	   
    	   var randX = Math.round(Math.random() * (gameWidth - this.landingPad.getWidth()));
    	   	   this.landingPad.setX(randX);
    	   	   
    	   	   console.log("RAND X = " + randX);
    	   
       }
    }
    
    // ********* CREATE THE UI ********
    
       meters = new Kinetic.Text({
    	  x: 5,
    	  y: 5,
    	  text: '',
    	  fontSize: 15,
    	  fontFamily: 'Courier',
    	  fill: 'white'
    	});
       
       speedMeter = new Kinetic.Text({
     	  x: 5,
     	  y: 20,
     	  text: '',
     	  fontSize: 15,
     	  fontFamily: 'Courier',
     	  fill: 'white'
     	});
       
       rotationMeter = new Kinetic.Text({
       	  x: 5,
       	  y: 35,
       	  text: '',
       	  fontSize: 15,
       	  fontFamily: 'Courier',
       	  fill: 'white'
       	});
       
       fuelMeter = new Kinetic.Text({
       	  x: 5,
       	  y: 50,
       	  text: '',
       	  fontSize: 15,
       	  fontFamily: 'Courier',
       	  fill: 'white'
       	});
       
       filtertxt = new Kinetic.Text({
        	  x: 5,
        	  y: 80,
        	  text: '',
        	  fontSize: 15,
        	  fontFamily: 'Courier',
        	  fill: 'white'
        	});
       
       filter_button = new Kinetic.Image({
    	   x: 5,
    	   y: 120,
    	   image: images.button,
	       width: 118,
	       height: 47,
	       scaleX: 0.8,
	       scaleY: 0.8
       });
        
        uiLayer.add(meters);
        uiLayer.add(speedMeter);
        uiLayer.add(fuelMeter);
        uiLayer.add(rotationMeter);
        uiLayer.add(filtertxt);
        
        uiLayer.add(filter_button);
        
    // ********* ADD CLICK EVENT TO THE BUTTON *********   

	       filter_button.on('touchstart', function(event) {
	    	   
	    	   if (currentFilter < FILTER_NUM)
	    	   {
	    		   
	    		   currentFilter++;
	    		   
	    	   }
	    	   else
	    	   {
	    		   
	    		   currentFilter = 0;
	    		   
	    	   }
		    	
	    	   applyFilter(currentFilter, background);
	    	   
		   });
        
    // ********* CREATE THE BACKGROUND *********
     
	       background = new Kinetic.Image({
		        x: 0,
		        y: 0,
		        image: images.bg,
		        width: 360,
		        height: 640,
		        listening: true
	       });
	              		    
	       backGroundLayer.add(background);
	       
	       textpath = new Kinetic.TextPath({
	           x: gameWidth/2,
	           y: gameHeight/2,
	           fill: '#000',
	           fontSize: '16',
	           fontFamily: 'Arial',
	           text: 'This  example  shows  how  you  can  utilize  the SVG paths to  draw  text over  a  path.',
	           data: 'm1,71.642052l25.857967,-44.784084l44.784084,-25.857967l51.715858,0l44.784027,25.857967l25.858078,44.784084l0,51.715858l-25.858078,44.784027l-44.784027,25.858078l-51.715858,0l-44.784084,-25.858078l-25.857967,-44.784027l0,-51.715858z',
	           offset: {x:97, y:97} // set the anchor point of the SVG shape in its middle
	         });
	       
	       backGroundLayer.add(textpath);
	       
	       // a visual SVG editor ---> http://svg-edit.googlecode.com/svn/branches/2.6/editor/svg-editor.html
	 	  
    // ********* ADD THE GRAPHIC LAYERS ********
    
        stage.add(backGroundLayer);
        stage.add(padLayer);
        stage.add(gameLayer);
        stage.add(uiLayer);
        
    // ********* ADD GAME ITEMS ********
        
        var pad = new LandingPad();
        	pad.generateRandomLocation();
        
        var ship = new Ship(gameWidth/2 - 16, -40);
          
    // ********* SET SPEED TIMER **********
        
        timer = setInterval(function(){

        	currentAlt = altitude;
        	
        	if (lastAlt != null) {
        		
        		speed = currentAlt - lastAlt;
        		console.log("SPEED = " + speed);
        		
        	}
        	
        	lastAlt = currentAlt;
        
        }, 1000);
        
    // ********* UPDATE AND RENDER THE GAME **********    
        
	    function draw() {
	    	
	    	textpath.rotate(1);
	    	
	    	if (intX == undefined || intY == undefined || intZ == undefined) // CHECK IF THERE ARE READINGS FROM THE ACCELEROMETER
			{
				intX = 0;
				intY = 0;
				intZ = 0;
			}
	    	
	    	if (inAir == true) // WHEN THE SHIP IS IN THE AIR
	    	{
	    		
	    		gravAcc += 0.1;  
	
	    		if (intY > 0 || fuel <= 0)
	    		{
	    			intY = 0;
	    		}
	    		
	    		gravAcc = gravAcc + intY / 30;
	    	
	    		if (intY < 0) { // add micro fuel cycle value
	    			
	    			microFuelCycle++;
	    			
	    		}
	    		
	    		if (microFuelCycle > FUEL_CYCLE_LENGTH) { // if micro fuel cycle ends then decrease 1% from the fuel value and restart the fuel cycle
	    			fuel--;
	    			microFuelCycle = 0;
	    		}
	    		
	    		if (fuel <= 0) { // if the fuel value is lower than 0 make it 0
	    			
	    			fuel = 0; 			
	    		}
	    	
	    		acc = (GRAVITY + gravAcc) / 100; // count our landers' acceleration	
	    		
		    	accSide = intX / 10; // determine the side movement of the lander
		   
		    	ship.setY(ship.getY() + acc); // set the ships Y position
		    	ship.setX(ship.getX() - accSide); // set the ships X position
		    	
		    	if (ship.getRotation() > 0) {
		    		ship.setRotation(ship.getRotation() - 0.25);
		    	}
		    	
		    	if (ship.getRotation() < 0) {
		    		ship.setRotation(ship.getRotation() + 0.25);
		    	}
		    	
		    	ship.setRotation(ship.getRotation() - accSide);
	    	}
	    	
	    	if (ship.getY() > gameHeight - 50) { // WHEN THE SHIP HAS LANDED TURN OFF THE GAME CONTROLS
	    		inAir = false;
	    		ship.setY(gameHeight - 50);
	    		
	    		ship.setThrust('propulsion_off');
	    		
	    		speed = 0;
	    		clearInterval(timer);
	    		timer = null;

	    	}
	    	
	    	if (intY < 0 && inAir == true)
	    	{
	    	    ship.setThrust("up");
	    	}
	    	else
	    	{
	    		ship.setThrust("down");
	    	}
	    	
	    	if (fuel <= 0) ship.setThrust("down");
	    	
	    	altitude = Math.floor((gameHeight - 50) - ship.getY());
	    	
	    	meters.setText("ALTITUDE: " + altitude + " m");
	    	if (speed != undefined) {
	    		speedMeter.setText("SPEED: " + (speed * -1) + " m/s");
	    	}
	    	else
	    	{
	    		speedMeter.setText("SPEED: ");
	    	}
	    	fuelMeter.setText("FUEL: " + fuel + "%");
	    	rotationMeter.setText("ROTATION: " + Math.floor(ship.getRotation()) + "°")
	    	
	    		
		    	backGroundLayer.batchDraw();
		    	padLayer.batchDraw();
		    	gameLayer.batchDraw();
		    	uiLayer.batchDraw();
		    	
		    	requestAnimationFrame(draw);
	    	
	    }
    
    draw();
    
    	function showFilter(_text) {
    		
    		filtertxt.setText("filter: \n" + _text);
    		
    	}
    	
	    	function applyFilter(_filterNum, _node) {
	    		
	    		if (_node != null && _filterNum != null && _filterNum < FILTER_NUM) {
	    		
	    		_node.cache();
	    		
		    		switch(_filterNum) {
		            
			        case 0:
			        	_node.filters([Kinetic.Filters.Blur]);
			        	_node.blurRadius(6);
			             
			             showFilter("Kinetic.Filters.Blur");
			             
			        break;
			        
			        case 1:
			        	_node.filters([Kinetic.Filters.Brighten]);
			        	_node.brightness(-0.4);
			            
			            showFilter("Kinetic.Filters.Brighten");
				    break;
				    
			        case 2:
			        	_node.filters([Kinetic.Filters.Emboss]);
			        	_node.embossStrength(1);
			        	_node.embossWhiteLevel(0.7);
			        	_node.embossDirection('top-right');
			        	_node.embossBlend(true);
			             
			             showFilter("Kinetic.Filters.Emboss");
					break;
					
			        case 3:
			        	_node.filters([Kinetic.Filters.Enhance]);
			        	_node.enhance(0.01);
			            
			            showFilter("Kinetic.Filters.Enhance");
				    break;
			        
			        case 4:
			        	_node.filters([Kinetic.Filters.Grayscale]);
			        	
			        	showFilter("Kinetic.Filters.Grayscale");
					break;
					
			        case 5:
			        	_node.filters([Kinetic.Filters.HSL]);
			        	_node.hue(220);
			        	_node.saturation(0.5);
			        	_node.luminance(-0.25);
			            
			            showFilter("Kinetic.Filters.HSL");
					break;
		        
			        case 6:
			        	_node.filters([Kinetic.Filters.HSV]);
			        	_node.hue(120);
			        	_node.saturation(-0.5);
			        	_node.luminance(0.1);
			             
			             showFilter("Kinetic.Filters.HSV");
					break;
					
			        case 7:
			        	_node.filters([Kinetic.Filters.Invert]);
			        	
			        	showFilter("Kinetic.Filters.Invert");
					break;
					
			        case 8:
			        	_node.filters([Kinetic.Filters.Kaleidoscope]);
			        	_node.kaleidoscopePower(2);
			        	_node.kaleidoscopeAngle(45);
			             
			             showFilter("Kinetic.Filters.Kaleidoscope");
					break;
					
			        case 9:
			        	_node.filters([Kinetic.Filters.Noise]);
			        	_node.noise(0.2);
			            
			            showFilter("Kinetic.Filters.Noise");
					break;
					
			        case 10:
			        	_node.filters([Kinetic.Filters.Pixelate]);
			        	_node.pixelSize(20);
			            
			            showFilter("Kinetic.Filters.Pixelate");
					break;
					
			        case 11:
			        	_node.filters([Kinetic.Filters.Posterize]);
			        	_node.levels(0.01);
			            
			            showFilter("Kinetic.Filters.Posterize");
					break;
					
			        case 12:
			        	_node.filters([Kinetic.Filters.Posterize]);
			        	_node.levels(0.01);
			             
			             showFilter("Kinetic.Filters.Posterize");
					break;
					
			        case 13:
			        	_node.filters([Kinetic.Filters.RGB]);
			        	_node.red(200);
			        	_node.green(100);
			        	_node.blue(50);
			             
			             showFilter("Kinetic.Filters.RGB");
			        break;
			        
			        case 14:
			        	_node.filters([Kinetic.Filters.Sepia]);
			        	
			        	showFilter("Kinetic.Filters.Sepia");
				    break;
				    
			        case 15:
			        	_node.filters([Kinetic.Filters.Solarize]);
			        	
			        	showFilter("Kinetic.Filters.Solarize");
				    break;
				    
			        case 16:
			        	_node.filters([Kinetic.Filters.Threshold]);
			        	_node.threshold(0.5);
			             
			             showFilter("Kinetic.Filters.Threshold");
				    break;
				    
			        case 17:
			        	_node.filters([Kinetic.Filters.Mask]);
			        	_node.threshold(0.1);
			            
			            showFilter("Kinetic.Filters.Mask");
				    break;
				    
	    		}
	    		
				
	        }
    		
    	}
    
    }
    // add eventListener for tizenhwkey
    document.addEventListener('tizenhwkey', function(e) {
        if(e.keyName == "back")
            tizen.application.getCurrentApplication().exit();
    });
};
// window.onload can work without <body onload="">
window.onload = init;
