var FUEL_CYCLE_LENGTH = 6;
var GRAVITY = 10;

var stage;

var background, background_image;
var lander, lander_image;

var backGroundLayer;
var gameLayer;
var uiLayer;
var padLayer;

var accelerationX, accelerationY;
var intX, intY, intZ;

var acc;
var gravAcc = 0;

var microFuelCycle = 0;

var altitude, currentAlt, lastAlt;

var inAir = true;

var meters, speedMeter, fuelMeter, rotationMeter;
var timer;
var speed;

var fuel = 100;

var images = {};

//Initialize function
var init = function () {
    // TODO:: Do your initialization job
    console.log("init() called");
   
    // ********* REQUEST ANIMATION FRAME SHIM *********
    
    window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame ||
    window.webkitRequestAnimationFrame || window.oRequestAnimationFrame;
    
    gameWidth = window.innerWidth;
    gameHeight = window.innerHeight;
    
    // ********* ACCELEROMETER ********
    
 // ADD AN ACCELEROMETER EVENT TO THE WINDOW OBJECT IN ORDER TO GATHER THE ACCELEROMETER DATA FROM THE DEVICE   
	   window.addEventListener("devicemotion", accelerometerUpdate, true);
    
    //window.ondevicemotion = accelerometer; // START USING THE ACCELEROMETER
    
    function accelerometerUpdate(event) {

		var	accelerationX = event.accelerationIncludingGravity.x;
		var	accelerationY = event.accelerationIncludingGravity.y;
		var accelerationZ = event.accelerationIncludingGravity.z;

			intX = Math.floor(accelerationX);
			intY = Math.floor(accelerationY) - 3;
			intZ = Math.floor(accelerationZ);

    }
    
    // ********* LOAD ASSETS *********    
   
    var sources = {
            bg: 'images/bg.png',
            lander: 'images/landerspritesheet.png',
            landingpad: 'images/landingpad.png'
          };

    loadImages(sources);
    
    function loadImages(sources) {
        
    	console.log("load images");
    	
        var loadedImages = 0;
        var numImages = 0;
        for(var src in sources) {
          numImages++;
        }
        for(var src in sources) {
          images[src] = new Image();
          images[src].onload = function() {
            if(++loadedImages >= numImages) {
            	
            	buildGame();
            	
            }
          };
          images[src].src = sources[src];
         
        }
      }
    
    function buildGame() {
    
    	console.log("build game");
    	
    // ********* CREATE THE STAGE *********
    
        stage = new Kinetic.Stage({
        container: 'container',
        width: gameWidth,
        height: gameHeight
      });
    
        
    // ********* CREATE THE LAYERS *********
    
	    backGroundLayer = new Kinetic.Layer();
	    gameLayer = new Kinetic.Layer();
	    padLayer = new Kinetic.Layer();
	    uiLayer = new Kinetic.Layer();
    
    // ********* CREATE GAME OBJECTS - JS PROTOTYPED CLASSESS ********
    
    function Ship(_x, _y) { // our lander ship class
    	
    		this.lander = new Kinetic.Sprite({
	           x: _x,
	           y: _y,
	           image: images.lander,
	           animation: 'propulsion_off',
	           animations: {
	             propulsion_off: [
	               // x, y, width, height (4 frames)
	               0,0,33,61
	             ],
	             propulsion_on: [
	               // x, y, width, height (3 frames)
	               33,0,33,61,
	               66,0,33,61,
	               99,0,33,61
	             ]
	           },
	           frameRate: 25,
	           frameIndex: 0
	         });
    	
    		gameLayer.add(this.lander);
    		this.lander.start();
    		

    		this.getX = function() {
    			
    			return this.lander.getPosition().x;
    			
    		}
    		
    		this.getY = function() {
    			
    			return this.lander.getPosition().y;
    			
    		}
    		
    		this.setX = function(_x) {
    			
    			this.lander.x(_x);
    			
    		}
    		
    		this.setY = function(_y) {
    			
    			this.lander.y(_y);
    			
    		}
    		
    		this.setPos = function(_x,_y) {
    			
    			this.lander.x(_x);
    			this.lander.y(_y);
    			
    		}
    		
    		this.setRotation = function(_r) {
    			
    			this.lander.rotation(_r);
    			
    		}
    		
    		this.getRotation = function() {
    			
    			return this.lander.rotation();
    			
    		}
    		
    		this.setThrust = function(_thrust) {
    			
    			switch(_thrust) {
    				
	    			case "up":
	    				this.lander.animation('propulsion_on');
	    			break;
	    			
	    			case "down":
	    				this.lander.animation('propulsion_off');
	    			break;
    				
    			}
    		}
    			
    }
    
    // ********* LANDING PAD CLASS ********
    
    function LandingPad() {
    	
    	this.landingPad = new Kinetic.Image({
	        x: -200,
	        y: gameHeight - 46,
	        image: images.landingpad,
	        width: 85,
	        height: 37
       });
    	
       padLayer.add(this.landingPad);
       
       this.generateRandomLocation = function() {
    	   
    	   var randX = Math.round(Math.random() * (gameWidth - this.landingPad.getWidth()));
    	   	   this.landingPad.setX(randX);
    	   	   
    	   	   console.log("RAND X = " + randX);
    	   
       }
    }
    
    // ********* CREATE THE UI ********
    
       meters = new Kinetic.Text({
    	  x: 5,
    	  y: 5,
    	  text: '',
    	  fontSize: 15,
    	  fontFamily: 'Courier',
    	  fill: 'white'
    	});
       
       speedMeter = new Kinetic.Text({
     	  x: 5,
     	  y: 20,
     	  text: '',
     	  fontSize: 15,
     	  fontFamily: 'Courier',
     	  fill: 'white'
     	});
       
       rotationMeter = new Kinetic.Text({
       	  x: 5,
       	  y: 35,
       	  text: '',
       	  fontSize: 15,
       	  fontFamily: 'Courier',
       	  fill: 'white'
       	});
       
       fuelMeter = new Kinetic.Text({
       	  x: 5,
       	  y: 50,
       	  text: '',
       	  fontSize: 15,
       	  fontFamily: 'Courier',
       	  fill: 'white'
       	});
       
       var debugtxt = new Kinetic.Text({
        	  x: 5,
        	  y: 80,
        	  text: '',
        	  fontSize: 15,
        	  fontFamily: 'Courier',
        	  fill: 'white'
        	});
        
       //debugtxt.visible = false;
       
        uiLayer.add(meters);
        uiLayer.add(speedMeter);
        uiLayer.add(fuelMeter);
        uiLayer.add(rotationMeter);
        uiLayer.add(debugtxt);
        
    // ********* CREATE THE BACKGROUND *********
     
	       background = new Kinetic.Image({
		        x: 0,
		        y: 0,
		        image: images.bg,
		        width: 360,
		        height: 640
	       });
	              
	       backGroundLayer.add(background);
    	   
    // ********* ADD THE GRAPHIC LAYERS ********GOOD
    
        stage.add(backGroundLayer);
        stage.add(padLayer);
        stage.add(gameLayer);
        stage.add(uiLayer);
        
    // ********* ADD GAME ITEMS ********
        
        var pad = new LandingPad();
        	pad.generateRandomLocation();
        
        var ship = new Ship(gameWidth/2 - 16, -40);
          
    // ********* SET SPEED TIMER **********
        
        timer = setInterval(function(){

        	currentAlt = altitude;
        	
        	if (lastAlt != null) {
        		
        		speed = currentAlt - lastAlt;
        		console.log("SPEED = " + speed);
        		
        	}
        	
        	lastAlt = currentAlt;
        
        }, 1000);
        
    // ********* UPDATE AND RENDER THE GAME **********    
        
	    function draw() {
	    		
	    	if (intX == undefined || intY == undefined || intZ == undefined) // CHECK IF THERE ARE READINGS FROM THE ACCELEROMETER
			{
				intX = 0;
				intY = 0;
				intZ = 0;
			}
	    	
	    	if (inAir == true) // WHEN THE SHIP IS IN THE AIR
	    	{
	    		
	    		gravAcc += 0.1;  
	
	    		if (intY > 0 || fuel <= 0)
	    		{
	    			intY = 0;
	    		}
	    		
	    		gravAcc = gravAcc + intY / 30;
	    	
	    		if (intY < 0) { // add micro fuel cycle value
	    			
	    			microFuelCycle++;
	    			
	    		}
	    		
	    		if (microFuelCycle > FUEL_CYCLE_LENGTH) { // if micro fuel cycle ends then decrease 1% from the fuel value and restart the fuel cycle
	    			fuel--;
	    			microFuelCycle = 0;
	    		}
	    		
	    		if (fuel <= 0) { // if the fuel value is lower than 0 make it 0
	    			
	    			fuel = 0; 			
	    		}
	    	
	    		acc = (GRAVITY + gravAcc) / 100; // count our landers' acceleration	
	    		
		    	accSide = intX / 10; // determine the side movement of the lander
		   
		    	ship.setY(ship.getY() + acc); // set the ships Y position
		    	ship.setX(ship.getX() - accSide); // set the ships X position
		    	
		    	if (ship.getRotation() > 0) {
		    		ship.setRotation(ship.getRotation() - 0.25);
		    	}
		    	
		    	if (ship.getRotation() < 0) {
		    		ship.setRotation(ship.getRotation() + 0.25);
		    	}
		    	
		    	ship.setRotation(ship.getRotation() - accSide);
	    	}
	    	
	    	if (ship.getY() > gameHeight - 50) { // WHEN THE SHIP HAS LANDED TURN OFF THE GAME CONTROLS
	    		inAir = false;
	    		ship.setY(gameHeight - 50);
	    		
	    		ship.setThrust('propulsion_off');
	    		
	    		speed = 0;
	    		clearInterval(timer);
	    		timer = null;

	    	}
	    	
	    	if (intY < 0 && inAir == true)
	    	{
	    	    ship.setThrust("up");
	    	}
	    	else
	    	{
	    		ship.setThrust("down");
	    	}
	    	
	    	if (fuel <= 0) ship.setThrust("down");
	    	
	    	altitude = Math.floor((gameHeight - 50) - ship.getY());
	    	
	    	meters.setText("ALTITUDE: " + altitude + " m");
	    	if (speed != undefined) {
	    		speedMeter.setText("SPEED: " + (speed * -1) + " m/s");
	    	}
	    	else
	    	{
	    		speedMeter.setText("SPEED: ");
	    	}
	    	fuelMeter.setText("FUEL: " + fuel + "%");
	    	rotationMeter.setText("ROTATION: " + Math.floor(ship.getRotation()) + "°")
	    	
		    	backGroundLayer.batchDraw();
		    	padLayer.batchDraw();
		    	gameLayer.batchDraw();
		    	uiLayer.batchDraw();
		    	
		    	requestAnimationFrame(draw);
	    	
	    }
    
    draw();
    
    }
    // add eventListener for tizenhwkey
    document.addEventListener('tizenhwkey', function(e) {
        if(e.keyName == "back")
            tizen.application.getCurrentApplication().exit();
    });
};
// window.onload can work without <body onload="">
window.onload = init;
