//Initialize function
var init = function () {
    // TODO:: Do your initialization job
    console.log("init() called");

    // add eventListener for tizenhwkey
    document.addEventListener('tizenhwkey', function(e) {
        if(e.keyName == "back")
            tizen.application.getCurrentApplication().exit();
    });
   
//image marking
    var LeafIcon = L.Icon.extend({
    	options: {
    		shadowUrl: 'leaf-shadow.png',
    		iconSize:     [30, 50],
    		//shadowSize:   [50, 64],
    		iconAnchor:   [22, 94],
    		//shadowAnchor: [4, 62],
    		popupAnchor:  [-3, -76]
    	}
    });
   
    var charminarIcon = new LeafIcon({iconUrl: 'images.jpeg'}),
    	cybertowersIcon = new LeafIcon({iconUrl: 'cybertowers.jpg'});
    	airportIcon=new LeafIcon({iconUrl: 'airport.jpg'});
    	stadiumIcon=new LeafIcon({iconUrl: 'stadium.jpg'});
    	chilkurIcon=new LeafIcon({iconUrl: 'chilkur.jpg'});
    	
    var charminar=L.marker([17.361550500000000000, 78.474750399999950000], {icon: charminarIcon}).bindPopup("Charminar");
    	cybertowers=L.marker([17.522695, 78.35658969999997], {icon: cybertowersIcon}).bindPopup("Cyber towers");
    	airport=L.marker([17.236659700000000000, 78.429731800000010000], {icon:airportIcon}).bindPopup("RGI airport");
    	stadium=L.marker([17.406552, 78.55052079999996], {icon: stadiumIcon}).bindPopup("RGI Stadium");
    	chilkur=L.marker([17.357242400000000000,78.300109000000020000], {icon: chilkurIcon}).bindPopup("Balaji temple,chilkur");
    	
    var circle = L.circle([17.435943700000000000, 78.341673099999980000], 1000, {
    	color: 'red',
    	fillColor: '#f03',
    	fillOpacity: 0.5
    	});
    	circle.bindPopup("Gachibowli");    	
    	var polygon = L.polygon([
    	                         [17.31918, 78.52066],
    	                          [17.27066, 78.57971],
    	                          [17.36375, 78.62091]
    	                     ]);
    polygon.bindPopup("usage of polygons in maps");    
    	var areas = L.layerGroup([charminar,cybertowers,airport,stadium,chilkur,circle,polygon]);
       
    	var cloudmadeUrl = 'http://{s}.tile.cloudmade.com/307137a7270b4513ade1775674f6751a/{styleId}/256/{z}/{x}/{y}.png',
    		cloudmadeAttribution = 'Map data &copy; <a href="http://openstreetmap.org">OpenStreetMap</a> ';
    	var minimal   = L.tileLayer(cloudmadeUrl, {styleId: 22677, attribution: cloudmadeAttribution}),
    		midnight  = L.tileLayer(cloudmadeUrl, {styleId: 999,   attribution: cloudmadeAttribution}),
    		motorways = L.tileLayer(cloudmadeUrl, {styleId: 46561, attribution: cloudmadeAttribution});

    	var map = L.map('map', {
    		center: new L.LatLng(17.3660, 78.4760),
    		zoom: 10,
    		layers: [minimal, motorways, areas]
    	});
       
    	var baseMaps = {
    			"Minimal": minimal,
    			"Night View": midnight
    		};

    	var overlayMaps = {
    			"Motorways": motorways,
    			"Cities": areas
    	};
    		
    	L.control.layers(baseMaps, overlayMaps).addTo(map);	
    		 
    	document.getElementById('map').style.display = 'block';
    	setTimeout(map.invalidateSize.bind(map));
    	var popup = L.popup();
    	function onMapClick(e) {
    		popup
    		.setLatLng(e.latlng)
    		.setContent("You clicked the map at " + e.latlng.toString())
    		.openOn(map);
    	}
    	
    	
    	map.on('click', onMapClick);
    	L.control.scale('topright').addTo(map);

    	
    
    	
};
$(document).bind('pageinit', init);