//Initialize function
var init = function () {
    // TODO:: Do your initialization job
    console.log("init() called");

    // CONSTANTS
    var BUTTON_PADDING = 10;
    
    // VARIABLES
    var backgroundsArray = [];
    
    var game;
    var bg_wdith;
    var player;
   
    var map;
    var layer1;
    
    var left, right, up;
    
    var goLeft = false;
    var goRight = false; 
    var goUp = false;
    
    var moveableItemGroup;
    var itemGroup;
  
    var uiGroup;
    
    var pointsTxt;
    var points = 0;
    
    var jumpTimer = 0;
    
    var gameHeight, gameWidth;
   
    // SETUP THE PHASER ENGINE
    
    	gameHeight = window.innerHeight; // we have landscape mode so our window.innerWidth will be our gameWidth
    	gameWidth = window.innerWidth; // we have landscape mode so our window.innerHeight will be our gameHeight
    	
    	game = new Phaser.Game(gameWidth, gameHeight, Phaser.CANVAS, '', {preload: preloadGame, create: createGame, update: updateGame, render: renderGame});
        
    // LOADING GAME ASSETS
    	
    function preloadGame() {
    	game.load.image('background', 'images/bg.png');
    	game.load.image('left', 'images/left.png');
    	game.load.image('right', 'images/right.png');
    	game.load.image('up', 'images/up.png');
    	game.load.image('rock', 'images/log.png');
    	game.load.image('ground_tile', 'images/floor_tile.png');
    	game.load.image('hud', 'images/hudPoints.png');
    	
    	game.load.spritesheet('player', 'images/phaserPlayerSpriteSheet.png', 36, 36);
    	game.load.spritesheet('collectable', 'images/itemSpriteSheet.png', 36, 36);
    }
    
	    var stats = new Stats();
		    stats.setMode(0); // 0 means show FPS, 1 means show milliseconds
		
		// ALIGN THE FPS COUNTER TO THE TOP-LEFT CORNER
		    stats.domElement.style.position = 'absolute';
		    stats.domElement.style.left = '0px';
		    stats.domElement.style.top = '0px';
		
		    document.body.appendChild( stats.domElement );
	    
    function createGame() { // HERE YOU PUT ALL THINGS RELATED TO CREATING THE GAME STAGE OBJECTS
		
		// SCALE THE GAME STAGE TO THE WHOLE SCREEN SIZE
	    	this.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
	    
	    // CENTER THE GAME VIEW
		    this.scale.pageAlignHorizontally = true;
		    this.scale.pageAlignVertically = true;

	    // AUTOMATICALLY SET THE SCREEN SIZE
	    	this.scale.setScreenSize(true);
    	
			game.physics.startSystem(Phaser.Physics.ARCADE);    // SET THE GAME PHYSICS TO ARCADE GAME TYPE PHYSICS
			bg_wdith = game.cache.getImage('background').width; // GET THE BACKGROUND WIDTH FROM THE PHASERS' LOADED IMAGE CACHE
		
			for (var i=0; i<3; i++) { // CREATE OUR THREE BACKGROUND SPRITES AND THEN STORE THEM IN AN ARRAY FOR ANY FUTURE USE
				this['background' + i] = game.add.sprite(i * bg_wdith, 0, 'background');
				backgroundsArray.push(this['background' + i]);
			} 
	
		//////// CREATE COLLECTABLE ITEMS GROUP WITH ITEMS INSIDE////////
		
		itemGroup = game.add.group();
		itemGroup.enableBody = true;
		itemGroup.physicsBodyType = Phaser.Physics.ARCADE;
		
		for (var i = 0; i < 10; i++)
	    { 
			var s = game.add.sprite(game.rnd.integerInRange(300, 1500), game.rnd.integerInRange(0, 200),'collectable');
		        s.name = 'item' + i;
		        s.animations.add('play_collectable', [0, 1, 2, 3, 4], 5, true);
		        s.animations.play('play_collectable');

		    var randomFrame = Math.floor(Math.random() * s.animations.getAnimation('play_collectable').frameTotal);
		        
		        s.animations.currentAnim.setFrame(randomFrame, true);
		        itemGroup.add(s);
		       
		        s.allowGravity = true;
		        s.body.drag.x = 50;      
	    }
		
		//////////// CREATE MOVEABLE ITEM GROUP WITH MOVEABLE ITEMS INSIDE /////////////
		
			moveableItemGroup = game.add.group();
			moveableItemGroup.enableBody = true;
			moveableItemGroup.physicsBodyType = Phaser.Physics.ARCADE;
			
			for (var n = 0; n < 5; n++)
		    { 
					// phaser.js has it's own internal ranged random number function (example) --> game.rnd.integerInRange(200, 1500);
				var r = game.add.sprite(game.rnd.integerInRange(200, 1500), game.rnd.integerInRange(0, 200),'rock'); 
			        r.name = 'moveable' + n;
			      
			        moveableItemGroup.add(r);
			        
			        r.body.drag.x = 1000;
			        r.allowGravity = true;
			        r.immovable = true;    
		    }
		
		////////// CREATE PLATFORMS FOR WALKING ////////////
		
		// CREATE AN EMPTY TILE MAP
			map = game.add.tilemap();

	    // ADD AN IMAGE WHICH WILL BE THE IMAGE OF THE CURRENT TILE SET
	    	map.addTilesetImage(null,'ground_tile', 36, 36);

	    // CREATING AN EMPTY LAYER FOR OUR TILES - the map will be 50 tiles long and 10 tiles high and each tile is 36x36 pixels.
	    	layer1 = map.create('layer_1', 50, 10, 36, 36);
	
	    // RESIZE THE WORLD
	        layer1.resizeWorld(); // Sets the world size to match the size of this layer.
		   
	    // BUILD GROUND AND PLATFORMS USING map.putTile();
	        
		    for (var i=0; i<50; i++) { 
		    	map.putTile(0, i, 9, 'layer_1');  // GROUND
		    }    
		    
		    for (var i=10; i<19; i++) {
		    	map.putTile(0, i, 7, 'layer_1');  // PLATFORM 1
		    }    
		    
		    for (var i=20; i<26; i++) {
		    	map.putTile(0, i, 5, 'layer_1');  // PLATFORM 2
		    }  
		    
		    for (var i=28; i<31; i++) {
		    	map.putTile(0, i, 3, 'layer_1');  // PLATFORM 3
		    }  
		    
		    for (var i=32; i<39; i++) {
		    	map.putTile(0, i, 7, 'layer_1');  // PLATFORM 4
		    }  
		    
		    for (var i=43; i<50; i++) {
		    	map.putTile(0, i, 4, 'layer_1');  // PLATFORM 5
		    }  
		    
		    map.setCollision(0, true, 'layer_1');
		
	    ////////// CREATE THE PLAYER ///////////
	    
	    	player = game.add.sprite(100, 200, 'player');
	    	
	    	player.animations.add('left', [0, 1, 2, 3, 4], 10, true);
	        player.animations.add('right', [6, 7, 8, 9, 10], 10, true);
	    	
	    	player.anchor.setTo(0.5, 0.5);
    	
    	///////// CREATE THE CONTROLS GUI /////////
    	
	    	left = game.add.sprite(10, gameHeight - BUTTON_PADDING - 78, 'left');
	    	left.inputEnabled=true;
	    	left.fixedToCamera=true;
	    	left.events.onInputDown.add(onLeft,this)
	    	left.events.onInputUp.add(onLeftUp,this)
	    	
	    	right = game.add.sprite(10 + 78 + BUTTON_PADDING, gameHeight - BUTTON_PADDING - 78, 'right');
	    	right.inputEnabled=true;
	    	right.fixedToCamera=true;
	    	right.events.onInputDown.add(onRight,this)
	    	right.events.onInputUp.add(onRightUp,this)
	    	
	    	up = game.add.sprite(gameWidth - BUTTON_PADDING - 78, gameHeight - 10 - 78, 'up');
	    	up.inputEnabled=true;
	    	up.fixedToCamera=true;
	    	up.events.onInputDown.add(onUp,this)
	    	up.events.onInputUp.add(onUpUp,this)
    	
	    ///////// CREATE THE POINT COUNTER - COUNTS COLLECTED ITEMS ////////	
	    	
	    	hud = game.add.sprite(gameWidth - 100, 20, 'hud');
	    	hud.fixedToCamera=true;
	    	
	    	var txt = "        \n" + points.toString();
	    	
	    	pointsTxt = game.add.text(gameWidth - 80, 8, txt, {
		        font: "16px Arial",
		        fill: "#FFFFFF",
		        align: "center"
		    });
	    	
	    	pointsTxt.fixedToCamera = true;
		    
    	///////// SETUP THE PLAYER LOGIC CONTROLS ///////////
    	
	    	function onLeft(sprite, pointer) {
	    		goLeft = true;
	    		player.animations.play('left');
	    	}
	    	
	    	function onRight(sprite, pointer) {
	    		goRight = true;
	    		player.animations.play('right');
	    	}
	    	
	    	function onUp(sprite, pointer) {
	    		goUp = true;
	    	}
	    	
	    	function onLeftUp(sprite, pointer) {
	    		goLeft = false;
	    		player.animations.stop();
	    		player.frame = 5;
	    	}
	    	
	    	function onRightUp(sprite, pointer) {
	    		goRight = false;
	    		player.animations.stop();
	    		player.frame = 5;
	    	}
	    	
	    	function onUpUp(sprite, pointer) {
	    		goUp = false;
	    	}
	    	
		    	game.physics.arcade.enable([player, layer1]);
		    	game.physics.arcade.gravity.y = 500;
		    	
		    	player.body.allowGravity = true;
		    	player.body.immovable = false;
		        player.body.collideWorldBounds = true;
		       
		        game.camera.follow(player,1);
    }
    
    function updateGame() { // HERE IS THE MAIN GAME LOOP, PUT HERE ALL THE THINGS WHICH CHANGE THE COURSE OF THE GAME
    	
    	// CHECK COLLISIONS BETWEEN CERTAIN GROUP OF OBJECTS
    	
	    	game.physics.arcade.collide(player, layer1);
	    	game.physics.arcade.collide(player, moveableItemGroup);
	    	
	    	game.physics.arcade.collide(itemGroup, layer1);
	    	game.physics.arcade.collide(moveableItemGroup, layer1);
	    	
	    	game.physics.arcade.collide(moveableItemGroup, moveableItemGroup);
	    	game.physics.arcade.collide(itemGroup, itemGroup);
	    	
	    	game.physics.arcade.collide(moveableItemGroup, itemGroup);
	    	
	    	game.physics.arcade.collide(player, itemGroup, collisionHandler, null, this); // LISTEN FOR COLLISIONS BETWEEN THE PLAYER AND THE COLLECTABLE ITEMS
	    	
	    // PLAYER BEHAVIOUR
	    	
	    	player.body.velocity.x = 0;
	    	
	    	if (goLeft) {
	    		player.body.velocity.x = -200;
	    	} 
	    	else if (goRight) {
	    		player.body.velocity.x = 200;
	    	}
	    	
	    	if (goUp && (player.body.onFloor() || player.body.touching.down) == true && game.time.now > jumpTimer) {
	    		player.body.velocity.y = -400;
	    		
	    		jumpTimer = game.time.now + 650;
	    	}
    }
    
    function renderGame() { // HERE YOU PUT THINGS RELATED WITH RENDERING OF THE GAME
	    	stats.begin(); // WE START CHECKING PERFORMANCE HERE WITH Stats.js
	    	stats.end(); // WE END CHECKING PERFORMANCE HERE WITH Stats.js
    }
    
    function collisionHandler(player, item) { // HANDLE THE COLLISION OF THE PLAYER AND THE COLLECTABLE ITEM - destroy the item
    	points++;
    	
    	var txt = "        \n" + points.toString();
    	
    	console.log(txt);
    	
    	pointsTxt.setText(txt);
    	
    	item.kill();	
    }
    
    // ADD EVENTLISTENER FOR TIZENHWKEY
    document.addEventListener('tizenhwkey', function(e) {
        if(e.keyName == "back")
            tizen.application.getCurrentApplication().exit();
    });
};

// WINDOW.ONLOAD CAN WORK WITHOUT <body onload="">
window.onload = init;