function Point(e, t) {
    if (!e) e = 0;
    if (!t) t = 0;
    this.x = e;
    this.y = t
}

function Rectangle(e, t, n, r) {
    this.x = e;
    this.y = t;
    this.width = n;
    this.height = r
}

function EventDispatcher() {
    this.lsrs = {};
    this.cals = {}
}

function Event(e, t) {
    if (!t) t = false;
    this.type = e;
    this.target = null;
    this.currentTarget = null;
    this.bubbles = t
}

function MouseEvent(e, t) {
    Event.call(this, e, t)
}

function KeyboardEvent(e, t) {
    Event.call(this, e, t);
    this.altKey = false;
    this.ctrlKey = false;
    this.shiftKey = false;
    this.keyCode = 0;
    this.charCode = 0
}

function DisplayObject() {
    EventDispatcher.call(this);
    this.visible = true;
    this.parent = null;
    this.stage = null;
    this._tdirty = true;
    this._idirty = true;
    this.x = 0;
    this.y = 0;
    this._scaleX = 1;
    this._scaleY = 1;
    this._rotation = 0;
    this._brect = new Rectangle(0, 0, 0, 0);
    this._tmat = mat3.create();
    this._imat = mat3.create();
    this._atmat = mat3.create();
    this._aimat = mat3.create();
    this._temp = new Float32Array(2);
    this._temp2 = new Float32Array(2);
    this._tempm = mat3.create();
    this._atsEv = new Event(Event.ADDED_TO_STAGE);
    this._rfsEv = new Event(Event.REMOVED_FROM_STAGE);
    this._atsEv.target = this._rfsEv.target = this;
    this._tmat[2] = 1
}

function InteractiveObject() {
    DisplayObject.call(this);
    this.buttonMode = false;
    this.mouseEnabled = true
}

function DisplayObjectContainer() {
    InteractiveObject.call(this);
    this.numChildren = 0;
    this.mouseChildren = true;
    this._children = [];
    this._brect2 = new Rectangle(0, 0, 0, 0)
}

function BitmapData(e) {
    this.width = 0;
    this.height = 0;
    this.rect = null;
    this.loader = new EventDispatcher;
    this.loader.bytesLoaded = 0;
    this.loader.bytesTotal = 0;
    this._texture = gl.createTexture();
    this._rwidth = 0;
    this._rheight = 0;
    this._tcBuffer = gl.createBuffer();
    this._vBuffer = gl.createBuffer();
    this._loaded = false;
    this._opEv = new Event(Event.OPEN);
    this._pgEv = new Event(Event.PROGRESS);
    this._cpEv = new Event(Event.COMPLETE);
    this._opEv.target = this._pgEv.target = this._cpEv.target = this.loader;
    this._tcB = {};
    this._vxB = {};
    if (e == null) return;
    var t = document.createElement("img");
    var n = this;
    t.onload = function (e) {
        n._initFromImg(t, t.width, t.height);
        n.loader.dispatchEvent(n._cpEv)
    };
    t.src = e
}

function Bitmap(e) {
    DisplayObject.call(this);
    this.bitmapData = e
}

function MBitmap(e, t, n) {
    if (!t) t = 1;
    if (!n) n = 1;
    Bitmap.call(this, e);
    this.currentFrame = 0;
    this.totalFrames = t * n;
    this._rs = t;
    this._cs = n;
    this._tcB = null;
    this._vxB = null
}

function Stage(e) {
    DisplayObjectContainer.call(this);
    document.body.style.margin = "0";
    this.stage = this;
    this.stageWidth = 0;
    this.stageHeight = 0;
    this.focus = null;
    this._focii = [null, null, null];
    this._mousefocus = null;
    this._useHand = false;
    this._knM = false;
    this._mstack = new MStack;
    this._sprg = null;
    this._umat = mat3.create([2, 0, 1, 0, -2, 0, -1, 1, 1]);
    this._smat = mat3.create([1 / 100, 0, 1, 0, 1 / 100, 0, 0, 0, 1]);
    this._efEv = new Event(Event.ENTER_FRAME);
    this._rsEv = new Event(Event.RESIZE);
    this._mcEvs = [new MouseEvent(MouseEvent.CLICK, true), new MouseEvent(MouseEvent.MIDDLE_CLICK, true), new MouseEvent(MouseEvent.RIGHT_CLICK, true)];
    this._mdEvs = [new MouseEvent(MouseEvent.MOUSE_DOWN, true), new MouseEvent(MouseEvent.MIDDLE_MOUSE_DOWN, true), new MouseEvent(MouseEvent.RIGHT_MOUSE_DOWN, true)];
    this._muEvs = [new MouseEvent(MouseEvent.MOUSE_UP, true), new MouseEvent(MouseEvent.MIDDLE_MOUSE_UP, true), new MouseEvent(MouseEvent.RIGHT_MOUSE_UP, true)];
    this._mmoEv = new MouseEvent(MouseEvent.MOUSE_MOVE, true);
    this._movEv = new MouseEvent(MouseEvent.MOUSE_OVER, true);
    this._mouEv = new MouseEvent(MouseEvent.MOUSE_OUT, true);
    this._kdEv = new KeyboardEvent(KeyboardEvent.KEY_DOWN, true);
    this._kuEv = new KeyboardEvent(KeyboardEvent.KEY_UP, true);
    this._smd = [false, false, false];
    this._smu = [false, false, false];
    this._smm = false;
    this._srs = false;
    this._canvas = this.canvas = document.getElementById(e);
    Stage._main = this;
    var t = {
        antialias: true,
        stencil: false,
        depth: false
    };
    var n = this.canvas;
    gl = n.getContext("webgl", t);
    if (!gl) gl = n.getContext("experimental-webgl", t);
    if (!gl) alert("Could not initialize WebGL. Try to update your browser or graphic drivers.");
    n.addEventListener("contextmenu", Stage._ctxt, false);
    if (Stage._isTD()) {
        n.addEventListener("touchstart", Stage._onTD, false);
        n.addEventListener("touchmove", Stage._onTM, false);
        n.addEventListener("touchend", Stage._onTU, false);
        n.addEventListener("touchstart", Stage._blck, false);
        n.addEventListener("touchmove", Stage._blck, false);
        n.addEventListener("touchend", Stage._blck, false)
    } else {
        n.addEventListener("mousedown", Stage._onMD, false);
        n.addEventListener("mousemove", Stage._onMM, false);
        n.addEventListener("mouseup", Stage._onMU, false)
    }
    document.addEventListener("keydown", Stage._onKD, false);
    document.addEventListener("keyup", Stage._onKU, false);
    document.addEventListener("keydown", Stage._blck, false);
    document.addEventListener("keyup", Stage._blck, false);
    window.addEventListener("resize", Stage._onRS, false);
    this._initShaders();
    this._initBuffers();
    gl.clearColor(0, 0, 0, 0);
    gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
    gl.enable(gl.BLEND);
    this._resize();
    this._srs = true;
    _requestAF(Stage._tick)
}

function MStack() {
    this.mats = [];
    this.size = 0;
    for (var e = 0; e < 30; e++) this.mats.push(mat3.create())
}

function Graphics() {
    this._px = 0;
    this._py = 0;
    this._uls = [];
    this._cvs = [];
    this._tgs = [];
    this._elems = [];
    this._duls = [];
    this._dcvs = [];
    this._dtgs = {};
    this._minx = Number.POSITIVE_INFINITY;
    this._miny = this._minx;
    this._maxx = Number.NEGATIVE_INFINITY;
    this._maxy = this._maxx;
    this._sminx = Number.POSITIVE_INFINITY;
    this._sminy = this._sminx;
    this._smaxx = Number.NEGATIVE_INFINITY;
    this._smaxy = this._smaxx;
    this._brect = new Rectangle(0, 0, 0, 0);
    this._clstyle = new LineStyle(1, 0, 1);
    this._cfstyle = new FillStyle(16711680, 1);
    this._bdata = null;
    this._ftype = 0;
    this._empty = true;
    this._lvbuf = gl ? gl.createBuffer() : null;
    this._lvval = new Float32Array(12);
    this._lused = 0;
    this._ltotal = 1;
    this._ldirty = false;
    this._lsegment = null;
    if (gl) this._sendLBuffers()
}

function ULSegment(e, t, n) {
    this.vbuf = n;
    this.offset = 0;
    this.count = 0;
    this.color = new Float32Array(4);
    this.update(e, t)
}

function UTgs(e, t, n, r, i, s) {
    this.key = e.length + "-" + t.length;
    this.vrt = e;
    this.ind = t;
    this.uvt = n;
    this.useTex = r;
    this.color = new Float32Array([0, 0, 0, 0]);
    this._bdata = s;
    this._minx = 0;
    this._maxx = 0;
    this._miny = 0;
    this._maxy = 0;
    if (!r) this.SetColor(i);
    this.vbuf = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuf);
    gl.bufferData(gl.ARRAY_BUFFER, e, gl.STATIC_DRAW);
    this.ibuf = gl.createBuffer();
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.ibuf);
    gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, t, gl.STATIC_DRAW);
    this.tbuf = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, this.tbuf);
    gl.bufferData(gl.ARRAY_BUFFER, n, gl.STATIC_DRAW)
}

function FillStyle(e, t) {
    this.color = 0;
    this.alpha = 1;
    this.colARR = new Float32Array(4);
    this.Set(e, t)
}

function LineStyle(e, t, n) {
    FillStyle.call(this);
    this.color = t;
    this.alpha = n;
    this.thickness = e;
    this.Set(e, t, n)
}

function Sprite() {
    DisplayObjectContainer.call(this);
    this.graphics = new Graphics
}

function TextFormat(e, t, n, r, i, s, o) {
    this.font = e ? e : "Times new Roman";
    this.size = t ? t : 12;
    this.color = n ? n : 0;
    this.bold = r ? r : false;
    this.italic = i ? i : false;
    this.align = s ? s : TextFormatAlign.LEFT;
    this.leading = o ? o : 0;
    this.maxW = 0;
    this.data = {
        image: null,
        tw: 0,
        th: 0,
        rw: 0,
        rh: 0
    }
}

function TextField() {
    InteractiveObject.call(this);
    this._wordWrap = false;
    this._textW = 0;
    this._textH = 0;
    this._areaW = 100;
    this._areaH = 100;
    this._text = "";
    this._tForm = new TextFormat;
    this._rwidth = 0;
    this._rheight = 0;
    this._texture = gl.createTexture();
    this._tcArray = new Float32Array([0, 0, 0, 0, 0, 0, 0, 0]);
    this._tcBuffer = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, this._tcBuffer);
    gl.bufferData(gl.ARRAY_BUFFER, this._tcArray, gl.STATIC_DRAW);
    this._fArray = new Float32Array([0, 0, 0, 0, 0, 0, 0, 0]);
    this._vBuffer = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, this._vBuffer);
    gl.bufferData(gl.ARRAY_BUFFER, this._fArray, gl.STATIC_DRAW);
    this._brect.x = this._brect.y = 0
}

function Resizable(e, t) {
    Sprite.call(this);
    this.w = e;
    this.h = t;
    this.margin = 30
}

function MainMenu(e, t) {
    Resizable.call(this, e, t)
}

function LevelSelect(e, t) {
    Resizable.call(this, e, t);
    this.levelData = new Object
}

function GameControl(e, t) {
    Resizable.call(this, e, t);
    this.result = {}
}

function Main(e, t) {
    Resizable.call(this, e, t);
    this.mm;
    this.ls;
    this.gc;
    this.addEventListener("GoPlay", Main.GoPlay);
    this.addEventListener("GoBack", Main.GoBack);
    this.addEventListener("LevelChosen", Main.LevelChosen);
    this.addEventListener("GameDone", Main.GameDone);
    this.addEventListener("ExitGame", Main.ExitGame)
}
window._requestAF = function () {
    return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function (e, t) {
        window.setTimeout(e, 1e3 / 60)
    }
}();
"use strict";
mat3 = {};
mat3.create = function (e) {
    var t = new Float32Array(9);
    if (e) mat3.set(e, t);
    return t
};
mat3.set = function (e, t) {
    t[0] = e[0];
    t[1] = e[1];
    t[2] = e[2];
    t[3] = e[3];
    t[4] = e[4];
    t[5] = e[5];
    t[6] = e[6];
    t[7] = e[7];
    t[8] = e[8];
    return t
};
mat3.multiply = function (e, t, n) {
    var r = e[0],
        i = e[1],
        s = e[2],
        o = e[3],
        u = e[4],
        a = e[6],
        f = e[7],
        l = t[0],
        c = t[1],
        h = t[2],
        p = t[3],
        d = t[4],
        v = t[6],
        m = t[7];
    n[0] = l * r + c * o;
    n[1] = l * i + c * u;
    n[2] = s * h;
    n[3] = p * r + d * o;
    n[4] = p * i + d * u;
    n[6] = v * r + m * o + a;
    n[7] = v * i + m * u + f;
    return n
};
mat3.inverse = function (e, t) {
    var n = e[0],
        r = e[1],
        i = e[3],
        s = e[4],
        o = e[6],
        u = e[7],
        a = s,
        f = -i,
        l = u * i - s * o,
        c = n * a + r * f,
        h;
    h = 1 / c;
    t[0] = a * h;
    t[1] = -r * h;
    t[3] = f * h;
    t[4] = n * h;
    t[6] = l * h;
    t[7] = (-u * n + r * o) * h
};
mat3.multiplyVec2 = function (e, t, n) {
    if (n == null) n = t;
    var r = t[0],
        i = t[1];
    n[0] = r * e[0] + i * e[3] + e[6];
    n[1] = r * e[1] + i * e[4] + e[7]
};
Point.prototype.clone = function () {
    return new Point(this.x, this.y)
};
Point.prototype.setTo = function (e, t) {
    this.x = e;
    this.y = t
};
Point.prototype.copyFrom = function (e) {
    this.x = e.x;
    this.y = e.y
};
Point.distance = function (e, t) {
    return Point._distance(e.x, e.y, t.x, t.y)
};
Point._distance = function (e, t, n, r) {
    return Math.sqrt((n - e) * (n - e) + (r - t) * (r - t))
};
Rectangle.prototype.containsPoint = function (e) {
    return this.contains(e.x, e.y)
};
Rectangle.prototype.contains = function (e, t) {
    return e >= this.x && e <= this.x + this.width && t >= this.y && t <= this.y + this.height
};
Rectangle.prototype.clone = function () {
    return new Rectangle(this.x, this.y, this.width, this.height)
};
Rectangle.prototype.copyFrom = function (e) {
    this.x = e.x;
    this.y = e.y;
    this.width = e.width;
    this.height = e.height
};
Rectangle.prototype.union = function (e) {
    var t = this.clone();
    t._unionWith(e);
    return t
};
Rectangle.prototype.intersection = function (e) {
    var t = Math.max(this.x, e.x);
    var n = Math.max(this.y, e.y);
    var r = Math.min(this.x + this.width, e.x + e.width);
    var i = Math.min(this.y + this.height, e.y + e.height);
    return new Rectangle(t, n, r - t, i - n)
};
Rectangle.prototype.intersects = function (e) {
    if (e.y + e.height < this.y || e.x > this.x + this.width || e.y > this.y + this.height || e.x + e.width < this.x) return false;
    return true
};
Rectangle._temp = new Float32Array(2);
Rectangle.prototype._unionWith = function (e) {
    this._unionWP(e.x, e.y);
    this._unionWP(e.x + e.width, e.y + e.height)
};
Rectangle.prototype._unionWP = function (e, t) {
    var n = Math.min(this.x, e);
    var r = Math.min(this.y, t);
    this.width = Math.max(this.x + this.width, e) - n;
    this.height = Math.max(this.y + this.height, t) - r;
    this.x = n;
    this.y = r
};
Rectangle.prototype._setP = function (e, t) {
    this.x = e;
    this.y = t;
    this.width = this.height = 0
};
Rectangle.prototype._setAndTransform = function (e, t) {
    var n = Rectangle._temp;
    var r = mat3.multiplyVec2;
    n[0] = e.x;
    n[1] = e.y;
    r(t, n);
    this._setP(n[0], n[1]);
    n[0] = e.x + e.width;
    n[1] = e.y;
    r(t, n);
    this._unionWP(n[0], n[1]);
    n[0] = e.x;
    n[1] = e.y + e.height;
    r(t, n);
    this._unionWP(n[0], n[1]);
    n[0] = e.x + e.width;
    n[1] = e.y + e.height;
    r(t, n);
    this._unionWP(n[0], n[1])
};
EventDispatcher.efbc = [];
EventDispatcher.prototype.hasEventListener = function (e) {
    var t = this.lsrs[e];
    if (t == null) return false;
    return t.length > 0
};
EventDispatcher.prototype.addEventListener = function (e, t) {
    this.addEventListener2(e, t, null)
};
EventDispatcher.prototype.addEventListener2 = function (e, t, n) {
    if (this.lsrs[e] == null) {
        this.lsrs[e] = [];
        this.cals[e] = []
    }
    this.lsrs[e].push(t);
    this.cals[e].push(n);
    if (e == Event.ENTER_FRAME) {
        var r = EventDispatcher.efbc;
        if (r.indexOf(this) < 0) r.push(this)
    }
};
EventDispatcher.prototype.removeEventListener = function (e, t) {
    var n = this.lsrs[e];
    if (n == null) return;
    var r = n.indexOf(t);
    if (r < 0) return;
    var i = this.cals[e];
    n.splice(r, 1);
    i.splice(r, 1);
    if (e == Event.ENTER_FRAME && n.length == 0) {
        var s = EventDispatcher.efbc;
        s.splice(s.indexOf(this), 1)
    }
};
EventDispatcher.prototype.dispatchEvent = function (e) {
    var t = this.lsrs[e.type];
    if (t == null) return;
    var n = this.cals[e.type];
    for (var r = 0; r < t.length; r++) {
        e.currentTarget = this;
        if (e.target == null) e.target = this;
        if (n[r] == null) t[r](e);
        else t[r].call(n[r], e)
    }
};
Event.ENTER_FRAME = "enterFrame";
Event.RESIZE = "resize";
Event.ADDED_TO_STAGE = "addedToStage";
Event.REMOVED_FROM_STAGE = "removedFromStage";
Event.CHANGE = "change";
Event.OPEN = "open";
Event.PROGRESS = "progress";
Event.COMPLETE = "complete";
MouseEvent.prototype = new Event;
MouseEvent.CLICK = "click";
MouseEvent.MOUSE_MOVE = "mouseMove";
MouseEvent.MOUSE_DOWN = "mouseDown";
MouseEvent.MOUSE_UP = "mouseUp";
MouseEvent.MOUSE_OVER = "mouseOver";
MouseEvent.MOUSE_OUT = "mouseOut";
MouseEvent.MIDDLE_CLICK = "middleClick";
MouseEvent.MIDDLE_MOUSE_DOWN = "middleMouseDown";
MouseEvent.MIDDLE_MOUSE_UP = "middleMouseUp";
MouseEvent.RIGHT_CLICK = "rightClick";
MouseEvent.RIGHT_MOUSE_DOWN = "rightMouseDown";
MouseEvent.RIGHT_MOUSE_UP = "rightMouseUp";
KeyboardEvent.prototype = new Event;
KeyboardEvent.prototype._setFromDom = function (e) {
    this.altKey = e.altKey;
    this.ctrlKey = e.ctrlKey;
    this.shiftKey = e.ShiftKey;
    this.keyCode = e.keyCode;
    this.charCode = e.charCode
};
KeyboardEvent.KEY_DOWN = "keyDown";
KeyboardEvent.KEY_UP = "keyUp";
DisplayObject.prototype = new EventDispatcher;
DisplayObject.prototype.GetWidth = function () {
    var e = this._getRect(false);
    return e == null ? 0 : e.width * this._scaleX
};
DisplayObject.prototype.GetHeight = function () {
    var e = this._getRect(false);
    return e == null ? 0 : e.height * this._scaleY
};
DisplayObject.prototype.SetWidth = function (e) {
    var t = this.GetWidth();
    if (t != 0) this.scaleX *= e / t
};
DisplayObject.prototype.SetHeight = function (e) {
    var t = this.GetHeight();
    if (t != 0) this.scaleY *= e / t
};
DisplayObject.prototype.dispatchEvent = function (e) {
    EventDispatcher.prototype.dispatchEvent.call(this, e);
    if (e.bubbles && this.parent != null) this.parent.dispatchEvent(e)
};
DisplayObject.prototype.globalToLocal = function (e) {
    var t = this._temp;
    t[0] = e.x;
    t[1] = e.y;
    mat3.multiplyVec2(this._getAIMat(), t);
    return new Point(t[0], t[1])
};
DisplayObject.prototype.localToGlobal = function (e) {
    var t = this._temp;
    t[0] = e.x;
    t[1] = e.y;
    mat3.multiplyVec2(this._getATMat(), t);
    return new Point(t[0], t[1])
};
DisplayObject.prototype.hitTestPoint = function (e) {
    var t = this._temp2;
    t[0] = e.x;
    t[1] = e.y;
    mat3.multiplyVec2(this._getAIMat(), t);
    mat3.multiplyVec2(this._getTMat(), t);
    return this._htpLocal(t)
};
DisplayObject.prototype.hitTestObject = function (e) {
    var t = this._getRect(false);
    var n = e._getRect(false);
    if (!t || !n) return false;
    var r = this._getATMat();
    var i = e._getATMat();
    var s = t.clone(),
        o = n.clone();
    s._setAndTransform(t, r);
    o._setAndTransform(n, i);
    return s.intersects(o)
};
DisplayObject.prototype.getRect = function (e) {
    return this._makeRect(false, e)
};
DisplayObject.prototype.getBounds = function (e) {
    return this._makeRect(true, e)
};
DisplayObject.prototype._makeRect = function (e, t) {
    var n = this._getRect(e);
    var r = this._tempm;
    mat3.multiply(this._getATMat(), t._getAIMat(), r);
    var i = new Rectangle(6710886.4, 6710886.4, 0, 0);
    if (n) i._setAndTransform(n, r);
    return i
};
DisplayObject.prototype._htpLocal = function (e) {
    var t = this._temp;
    mat3.multiplyVec2(this._getIMat(), e, t);
    var n = this._getRect();
    if (n == null) return false;
    return n.contains(t[0], t[1])
};
DisplayObject.prototype._moveMouse = function (e, t, n) {
    return null
};
DisplayObject.prototype._getRect = function (e) {
    return this._brect
};
DisplayObject.prototype._setStage = function (e) {
    var t = this.stage;
    this.stage = e;
    if (t == null && e != null) this.dispatchEvent(this._atsEv);
    if (t != null && e == null) this.dispatchEvent(this._rfsEv)
};
DisplayObject.prototype._preRender = function (e) {
    var t = this._getTMat();
    e._mstack.push(t)
};
DisplayObject.prototype._render = function (e) {};
DisplayObject.prototype._renderAll = function (e) {
    if (!this.visible) return;
    this._preRender(e);
    this._render(e);
    e._mstack.pop()
};
DisplayObject.prototype._getTMat = function () {
    var e = this._tmat;
    if (this._tdirty) {
        var t = this._rotation * .0174532925;
        var n = this._scaleX;
        var r = this._scaleY;
        var i = Math.cos(t);
        var s = Math.sin(t);
        e[0] = i * n;
        e[1] = s * n;
        e[3] = -s * r;
        e[4] = i * r;
        this._tdirty = false
    }
    e[6] = this.x;
    e[7] = this.y;
    this._idirty = true;
    return e
};
DisplayObject.prototype._getIMat = function () {
    var e = this._getTMat();
    if (this._idirty) mat3.inverse(e, this._imat);
    this._idirty = false;
    return this._imat
};
DisplayObject.prototype._getATMat = function () {
    if (this.parent == null) return this._getTMat();
    mat3.multiply(this.parent._getTMat(), this._getTMat(), this._atmat);
    return this._atmat
};
DisplayObject.prototype._getAIMat = function () {
    if (this.parent == null) return this._getIMat();
    mat3.multiply(this._getIMat(), this.parent._getAIMat(), this._aimat);
    return this._aimat
};
DisplayObject.prototype._getMouse = function () {
    var e = this._temp;
    e[0] = Stage._mouseX;
    e[1] = Stage._mouseY;
    mat3.multiplyVec2(this._getAIMat(), e);
    return e
};
this.dp = DisplayObject.prototype;
dp.ds = dp.__defineSetter__;
dp.dg = dp.__defineGetter__;
dp.ds("scaleX", function (e) {
    this._scaleX = e;
    this._tdirty = true
});
dp.ds("scaleY", function (e) {
    this._scaleY = e;
    this._tdirty = true
});
dp.dg("scaleX", function (e) {
    return this._scaleX
});
dp.dg("scaleY", function (e) {
    return this._scaleY
});
dp.ds("rotation", function (e) {
    this._rotation = e;
    this._tdirty = true
});
dp.dg("rotation", function (e) {
    return this._rotation
});
dp.ds("alpha", function (e) {
    this._tmat[2] = e
});
dp.dg("alpha", function (e) {
    return this._tmat[2]
});
dp.dg("mouseX", function () {
    return this._getMouse()[0]
});
dp.dg("mouseY", function () {
    return this._getMouse()[1]
});
delete dp.ds;
delete dp.dg;
delete this.dp;
InteractiveObject.prototype = new DisplayObject;
InteractiveObject.prototype._moveMouse = function (e, t, n) {
    if (!n || !this.visible || !this.mouseEnabled) return null;
    var r = this._getRect();
    if (r == null) return null;
    var i = this._temp;
    i[0] = e;
    i[1] = t;
    mat3.multiplyVec2(this._getIMat(), i);
    if (r.contains(i[0], i[1])) return this;
    return null
};
DisplayObjectContainer.prototype = new InteractiveObject;
DisplayObjectContainer.prototype.addChild = function (e) {
    this._children.push(e);
    e.parent = this;
    e._setStage(this.stage);
    ++this.numChildren
};
DisplayObjectContainer.prototype.removeChild = function (e) {
    var t = this._children.indexOf(e);
    this._children.splice(t, 1);
    e.parent = null;
    e._setStage(null);
    --this.numChildren
};
DisplayObjectContainer.prototype.removeChildAt = function (e) {
    this.removeChild(this._children[e])
};
DisplayObjectContainer.prototype.contains = function (e) {
    return this._children.indexOf(e) >= 0
};
DisplayObjectContainer.prototype.getChildIndex = function (e) {
    return this._children.indexOf(e)
};
DisplayObjectContainer.prototype.setChildIndex = function (e, t) {
    var n = this._children.indexOf(e);
    if (t > n) {
        for (var r = n + 1; r <= t; r++) this._children[r - 1] = this._children[r];
        this._children[t] = e
    } else if (t < n) {
        for (var r = n - 1; r >= t; r--) this._children[r + 1] = this._children[r];
        this._children[t] = e
    }
};
DisplayObjectContainer.prototype.getChildAt = function (e) {
    return this._children[e]
};
DisplayObjectContainer.prototype._render = function (e) {
    for (var t = 0; t < this.numChildren; t++) this._children[t]._renderAll(e)
};
DisplayObjectContainer.prototype._moveMouse = function (e, t, n) {
    if (!n || !this.visible || !this.mouseChildren && !this.mouseEnabled) return null;
    var r = this._temp;
    r[0] = e;
    r[1] = t;
    mat3.multiplyVec2(this._getIMat(), r);
    var i = r[0],
        s = r[1];
    var o = n;
    var u = null;
    var a = this.numChildren - 1;
    for (var f = a; f > -1; f--) {
        var l = this._children[f]._moveMouse(i, s, o);
        if (l != null) {
            u = l;
            break
        }
    }
    if (!this.mouseChildren && u != null) return this;
    return u
};
DisplayObjectContainer.prototype._htpLocal = function (e) {
    var t = this._temp;
    mat3.multiplyVec2(this._getIMat(), e, t);
    var n = this._children.length;
    for (var r = 0; r < n; r++) {
        var i = this._children[r];
        if (i.visible)
            if (i._htpLocal(t)) return true
    }
    return false
};
DisplayObjectContainer.prototype._setStage = function (e) {
    InteractiveObject.prototype._setStage.call(this, e);
    for (var t = 0; t < this.numChildren; t++) this._children[t]._setStage(e)
};
DisplayObjectContainer.prototype._getRect = function (e) {
    if (this.numChildren == 0) return null;
    var t = null;
    var n = this._brect2;
    for (var r = 0; r < this.numChildren; r++) {
        var i = this._children[r];
        var s = i._getRect(e);
        if (!i.visible || s == null) continue;
        if (t == null) {
            t = this._brect;
            t._setAndTransform(s, i._getTMat())
        } else {
            n._setAndTransform(s, i._getTMat());
            t._unionWith(n)
        }
    }
    return t
};
BitmapData.empty = function (e, t) {
    var n = new BitmapData(null);
    n._initFromImg(null, e, t);
    return n
};
BitmapData.prototype.setPixels = function (e, t) {
    gl.bindTexture(gl.TEXTURE_2D, this._texture);
    gl.texSubImage2D(gl.TEXTURE_2D, 0, e.x, e.y, e.width, e.height, gl.RGBA, gl.UNSIGNED_BYTE, t);
    gl.generateMipmap(gl.TEXTURE_2D)
};
BitmapData.prototype.getPixels = function (e, t) {
    if (!t) t = new Uint8Array(e.width * e.height * 4);
    this._setTexAsFB();
    gl.readPixels(e.x, e.y, e.width, e.height, gl.RGBA, gl.UNSIGNED_BYTE, t);
    Stage._main._setFramebuffer(null, Stage._main.stageWidth, Stage._main.stageHeight, false);
    return t
};
BitmapData.prototype.draw = function (e) {
    this._setTexAsFB();
    e._render(Stage._main);
    Stage._main._setFramebuffer(null, Stage._main.stageWidth, Stage._main.stageHeight, false)
};
BitmapData.prototype._setTexAsFB = function () {
    if (BitmapData._fbo == null) BitmapData._fbo = gl.createFramebuffer();
    Stage._main._setFramebuffer(BitmapData._fbo, this.width, this.height, true);
    gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, this._texture, 0)
};
BitmapData.prototype._initFromImg = function (e, t, n) {
    this._loaded = true;
    this.width = t;
    this.height = n;
    this._rwidth = BitmapData._nhpot(t);
    this._rheight = BitmapData._nhpot(n);
    this.rect = new Rectangle(0, 0, t, n);
    var r = t / this._rwidth;
    var i = n / this._rheight;
    gl.bindBuffer(gl.ARRAY_BUFFER, this._tcBuffer);
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([0, 0, r, 0, 0, i, r, i]), gl.STATIC_DRAW);
    gl.bindBuffer(gl.ARRAY_BUFFER, this._vBuffer);
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([0, 0, t, 0, 0, n, t, n]), gl.STATIC_DRAW);
    var s = BitmapData._canv;
    s.width = this._rwidth;
    s.height = this._rheight;
    var o = BitmapData._ctx;
    if (e != null) o.drawImage(e, 0, 0);
    var u = o.getImageData(0, 0, this._rwidth, this._rheight);
    gl.bindTexture(gl.TEXTURE_2D, this._texture);
    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, u);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_NEAREST);
    gl.generateMipmap(gl.TEXTURE_2D)
};
BitmapData.prototype._getTcBuffers = function (e, t) {
    var n = this._tcB[e + "-" + t];
    if (n != null) return n;
    var r = this.width / this._rwidth;
    var i = this.height / this._rheight;
    var s = r / t;
    var o = i / e;
    n = [];
    for (var u = 0; u < e; u++)
        for (var a = 0; a < t; a++) {
            var f = gl.createBuffer();
            var l = [a * s, u * o, (a + 1) * s, u * o, a * s, (u + 1) * o, (a + 1) * s, (u + 1) * o];
            gl.bindBuffer(gl.ARRAY_BUFFER, f);
            gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(l), gl.STATIC_DRAW);
            n.push(f)
        }
    this._tcB[e + "-" + t] = n;
    return n
};
BitmapData.prototype._getVxBuffer = function (e, t) {
    var n = this._vxB[e + "-" + t];
    if (n != null) return n;
    var r = this.width / t;
    var i = this.height / e;
    var n = gl.createBuffer();
    gl.bindBuffer(gl.ARRAY_BUFFER, n);
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([0, 0, r, 0, 0, i, r, i]), gl.STATIC_DRAW);
    this._vxB[e + "-" + t] = n;
    return n
};
BitmapData._canv = document.createElement("canvas");
BitmapData._ctx = BitmapData._canv.getContext("2d");
BitmapData._ipot = function (e) {
    return (e & e - 1) == 0
};
BitmapData._nhpot = function (e) {
    --e;
    for (var t = 1; t < 32; t <<= 1) {
        e = e | e >> t
    }
    return e + 1
};
Bitmap.prototype = new InteractiveObject;
Bitmap.prototype._getRect = function () {
    return this.bitmapData.rect
};
Bitmap.prototype._render = function (e) {
    var t = this.bitmapData;
    if (!t._loaded) return;
    gl.uniformMatrix3fv(e._sprg.tMatUniform, false, e._mstack.top());
    if (Stage._curBD != t) {
        Stage._curBD = t;
        gl.bindBuffer(gl.ARRAY_BUFFER, t._vBuffer);
        gl.vertexAttribPointer(e._sprg.vpa, 2, gl.FLOAT, false, 0, 0);
        gl.bindBuffer(gl.ARRAY_BUFFER, t._tcBuffer);
        gl.vertexAttribPointer(e._sprg.tca, 2, gl.FLOAT, false, 0, 0);
        gl.bindTexture(gl.TEXTURE_2D, t._texture);
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, e._unitIBuffer)
    }
    gl.drawElements(gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0)
};
MBitmap.prototype = new Bitmap;
MBitmap.prototype._getRect = function () {
    return this._brect
};
MBitmap.prototype.gotoAndStop = function (e) {
    this.currentFrame = e % this.totalFrames
};
MBitmap.prototype.nextFrame = function () {
    this.currentFrame = (this.currentFrame + 1) % this.totalFrames
};
MBitmap.prototype.prevFrame = function () {
    this.currentFrame = (this.totalFrames + this.currentFrame - 1) % this.totalFrames
};
MBitmap.prototype._render = function (e) {
    Stage._curBD = null;
    if (this._tcB == null) {
        var t = this.bitmapData;
        if (!t._loaded) return;
        this._tcB = t._getTcBuffers(this._rs, this._cs);
        this._vxB = t._getVxBuffer(this._rs, this._cs);
        this._brect.width = t.width / this._cs;
        this._brect.height = t.height / this._rs
    }
    gl.uniformMatrix3fv(e._sprg.tMatUniform, false, e._mstack.top());
    gl.bindBuffer(gl.ARRAY_BUFFER, this._vxB);
    gl.vertexAttribPointer(e._sprg.vpa, 2, gl.FLOAT, false, 0, 0);
    gl.bindBuffer(gl.ARRAY_BUFFER, this._tcB[this.currentFrame]);
    gl.vertexAttribPointer(e._sprg.tca, 2, gl.FLOAT, false, 0, 0);
    gl.bindTexture(gl.TEXTURE_2D, this.bitmapData._texture);
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, e._unitIBuffer);
    gl.drawElements(gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0)
};
var gl;
Stage.prototype = new DisplayObjectContainer;
Stage._mouseX = 0;
Stage._mouseY = 0;
Stage._curBD = null;
Stage._okKeys = [112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 13, 16, 18, 27];
Stage._isTD = function () {
    return !!("ontouchstart" in window)
};
Stage._ctxt = function (e) {
    if (Stage._main.hasEventListener(MouseEvent.RIGHT_CLICK)) e.preventDefault()
};
Stage._onTD = function (e) {
    Stage._setStageMouse(e);
    Stage._main._smd[0] = true;
    Stage._main._knM = true
};
Stage._onTM = function (e) {
    Stage._setStageMouse(e);
    Stage._main._smm = true;
    Stage._main._knM = true
};
Stage._onTU = function (e) {
    Stage._main._smu[0] = true;
    Stage._main._knM = true
};
Stage._onMD = function (e) {
    Stage._setStageMouse(e);
    Stage._main._smd[e.button] = true;
    Stage._main._knM = true
};
Stage._onMM = function (e) {
    Stage._setStageMouse(e);
    Stage._main._smm = true;
    Stage._main._knM = true
};
Stage._onMU = function (e) {
    Stage._main._smu[e.button] = true;
    Stage._main._knM = true
};
Stage._onKD = function (e) {
    var t = Stage._main;
    t._kdEv._setFromDom(e);
    if (t.focus && t.focus.stage) t.focus.dispatchEvent(t._kdEv);
    else t.dispatchEvent(t._kdEv)
};
Stage._onKU = function (e) {
    var t = Stage._main;
    t._kuEv._setFromDom(e);
    if (t.focus && t.focus.stage) t.focus.dispatchEvent(t._kuEv);
    else t.dispatchEvent(t._kuEv)
};
Stage._blck = function (e) {
    if (e.keyCode != null) {
        if (Stage._okKeys.indexOf(e.keyCode) == -1) e.preventDefault()
    } else e.preventDefault()
};
Stage._onRS = function (e) {
    Stage._main._srs = true
};
Stage.prototype._resize = function () {
    var e = window.innerWidth;
    var t = window.innerHeight;
    this.stageWidth = e;
    this.stageHeight = t;
    this._canvas.width = e;
    this._canvas.height = t;
    this._setFramebuffer(null, e, t, false)
};
Stage.prototype._getShader = function (e, t, n) {
    var r;
    if (n) r = e.createShader(e.FRAGMENT_SHADER);
    else r = e.createShader(e.VERTEX_SHADER);
    e.shaderSource(r, t);
    e.compileShader(r);
    if (!e.getShaderParameter(r, e.COMPILE_STATUS)) {
        alert(e.getShaderInfoLog(r));
        return null
    }
    return r
};
Stage.prototype._initShaders = function () {
    var e = "			precision mediump float;			varying vec2 texCoord;			varying float alpha;						uniform sampler2D uSampler;			uniform vec4 color;			uniform bool useTex;						void main(void) {				if(useTex)				{					gl_FragColor = texture2D(uSampler, texCoord);				}				else gl_FragColor = color;				gl_FragColor.w *= alpha;			}";
    var t = "			attribute vec2 verPos;			attribute vec2 texPos;						uniform mat3 tMat;						varying vec2 texCoord;			varying float alpha;						void main(void) {				vec3 v = tMat * vec3(verPos, 1.0);				gl_Position = vec4(v.x, v.y, 0, 1);				texCoord = texPos;				alpha = tMat[0][2];			}";
    var n = this._getShader(gl, e, true);
    var r = this._getShader(gl, t, false);
    this._sprg = gl.createProgram();
    gl.attachShader(this._sprg, r);
    gl.attachShader(this._sprg, n);
    gl.linkProgram(this._sprg);
    if (!gl.getProgramParameter(this._sprg, gl.LINK_STATUS)) {
        alert("Could not initialise shaders")
    }
    gl.useProgram(this._sprg);
    this._sprg.vpa = gl.getAttribLocation(this._sprg, "verPos");
    this._sprg.tca = gl.getAttribLocation(this._sprg, "texPos");
    gl.enableVertexAttribArray(this._sprg.tca);
    gl.enableVertexAttribArray(this._sprg.vpa);
    this._sprg.tMatUniform = gl.getUniformLocation(this._sprg, "tMat");
    this._sprg.samplerUniform = gl.getUniformLocation(this._sprg, "uSampler");
    this._sprg.useTex = gl.getUniformLocation(this._sprg, "useTex");
    this._sprg.color = gl.getUniformLocation(this._sprg, "color");
    gl.uniform1i(this._sprg.useTex, 1)
};
Stage.prototype._initBuffers = function () {
    var e = [0, 1, 2, 1, 2, 3];
    this._unitIBuffer = gl.createBuffer();
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._unitIBuffer);
    gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(e), gl.STATIC_DRAW);
    e = [];
    for (var t = 0; t < 100; t++) e.push(t);
    this._unitI33 = gl.createBuffer();
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._unitI33);
    gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(e), gl.STATIC_DRAW);
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this._unitIBuffer)
};
Stage.prototype._setFramebuffer = function (e, t, n, r) {
    this._mstack.clear();
    if (r) {
        this._umat[4] = 2;
        this._umat[7] = -1
    } else {
        this._umat[4] = -2;
        this._umat[7] = 1
    }
    this._mstack.set(this._umat, 0);
    this._smat[0] = 1 / t;
    this._smat[4] = 1 / n;
    this._mstack.push(this._smat);
    gl.bindFramebuffer(gl.FRAMEBUFFER, e);
    gl.viewport(0, 0, t, n)
};
Stage._setStageMouse = function (e) {
    var t = e;
    if (e.type == "touchstart" || e.type == "touchmove" || e.type == "touchend") t = e.touches.item(0);
    var n = t.clientX;
    var r = t.clientY;
    Stage._mouseX = n;
    Stage._mouseY = r
};
Stage.prototype._drawScene = function () {
    if (this._srs) {
        this._resize();
        this.dispatchEvent(this._rsEv);
        this._srs = false
    }
    gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
    if (this._knM) {
        var e = this._moveMouse(Stage._mouseX, Stage._mouseY, true);
        var t = this._mousefocus || this,
            n = e || this;
        if (e != this._mousefocus) {
            if (t != this) {
                var r = this._mouEv;
                r.target = t;
                t.dispatchEvent(r)
            }
            if (n != this) {
                r = this._movEv;
                r.target = n;
                n.dispatchEvent(r)
            }
        }
        var i = this._smd,
            s = this._smu;
        for (var o = 0; o < 3; o++) {
            this._mcEvs[o].target = this._mdEvs[o].target = this._muEvs[o].target = n;
            if (i[o]) {
                n.dispatchEvent(this._mdEvs[o]);
                this._focii[o] = this.focus = e
            }
            if (s[o]) {
                n.dispatchEvent(this._muEvs[o]);
                if (e == this._focii[o]) n.dispatchEvent(this._mcEvs[o])
            }
            i[o] = s[o] = false
        }
        this._mmoEv.target = n;
        if (this._smm) {
            n.dispatchEvent(this._mmoEv)
        }
        this._smm = false;
        this._mousefocus = e;
        var u = false,
            a = n;
        while (a.parent != null) {
            u |= a.buttonMode;
            a = a.parent
        }
        if (u != this._useHand) this._canvas.style.cursor = u ? "pointer" : "default";
        this._useHand = u
    }
    var f = EventDispatcher.efbc;
    var r = this._efEv;
    for (var o = 0; o < f.length; o++) {
        r.target = f[o];
        f[o].dispatchEvent(r)
    }
    this._renderAll(this)
};
Stage._tick = function () {
    _requestAF(Stage._tick);
    Stage.prototype._drawScene.call(Stage._main)
};
MStack.prototype.clear = function () {
    this.size = 0
};
MStack.prototype.set = function (e, t) {
    mat3.set(e, this.mats[t]);
    this.size = t + 1
};
MStack.prototype.push = function (e) {
    var t = this.size++;
    mat3.multiply(this.mats[t - 1], e, this.mats[t])
};
MStack.prototype.pop = function () {
    this.size--
};
MStack.prototype.top = function () {
    return this.mats[this.size - 1]
};
Graphics.prototype._render = function (e) {
    gl.uniformMatrix3fv(e._sprg.tMatUniform, false, e._mstack.top());
    if (this._ldirty) {
        gl.bindBuffer(gl.ARRAY_BUFFER, this._lvbuf);
        gl.bufferSubData(gl.ARRAY_BUFFER, 0, this._lvval);
        this._ldirty = false
    }
    Stage._curBD = null;
    var t = this._elems;
    for (var n = 0; n < t.length; n++) t[n].render(e);
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, e._unitIBuffer);
    gl.uniform1i(e._sprg.useTex, 1)
};
Graphics.prototype._sendLBuffers = function () {
    gl.bindBuffer(gl.ARRAY_BUFFER, this._lvbuf);
    gl.bufferData(gl.ARRAY_BUFFER, this._lvval, gl.STATIC_DRAW)
};
Graphics.prototype._newLineSegment = function () {
    var e;
    if (this._duls.length == 0) e = new ULSegment(this._lused, this._clstyle.colARR, this._lvbuf);
    else {
        e = this._duls.pop();
        e.update(this._lused, this._clstyle.colARR)
    }
    this._uls.push(e);
    this._elems.push(e);
    return e
};
Graphics.prototype._checkLineAvail = function (e) {
    var t = this._ltotal;
    if (t - this._lused < e) {
        t = Math.max(t + e, 2 * t);
        var n = this._lvval;
        var r = new Float32Array(12 * t);
        for (var i = 0; i < n.length; i++) r[i] = n[i];
        this._ltotal = t;
        this._lvval = r;
        this._sendLBuffers()
    }
};
Graphics.prototype._putLine = function (e, t, n, r) {
    this._updateSBounds(e, t);
    this._updateSBounds(n, r);
    if (this._lsegment == null) this._lsegment = this._newLineSegment();
    this._checkLineAvail(1);
    var i = .5 * this._clstyle.thickness / this.len(e - n, t - r);
    var s = i * (t - r);
    var o = -i * (e - n);
    var u = this._lvval;
    var a = this._lused * 12;
    u[a + 0] = e + s;
    u[a + 1] = t + o;
    u[a + 2] = e - s;
    u[a + 3] = t - o;
    u[a + 4] = n + s;
    u[a + 5] = r + o;
    u[a + 6] = e - s;
    u[a + 7] = t - o;
    u[a + 8] = n + s;
    u[a + 9] = r + o;
    u[a + 10] = n - s;
    u[a + 11] = r - o;
    this._ldirty = true;
    this._lused++;
    this._lsegment.count++;
    this._empty = false
};
Graphics.prototype.lineStyle = function (e, t, n) {
    if (!t) t = 0;
    if (!n) n = 1;
    if (t != this._clstyle.color || n != this._clstyle.alpha) this._lsegment = null;
    this._clstyle.Set(e, t, n)
};
Graphics.prototype.beginFill = function (e, t) {
    this._ftype = 0;
    if (!t) t = 1;
    this._cfstyle.Set(e, t)
};
Graphics.prototype.beginBitmapFill = function (e) {
    this._ftype = 1;
    this._bdata = e
};
Graphics.prototype.endFill = function () {};
Graphics.prototype.moveTo = function (e, t) {
    this._px = e;
    this._py = t
};
Graphics.prototype.lineTo = function (e, t) {
    this._putLine(this._px, this._py, e, t);
    this._px = e;
    this._py = t
};
Graphics.prototype.len = function (e, t) {
    return Math.sqrt(e * e + t * t)
};
Graphics.prototype.curveTo = function (e, t, n, r) {
    var i = this._px,
        s = this._py,
        o = .666666;
    this.cubicCurveTo(i + o * (e - i), s + o * (t - s), n + o * (e - n), r + o * (t - r), n, r)
};
Graphics.prototype.cubicCurveTo = function (e, t, n, r, i, s) {
    this._checkLineAvail(40);
    if (this._lsegment == null) this._lsegment = this._newLineSegment();
    var o, u, a, f, l, c, h, p, d, v, m, g, y, b, w, E, S, x, T, N, C, k, L, A;
    var O = .5 * this._clstyle.thickness;
    var M, _, D, P, H;
    o = this._px;
    u = this._py;
    y = e - o;
    b = t - u;
    w = n - e;
    E = r - t;
    S = i - n;
    x = s - r;
    step = 1 / 40;
    var B, j, F, I;
    var q = this._lvval;
    var R = this._lused * 12;
    for (var U = 0; U < 41; U++) {
        var z = U * step;
        a = o + z * y;
        f = u + z * b;
        l = e + z * w;
        c = t + z * E;
        h = n + z * S;
        p = r + z * x;
        T = l - a;
        N = c - f;
        C = h - l;
        k = p - c;
        d = a + z * T;
        v = f + z * N;
        m = l + z * C;
        g = c + z * k;
        L = m - d;
        A = g - v;
        P = d + z * L;
        H = v + z * A;
        M = O / this.len(L, A);
        _ = M * A;
        D = -M * L;
        this._updateSBounds(P, H);
        if (U > 0) {
            q[R++] = B + F;
            q[R++] = j + I;
            q[R++] = B - F;
            q[R++] = j - I;
            q[R++] = P + _;
            q[R++] = H + D;
            q[R++] = B - F;
            q[R++] = j - I;
            q[R++] = P + _;
            q[R++] = H + D;
            q[R++] = P - _;
            q[R++] = H - D
        }
        B = P;
        j = H;
        F = _;
        I = D
    }
    this._px = i;
    this._py = s;
    this._ldirty = true;
    this._lused += 40;
    this._lsegment.count += 40;
    this._empty = false
};
Graphics.prototype.drawCircle = function (e, t, n) {
    this.drawEllipse(e, t, n * 2, n * 2)
};
Graphics.prototype.drawEllipse = function (e, t, n, r) {
    var i = Math.PI / 16;
    var s = n * .5;
    var o = r * .5;
    var u = Graphics._eVrt;
    var a = 0;
    for (var f = 0; f < 2 * Math.PI; f += i) {
        u[a++] = e + Math.cos(f) * s;
        u[a++] = t + Math.sin(f) * o
    }
    this.drawTriangles(u, Graphics._eInd)
};
Graphics.prototype.drawRect = function (e, t, n, r) {
    var i = Graphics._rVrt;
    i[0] = i[4] = e;
    i[1] = i[3] = t;
    i[2] = i[6] = e + n;
    i[5] = i[7] = t + r;
    this.drawTriangles(i, Graphics._rInd)
};
Graphics.prototype.drawRoundRect = function (e, t, n, r, i, s) {
    var o = Graphics._rrVrt;
    var u = Math.PI / 14;
    if (!s) s = i;
    var a = i * .5;
    var f = s * .5;
    var l = 0;
    var c = e + a;
    var h = t + f;
    for (var p = -Math.PI; p <= Math.PI; p += u) {
        if (l == 16) c += n - i;
        if (l == 32) h += r - s;
        if (l == 48) c -= n - i;
        if (l > 0 && (l & 15) == 0) p -= u;
        o[l++] = c + Math.cos(p) * a;
        o[l++] = h + Math.sin(p) * f
    }
    this.drawTriangles(o, Graphics._rrInd)
};
Graphics.prototype.drawTriangles = function (e, t, n) {
    this._lsegment = null;
    var r = e.length + "-" + t.length;
    var i = 1 / 256,
        s = 1 / 256;
    if (this._ftype == 1)
        if (this._bdata._loaded) {
            i = 1 / this._bdata._rwidth;
            s = 1 / this._bdata._rheight
        }
    var o;
    var u = this._dtgs[r];
    if (u != null && u.length > 0) {
        o = u.pop();
        for (var a = 0; a < e.length; a++) o.vrt[a] = e[a];
        for (var a = 0; a < t.length; a++) o.ind[a] = t[a];
        if (n != null)
            for (var a = 0; a < n.length; a++) o.uvt[a] = n[a];
        else
            for (var a = 0; a < e.length; a += 2) {
                o.uvt[a] = i * e[a];
                o.uvt[a + 1] = s * e[a + 1]
            }
        if (this._ftype == 1) {
            o.useTex = true;
            o._bdata = this._bdata
        } else {
            o.useTex = false;
            o.SetColor(this._cfstyle.colARR)
        }
        o.updateData()
    } else {
        var f = new Float32Array(e);
        var l = new Uint16Array(t);
        var c;
        if (n != null) c = new Float32Array(n);
        else {
            c = new Float32Array(e);
            for (var a = 0; a < c.length; a += 2) {
                c[a] *= i;
                c[a + 1] *= s
            }
        } if (this._ftype == 1) o = new UTgs(f, l, c, true, null, this._bdata);
        else o = new UTgs(f, l, c, false, this._cfstyle.colARR, null)
    }
    var h, p, d, v;
    h = p = Number.POSITIVE_INFINITY;
    d = v = Number.NEGATIVE_INFINITY;
    for (var a = 0; a < e.length; a += 2) {
        var m = e[a];
        var g = e[a + 1];
        m < h ? h = m : m > d ? d = m : 0;
        g < p ? p = g : g > v ? v = g : 0
    }
    o._minx = h;
    o._miny = p;
    o._maxx = d;
    o._maxy = v;
    this._updateBounds(h, p);
    this._updateBounds(d, v);
    this._tgs.push(o);
    this._elems.push(o);
    this._empty = false
};
Graphics.prototype.clear = function () {
    this._duls = this._uls;
    this._dcvs = this._cvs;
    for (var e = 0; e < this._tgs.length; e++) {
        var t = this._tgs[e];
        if (this._dtgs[t.key] == null) this._dtgs[t.key] = [];
        this._dtgs[t.key].push(t)
    }
    this._uls = [];
    this._cvs = [];
    this._tgs = [];
    this._elems = [];
    this._ftype = 0;
    this._empty = true;
    this._minx = this._sminx = this._miny = this._sminy = Number.POSITIVE_INFINITY;
    this._maxx = this._smaxx = this._maxy = this._smaxy = Number.NEGATIVE_INFINITY;
    this._lused = 0;
    this._lsegment = null
};
Graphics.prototype._getRect = function (e) {
    if (this._empty) return null;
    var t = this._tgs.length != 0;
    var n = this._uls.length != 0 || this._cvs.length != 0;
    if (!e && !t) return null;
    var r = this._brect;
    var i = this._sminx,
        s = this._sminy,
        o = this._smaxx,
        u = this._smaxy;
    if (t) {
        r._setP(this._minx, this._miny);
        r._unionWP(this._maxx, this._maxy);
        if (n && e) {
            r._unionWP(i, s);
            r._unionWP(o, u)
        }
        return r
    }
    r._setP(i, s);
    r._unionWP(o, u);
    return r
};
Graphics.prototype._hits = function (e, t) {
    if (this._empty) return false;
    if (e < this._minx || e > this._maxx || t < this._miny || t > this._maxy) return false;
    var n = this._tgs.length;
    if (n == 1) return true;
    for (var r = 0; r < n; r++)
        if (this._tgs[r]._hits(e, t)) return true;
    return false
};
Graphics.prototype._updateBounds = function (e, t) {
    e < this._minx ? this._minx = e : e > this._maxx ? this._maxx = e : 0;
    t < this._miny ? this._miny = t : t > this._maxy ? this._maxy = t : 0
};
Graphics.prototype._updateSBounds = function (e, t) {
    e < this._sminx ? this._sminx = e : e > this._smaxx ? this._smaxx = e : 0;
    t < this._sminy ? this._sminy = t : t > this._smaxy ? this._smaxy = t : 0
};
Graphics._makeConvexInd = function (e) {
    var t = [];
    for (var n = 1; n < e - 1; n++) t.push(0, n, n + 1);
    return t
};
Graphics._rVrt = [0, 0, 0, 0, 0, 0, 0, 0];
Graphics._rInd = [0, 1, 2, 1, 2, 3];
Graphics._eVrt = [];
for (var i = 0; i < 32; i++) Graphics._eVrt.push(0, 0);
Graphics._eInd = Graphics._makeConvexInd(32);
Graphics._rrVrt = [];
for (var i = 0; i < 32; i++) Graphics._rrVrt.push(0, 0);
Graphics._rrInd = Graphics._makeConvexInd(32);
ULSegment.prototype.update = function (e, t) {
    this.count = 0;
    this.offset = e;
    var n = this.color;
    n[0] = t[0];
    n[1] = t[1];
    n[2] = t[2];
    n[3] = t[3]
};
ULSegment.prototype.render = function (e) {
    gl.uniform1i(e._sprg.useTex, 0);
    gl.uniform4fv(e._sprg.color, this.color);
    gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuf);
    gl.vertexAttribPointer(e._sprg.vpa, 2, gl.FLOAT, false, 0, 0);
    gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuf);
    gl.vertexAttribPointer(e._sprg.tca, 2, gl.FLOAT, false, 0, 0);
    gl.drawArrays(gl.TRIANGLES, 6 * this.offset, 6 * this.count)
};
UTgs.prototype.SetColor = function (e) {
    var t = this.color;
    t[0] = e[0];
    t[1] = e[1];
    t[2] = e[2];
    t[3] = e[3]
};
UTgs.prototype._hits = function (e, t) {
    return e > this._minx && e < this._maxx && t > this._miny && t < this._maxy
};
UTgs.prototype.updateData = function () {
    gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuf);
    gl.bufferSubData(gl.ARRAY_BUFFER, 0, this.vrt);
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.ibuf);
    gl.bufferSubData(gl.ELEMENT_ARRAY_BUFFER, 0, this.ind);
    gl.bindBuffer(gl.ARRAY_BUFFER, this.tbuf);
    gl.bufferSubData(gl.ARRAY_BUFFER, 0, this.uvt)
};
UTgs.prototype.render = function (e) {
    if (this.useTex) {
        if (this._bdata._loaded == false) return;
        gl.uniform1i(e._sprg.useTex, 1);
        gl.bindTexture(gl.TEXTURE_2D, this._bdata._texture);
        gl.uniform1i(e._sprg.samplerUniform, 0)
    } else {
        gl.uniform1i(e._sprg.useTex, 0);
        gl.uniform4fv(e._sprg.color, this.color)
    }
    gl.bindBuffer(gl.ARRAY_BUFFER, this.tbuf);
    gl.vertexAttribPointer(e._sprg.tca, 2, gl.FLOAT, false, 0, 0);
    gl.bindBuffer(gl.ARRAY_BUFFER, this.vbuf);
    gl.vertexAttribPointer(e._sprg.vpa, 2, gl.FLOAT, false, 0, 0);
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.ibuf);
    gl.drawElements(gl.TRIANGLES, this.ind.length, gl.UNSIGNED_SHORT, 0)
};
UTgs.prototype.clear = function () {
    gl.deleteBuffer(this.vbuf);
    gl.deleteBuffer(this.ibuf);
    gl.deleteBuffer(this.tbuf)
};
FillStyle.prototype.Set = function (e, t) {
    this.color = e;
    this.alpha = t;
    var n = this.colARR;
    n[0] = (e >> 16 & 255) * .0039215686;
    n[1] = (e >> 8 & 255) * .0039215686;
    n[2] = (e & 255) * .0039215686;
    n[3] = t
};
LineStyle.prototype = new FillStyle;
LineStyle.prototype.Set = function (e, t, n) {
    this.thickness = e;
    FillStyle.prototype.Set.call(this, t, n)
};
Sprite.prototype = new DisplayObjectContainer;
Sprite.prototype._render = function (e) {
    if (!this.graphics._empty) this.graphics._render(e);
    DisplayObjectContainer.prototype._render.call(this, e)
};
Sprite.prototype._moveMouse = function (e, t, n) {
    if (!n || !this.visible || !this.mouseChildren && !this.mouseEnabled) return null;
    var r = DisplayObjectContainer.prototype._moveMouse.call(this, e, t, n);
    if (r != null) return r;
    if (!this.mouseEnabled) return null;
    var i = this._temp;
    if (this.graphics._hits(i[0], i[1])) return this;
    return null
};
Sprite.prototype._getRect = function (e) {
    var t;
    var n = DisplayObjectContainer.prototype._getRect.call(this, e);
    var r = this.graphics._getRect(e);
    if (n != null && r != null) n._unionWith(r);
    if (n != null) t = n;
    else t = r;
    return t
};
Sprite.prototype._htpLocal = function (e) {
    var t = this._temp;
    mat3.multiplyVec2(this._getIMat(), e, t);
    if (this.graphics._hits(t[0], t[1])) return true;
    return DisplayObjectContainer.prototype._htpLocal.call(this, e)
};
var TextFormatAlign = {
    LEFT: "left",
    CENTER: "center",
    RIGHT: "right",
    JUSTIFY: "justify"
};
TextFormat.prototype.clone = function () {
    return new TextFormat(this.font, this.size, this.color, this.bold, this.italic, this.align, this.leading)
};
TextFormat.prototype.set = function (e) {
    this.font = e.font;
    this.size = e.size;
    this.color = e.color;
    this.bold = e.bold;
    this.italic = e.italic;
    this.align = e.align;
    this.leading = e.leading
};
TextFormat.prototype.getImageData = function (e, t) {
    var n = TextFormat._canvas;
    var r = TextFormat._context;
    var i = this.data;
    n.width = i.rw = this._nhpt(t._areaW);
    n.height = i.rh = this._nhpt(t._areaH);
    var s = this.color;
    var o = s >> 16 & 255;
    var u = s >> 8 & 255;
    var a = s & 255;
    r.textBaseline = "top";
    r.fillStyle = "rgb(" + o + "," + u + "," + a + ")";
    r.font = (this.italic ? "italic " : "") + (this.bold ? "bold " : "") + this.size + "px " + this.font;
    this.maxW = 0;
    var f = e.split("\n");
    var l = 0;
    var c = 0;
    var h = this.size * 1.25;
    for (var p = 0; p < f.length; p++) {
        var d = this.renderPar(f[p], c, h, r, t);
        l += d;
        c += d * (h + this.leading)
    }
    if (this.align == TextFormatAlign.JUSTIFY) this.maxW = Math.max(this.maxW, t._areaW);
    i.image = n;
    i.tw = this.maxW;
    i.th = (h + this.leading) * l - this.leading;
    return i
};
TextFormat.prototype.renderPar = function (e, t, n, r, i) {
    var s;
    if (i._wordWrap) s = e.split(" ");
    else s = [e];
    var o = r.measureText(" ").width;
    var u = 0;
    var a = i._areaW;
    var f = 0;
    var l = [
        []
    ];
    var c = [];
    for (var h = 0; h < s.length; h++) {
        var p = s[h];
        var d = r.measureText(p).width;
        if (u + d <= a || u == 0) {
            l[f].push(p);
            u += d + o
        } else {
            c.push(a - u + o);
            l.push([]);
            f++;
            u = 0;
            h--
        }
    }
    c.push(a - u + o);
    for (var h = 0; h < l.length; h++) {
        var v = l[h];
        while (v[v.length - 1] == "") {
            v.pop();
            c[h] += o
        }
        this.maxW = Math.max(this.maxW, a - c[h]);
        var m, g = t + (n + this.leading) * h;
        u = 0, m = o;
        if (this.align == TextFormatAlign.CENTER) u = c[h] * .5;
        if (this.align == TextFormatAlign.RIGHT) u = c[h];
        if (this.align == TextFormatAlign.JUSTIFY) m = o + c[h] / (v.length - 1);
        for (var y = 0; y < v.length; y++) {
            var p = v[y];
            r.fillText(p, u, g);
            var d = r.measureText(p).width;
            if (h < l.length - 1) u += d + m;
            else {
                u += d + o
            }
        }
    }
    return f + 1
};
TextFormat.prototype._nhpt = function (e) {
    --e;
    for (var t = 1; t < 32; t <<= 1) e = e | e >> t;
    return e + 1
};
TextFormat._canvas = document.createElement("canvas");
TextFormat._context = TextFormat._canvas.getContext("2d");
TextField.prototype = new InteractiveObject;
TextField.prototype.setTextFormat = function (e) {
    this._tForm.set(e);
    this._update()
};
TextField.prototype.getTextFormat = function (e) {
    return this._tForm.clone()
};
TextField.prototype._update = function () {
    var e = this._brect.width = this._areaW;
    var t = this._brect.height = this._areaH;
    if (e == 0 || t == 0) return;
    var n = this._tForm.getImageData(this._text, this);
    this._textW = n.tw;
    this._textH = n.th;
    if (n.rw != this._rwidth || n.rh != this._rheight) {
        gl.deleteTexture(this._texture);
        this._texture = gl.createTexture()
    }
    gl.bindTexture(gl.TEXTURE_2D, this._texture);
    gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, n.image);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
    gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_NEAREST);
    gl.generateMipmap(gl.TEXTURE_2D);
    this._rwidth = n.rw;
    this._rheight = n.rh;
    var r = e / n.rw;
    var i = t / n.rh;
    var s = this._tcArray;
    s[2] = s[6] = r;
    s[5] = s[7] = i;
    gl.bindBuffer(gl.ARRAY_BUFFER, this._tcBuffer);
    gl.bufferSubData(gl.ARRAY_BUFFER, 0, s);
    var o = this._fArray;
    o[2] = o[6] = e;
    o[5] = o[7] = t;
    gl.bindBuffer(gl.ARRAY_BUFFER, this._vBuffer);
    gl.bufferSubData(gl.ARRAY_BUFFER, 0, o)
};
TextField.prototype._render = function (e) {
    if (this._areaW == 0 || this._areaH == 0) return;
    Stage._curBD = null;
    gl.uniformMatrix3fv(e._sprg.tMatUniform, false, e._mstack.top());
    gl.bindBuffer(gl.ARRAY_BUFFER, this._vBuffer);
    gl.vertexAttribPointer(e._sprg.vpa, 2, gl.FLOAT, false, 0, 0);
    gl.bindBuffer(gl.ARRAY_BUFFER, this._tcBuffer);
    gl.vertexAttribPointer(e._sprg.tca, 2, gl.FLOAT, false, 0, 0);
    gl.bindTexture(gl.TEXTURE_2D, this._texture);
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, e._unitIBuffer);
    gl.drawElements(gl.TRIANGLES, 6, gl.UNSIGNED_SHORT, 0)
};
this.tp = TextField.prototype;
tp.ds = tp.__defineSetter__;
tp.dg = tp.__defineGetter__;
tp.dg("textWidth", function () {
    return this._textW
});
tp.dg("textHeight", function () {
    return this._textH
});
tp.ds("wordWrap", function (e) {
    this._wordWrap = e;
    this._update()
});
tp.dg("wordWrap", function () {
    return this._wordWrap
});
tp.ds("width", function (e) {
    this._areaW = Math.max(0, e);
    this._update()
});
tp.dg("width", function () {
    return this._areaW
});
tp.ds("height", function (e) {
    this._areaH = Math.max(0, e);
    this._update()
});
tp.dg("height", function () {
    return this._areaH
});
tp.ds("text", function (e) {
    this._text = e.toString();
    this._update()
});
tp.dg("text", function () {
    return this._text
});
delete tp.ds;
delete tp.dg;
delete this.tp;
Resizable.prototype = new Sprite;
Resizable.prototype.resize = function (e, t) {
    this.w = e;
    this.h = t
};
MainMenu.prototype = new Resizable;
MainMenu.prototype.GoPlay = function () {
    this.dispatchEvent(new Event("GoPlay", true))
};
LevelSelect.prototype = new Resizable;
LevelSelect.prototype.LevelDone = function (e) {};
LevelSelect.prototype.GoBack = function (e) {
    this.dispatchEvent(new Event("GoBack", true))
};
LevelSelect.prototype.LevelChosen = function (e) {
    this.dispatchEvent(new Event("LevelChosen", true))
};
GameControl.prototype = new Resizable;
GameControl.prototype.GameDone = function (e) {
    this.dispatchEvent(new Event("GameDone", true))
};
GameControl.prototype.Restart = function (e) {
    this.dispatchEvent(new Event("Restart", true))
};
GameControl.prototype.ExitGame = function (e) {
    this.dispatchEvent(new Event("ExitGame", true))
};
Main.prototype = new Resizable;
Main.prototype.resize = function (e, t) {
    Resizable.prototype.resize.call(this, e, t);
    if (this.mm) this.mm.resize(e, t);
    if (this.ls) this.ls.resize(e, t);
    if (this.gc) this.gc.resize(e, t)
};
Main.GoPlay = function (e) {
    var t = e.target;
    t.removeChild(t.mm);
    t.addChild(t.ls)
};
Main.GoBack = function (e) {
    var t = e.target;
    t.removeChild(t.ls);
    t.addChild(t.mm)
};
Main.LevelChosen = function (e) {
    var t = e.target;
    t.removeChild(t.ls);
    t.addChild(t.gc);
    t.gc.StartLevel(t.ls.levelData)
};
Main.GameDone = function (e) {
    var t = e.target;
    t.removeChild(t.gc);
    t.addChild(t.ls);
    t.ls.LevelDone(t.gc.result)
};
Main.ExitGame = function (e) {
    var t = e.target;
    t.removeChild(t.gc);
    t.addChild(t.ls)
}