#include <camera.h> // Camera Native API header
#include "img-mods.h" // Our custom image modifications header

//=========================================
// CAMERA INITIALIZATION CODE
//=========================================

int ret = camera_create(CAMERA_DEVICE_CAMERA0, &camera);

//...
// Setting image to be captured in NV12
// and setting custom preview callback to grab and modify the preview frames
if (prepare_camera(view->camera) == 0)
{
	dlog_print(DLOG_INFO, LOG_TAG, "IMG-MODS Camera prepared!");
}
else
{
	dlog_print(DLOG_ERROR, LOG_TAG, "IMG-MODS Cannot prepare camera!");
}		
//...

ret = camera_start_preview(camera);
//=========================================


//=========================================
// CAPTURING PICTURE WITH CALLBACK
//=========================================

ret = camera_start_capture(camera, _capturing_cb, _capture_completed_cb, NULL);


//=========================================
// CALLBACK ON PICTURE CAPTURED
//=========================================

static void _capturing_cb(camera_image_data_s *image, camera_image_data_s *postview, camera_image_data_s *thumbnail, void *user_data)
{
//...

//We modify the picture taken
	if (modify_final_image(image) == 0)
	{
		dlog_print(DLOG_INFO, LOG_TAG, "IMG-MODS Captured photo modified!");
	}
	else
	{
		dlog_print(DLOG_ERROR, LOG_TAG, "IMG-MODS Modifying photo failed!");
	}

//We convert it to JPEG, save and update the media db.
//This must be done when we already know the path of the file to be saved.
	if (finalize_taking_picture(image, filename) == 0)
	{
		dlog_print(DLOG_INFO, LOG_TAG, "IMG-MODS Capturing finalized!");
	}
	else
	{
		dlog_print(DLOG_ERROR, LOG_TAG, "IMG-MODS Capturing finalizing failed!");
	}
//...
}
