var WebGlBox;

var renderer;

var displacementTexture;
var displacementFilter;

var pixelateFilter;
var blurFilter;
var dotScreenFilter;
var sepiaFilter;
var crossHatchFilter;

var stage;

var displaceContainer;

var count = 0;
var currentFilter = 0;

var filterArr = [];

//Initialize function
var init = function () {
	// TODO:: Do your initialization job
	console.log("init() called");
	
	WebGlBox = document.getElementsByTagName('html-gl')[0];
	
	renderer = window.HTMLGL.renderer;
	

	// get the PIXI stage
	   stage = window.HTMLGL.stage;
	   stage.interactive = true;

	// the WebGL box   
	   displaceContainer = WebGlBox.sprite;
	   
	// displacement filter
	   displacementTexture = PIXI.Texture.fromImage("images/displace.jpg");
	   displacementFilter = new PIXI.DisplacementFilter(displacementTexture);
	   
	   displacementFilter.scale.x = 50;
	   displacementFilter.scale.y = 50;

	// pixelate filter
	   pixelateFilter = new PIXI.PixelateFilter();
	   pixelateFilter.size = new PIXI.Point(6,6);
	
	// blur filter  
	   blurFilter = new PIXI.BlurFilter();
	   blurFilter.blurX = 6;
	   blurFilter.blurY = 6;
	   
	// dot filter
	   dotScreenFilter = new PIXI.DotScreenFilter();
	   dotScreenFilter.angle = 10;
	   dotScreenFilter.scale = 1;
	
	// crosss hatch filter
	   crossHatchFilter = new PIXI.CrossHatchFilter();
	 
	// sepia filter
       sepiaFilter = new PIXI.SepiaFilter();
	   
	////// ADD ALL FILTERS TO THE ARRAY //////
	   
	   filterArr = [displacementFilter, pixelateFilter, blurFilter, dotScreenFilter, sepiaFilter, crossHatchFilter];
	   
	   displaceContainer.filters = [displacementFilter];
	   
	//////////////////////////////////////////
	        
	    function animate() {
	
	            count += 0.1;
	    
	            displacementFilter.offset.x = count * 10
	            displacementFilter.offset.y = count * 10

	            renderer.render(stage);
	        
	        requestAnimFrame( animate );
	    }

	    renderer.render(stage);
	    requestAnimFrame( animate );
	    
	    function nextFilter() {

	    	   currentFilter++;
	    	   if (currentFilter > filterArr.length-1) currentFilter = 0;
	    	   
	    	   count = 0;
	    	   
	    	   displaceContainer.filters = [filterArr[currentFilter]];
   	
	    }
	    
	    // CHANGE FILTER
	    
	    WebGlBox.addEventListener("click", onTouch, false);

	    function onTouch(event) {
	    	
	    	console.log("TAP!");
	    	   
	    	   nextFilter();
	    	
	    }
	    
	// add eventListener for tizenhwkey
	document.addEventListener('tizenhwkey', function(e) {
		if(e.keyName == "back") {
			try {
				tizen.application.getCurrentApplication().exit();
			} catch (error) {
				console.error("getCurrentApplication(): " + error.message);
			}
		}
	});
};
// window.onload can work without <body onload="">
window.onload = init;
