/*******************************************************************************
 * @author Tomasz Scislo <a href='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/

var html5Features = (function ($) {
    var internetConnectionCheck, worker;

    internetConnectionCheck = function () {
        tlib.network.isInternetConnection(function (isConnection) {
            if (!isConnection) {
                view.showPopup("No Internet connection. Application may not work properly.");
            }
        });
    };

    return {
        /**
         * Provides initialization for the app
         */
        initialize : function () {
            $.extend($.mobile, {
                defaultPageTransition : "flip",
                loadingMessageTextVisible : true,
                pageLoadErrorMessage : "Unable to load page",
                pageLoadErrorMessageTheme : "d",
                touchOverflowEnabled : true,
                loadingMessage : "Please wait...",
                allowCrossDomainPages : true,
                ajaxEnabled : false
            });
            tlib.logger.changeLogLevel(3);
            tlib.logger.info("html5Features.initialize()");

            $('#WebSockets').live('pagehide', function () {
                tizenWebSocket.disconnect();
            }).live('pageshow', function () {
                tlib.logger.info("view");
                /**
                 * Checks Internet connection
                 */
                internetConnectionCheck();
                tizenWebSocket.connect();
                $("#message").unbind().keyup(function (event) {
                    /**
                     * Enter key event on input
                     */
                    if (event.keyCode === 13) {
                        event.preventDefault();
                        var message = $(this).val();
                        tizenWebSocket.send(message);
                    }
                });
            });

            $('#WebStorage').live('pageshow', function () {
                $("#clear").unbind().click(function () {
                    localStorage.clear();
                    tizenWebStorage.updateNameList();
                });
                $("#add").unbind().bind({
                    click : function () {
                        if ($('#first').val().trim() === "" || $('#second').val().trim() === "") {
                            view.showPopup("Please provide first and second name");
                        } else {
                            tizenWebStorage.addItem({
                                first : $('#first').val(),
                                second : $('#second').val()
                            });
                        }
                    }
                });
                tizenWebStorage.updateNameList();
            });

            $('#WebWorkers').live('pageshow', function () {
                $('#StartPrime').unbind().bind({
                    click : function (event) {
                        event.preventDefault();
                        tlib.logger.info("start worker");
                        // terminate old worker before starting the new one
                        try {
                            worker.terminate();
                        } catch (e) {
                            tlib.logger.warn("Unable to terminate worker");
                        }
                        worker = new Worker('./js/webWorker.js');
                        /**
                         * WebWorker returns calculated data here
                         */
                        worker.addEventListener('message', function (msg) {
                            $('#primeRes').text(msg.data);
                        }, false);
                        worker.postMessage();
                    }
                });

                $('#StopPrime').unbind().bind({
                    click : function (event) {
                        event.preventDefault();
                        tlib.logger.info("stop worker");
                        worker.terminate();
                    }
                });
            });

            $('#Multimedia').live('pagehide', function () {
                tizenVideo.stop();
            }).live('pageshow', function () {
                tizenVideo.setVideoInstance('video');
                tizenVideo.setCallbacks(function () {
                    view.showPopup("Playback error!");
                }, function () {
                    tlib.logger.info("Video End");
                    tizenVideo.fullscreen(false);
                });

                tizenVideo.bind({
                    play : $('#play'),
                    pause : $('#pause'),
                    stop : $('#stop'),
                    fullscreen : $('#fullScreen')
                });
            });

            $('#TouchEvents').live('pageshow', function () {
                touchEvents.setElement('touch');
                touchEvents.bindEvents();
            });
        }
    };
}(jQuery));