/*******************************************************************************
 * @author Tomasz Scislo <a href='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/

tizenWebStorage = (function ($) {
    return {
        updateNameList : function () {
            var that = this, i, key, element;

            $('#nameList').html('');
            for (i = 0; i < localStorage.length; i++) {
                key = localStorage.key(i);
                element = $.parseJSON(localStorage.getItem(key));

                $('#nameList').append('<li><a href="#WebStorage" id="' + key + '">' + element.second + ' ' + element.first + '</li> ').listview("refresh");
                $('#' + key).bind({
                    click : function (event) {
                        var key, answer;

                        event.preventDefault();

                        key = $(this).attr('id');
                        answer = confirm("Remove this item?");

                        if (answer) {
                            localStorage.removeItem(key);
                            that.updateNameList();
                        }
                    }
                });
            }
        },

        clear : function () {
            localStorage.clear();
        },

        addItem : function (item) {
            var key = (new Date()).getTime();
            localStorage.setItem(key, JSON.stringify(item));
            this.updateNameList();
        }
    };
}(jQuery));