/*******************************************************************************
 * @author Tomasz Scislo <a href='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/

touchEvents = (function ($) {
    var touch;

    return {
        setElement : function (id) {
            touch = document.getElementById(id);
        },

        bindEvents : function () {
            /**
             * Currently there is no possibility to bind touch events with
             * jQuery.bind method so we need to use pure ECMAScript
             * approach.
             */
            touch.addEventListener('touchmove', function () {
                $('#moving').text('YES');
            });

            touch.addEventListener('touchstart', function (ev) {
                var touchPoints = ev.targetTouches.length;
                if (touchPoints >= 3) {
                    $('#touchNo').text('3 or more fingers');
                } else {
                    $('#touchNo').text(touchPoints);
                }
            }, false);

            touch.addEventListener('touchend', function () {
                $('#touchNo').text('0 fingers');
                $('#moving').text('No');
            }, false);
        }
    };
}(jQuery));