/*******************************************************************************
 * @author Tomasz Scislo <a href='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/

tizenVideo = (function ($) {
    var videoInstance;

    return {
        getVideoInstance : function () {
            return videoInstance;
        },

        setVideoInstance : function (id) {
            videoInstance = document.getElementById(id);
        },

        play : function () {
            videoInstance.play();
        },

        pause : function () {
            videoInstance.pause();
        },

        stop : function () {
            try {
                videoInstance.pause();
                videoInstance.currentTime = 0;
            } catch (e) {
                tlib.logger.err("Unable to stop the Video!");
            }
        },

        /**
         * Key binders method
         * @param elements {Object} JSON stores all available keys for which the actions can be hooked
         */
        bind : function (elements) {
            var that = this;
            elements.play.unbind().bind({
                click : function (event) {
                    event.preventDefault();
                    that.play();
                }
            });
            elements.stop.unbind().bind({
                click : function (event) {
                    event.preventDefault();
                    that.stop();
                }
            });
            elements.pause.unbind().bind({
                click : function (event) {
                    event.preventDefault();
                    that.pause();
                }
            });
            elements.fullscreen.unbind().bind({
                click : function (event) {
                    event.preventDefault();
                    that.fullscreen(true);
                }
            });
        },
        /**
         * Method used to turn on/off fullscreen mode for video
         * @param flag {Boolean} If true we turn one fullscreen mode otherwise we turn it off
         */
        fullscreen : function (flag) {
            var that = this;

            if (flag) {
                videoInstance.webkitEnterFullscreen();
                /**
                 * When we enter fullscreen mode we should handle some event to allow user
                 * to leave fullscreen mode, because browser doesn't do it automatically.
                 * We use either swipeLeft or swipeRight for this.
                 */
                $(document).bind('webkitfullscreenchange', function () {
                    $('html').bind({
                        swipeleft : function () {
                            tlib.logger.info("In FullScreen swipe left");
                            that.fullscreen(false);
                        },
                        swiperight: function () {
                            tlib.logger.info("In FullScreen swipe right");
                            that.fullscreen(false);
                        }
                    });
                });
            } else {
                document.webkitCancelFullScreen();
                $('html').unbind();
            }
        },
        /**
         * Method used to set callbacks
         * @param errorCB {Function} Callback invoked in case of playback error
         * @param endCB {Function} Callback invoked in case of playback end
         */
        setCallbacks : function (errorCB, endCB) {
            videoInstance.addEventListener('ended', endCB);
            videoInstance.addEventListener('error', errorCB);
        }
    };
}($));