/*******************************************************************************
 * @author Tomasz Scislo <a href='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 ******************************************************************************/

var tizenWebSocket = (function (options) {
    var states, state, wsUri, output, websocket;

    states = {
        CONNECTED : 1,
        DISCONNECTED : 2,
        ERROR : 3
    };

    state = states.DISCONNECTED;

    wsUri = (options && options.server) ? options.server : "wss://echo.websocket.org/";

    output = function (txt) {
        $('#display').append("<div>" + txt + "</div>");
    };

    return {
        connect : function (callback) {
            var that = this;
            websocket = new WebSocket(wsUri);
            websocket.onopen = function (evt) {
                that.onOpen(evt);
                if (typeof callback === "function") {
                    callback();
                }
            };
            websocket.onclose = function (evt) {
                that.onClose(evt);
            };
            websocket.onmessage = function (evt) {
                that.onMessage(evt);
            };
            websocket.onerror = function (evt) {
                that.onError(evt);
            };

        },

        disconnect : function () {
            websocket.close();
        },

        onOpen : function () {
            output("CONNECTED");
            state = states.CONNECTED;
        },
        onClose : function () {
            output("DISCONNECTED");
            state = states.DISCONNECTED;
        },

        onMessage : function (evt) {
            output("RECEIVED: " + evt.data);
        },
        onError : function (evt) {
            output("ERROR: " + evt.data);
            state = states.ERROR;
        },

        /**
         * Sends message via web socket
         * @param txt {String} message to be sent
         * @returns {Boolean} true if successfully sent message, false otherwise
         */
        send : function (txt) {
            if (state === states.CONNECTED) {
                output("SEND: " + txt);
                websocket.send(txt);
                return true;
            } else {
                view.showPopup("Unable to send message");
                return false;
            }
        }
    };
}());