#include "wsysteminfo.h"
#include <system_info.h>

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
    Evas_Object *label1;
    Evas_Object *label2;
    Evas_Object *label3;
    Evas_Object *label4;
    Evas_Object *label5;
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static void
btn_clicked_cb(void *data, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    char buf[100];
    char *sValue = NULL;
    bool bValue = false;
    int nValue = 0;
    int ret;

    ret = system_info_get_platform_bool("http://tizen.org/feature/camera.back", &bValue);
    if (ret == SYSTEM_INFO_ERROR_NONE)
    {
        sprintf(buf, "Back Camera : %s", bValue ? "True" : "False");
        elm_object_text_set(ad->label1, buf);
    }

    ret = system_info_get_platform_bool("http://tizen.org/feature/network.telephony", &nValue);
    if (ret == SYSTEM_INFO_ERROR_NONE)
    {
        sprintf(buf, "Telephony : %s", bValue ? "True" : "False");
        elm_object_text_set(ad->label2, buf);
    }

    ret = system_info_get_platform_int("tizen.org/feature/screen.width", &nValue);
    if (ret == SYSTEM_INFO_ERROR_NONE)
    {
        sprintf(buf, "Pixel Width : %d", nValue);
        elm_object_text_set(ad->label3, buf);
    }

    ret = system_info_get_platform_int("tizen.org/feature/screen.height", &nValue);
    if (ret == SYSTEM_INFO_ERROR_NONE)
    {
        sprintf(buf, "Pixel Height : %d", nValue);
        elm_object_text_set(ad->label4, buf);
    }

    ret = system_info_get_platform_string("http://tizen.org/feature/platform.version", &sValue);
    if (ret == SYSTEM_INFO_ERROR_NONE)
    {
        sprintf(buf, "Platform Ver : %s", sValue);
        elm_object_text_set(ad->label5, buf);
    }
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

    /* Box */
    Evas_Object *box = elm_box_add(ad->win);
    elm_box_padding_set(box, ELM_SCALE_SIZE(10), ELM_SCALE_SIZE(10));
    elm_object_content_set(ad->conform, box);
    evas_object_show(box);

    {
        /* Button */
        Evas_Object *btn = elm_button_add(ad->conform);
        elm_object_text_set(btn, "System Info");
        evas_object_smart_callback_add(btn, "clicked", btn_clicked_cb, ad);
        evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0);
        evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, 0);
        elm_box_pack_end(box, btn);
        evas_object_show(btn);

        /* Label-1 */
        ad->label1 = elm_label_add(ad->conform);
        elm_object_text_set(ad->label1, "Back Camera :");
        evas_object_size_hint_weight_set(ad->label1, EVAS_HINT_EXPAND, 0);
        evas_object_size_hint_align_set(ad->label1, EVAS_HINT_FILL, 0);
        elm_box_pack_end(box, ad->label1);
        evas_object_show(ad->label1);

        /* Label-2 */
        ad->label2 = elm_label_add(ad->conform);
        elm_object_text_set(ad->label2, "Telephony :");
        evas_object_size_hint_weight_set(ad->label2, EVAS_HINT_EXPAND, 0);
        evas_object_size_hint_align_set(ad->label2, EVAS_HINT_FILL, 0);
        elm_box_pack_end(box, ad->label2);
        evas_object_show(ad->label2);

        /* Label-3 */
        ad->label3 = elm_label_add(ad->conform);
        elm_object_text_set(ad->label3, "Pixel Width :");
        evas_object_size_hint_weight_set(ad->label3, EVAS_HINT_EXPAND, 0);
        evas_object_size_hint_align_set(ad->label3, EVAS_HINT_FILL, 0);
        elm_box_pack_end(box, ad->label3);
        evas_object_show(ad->label3);

        /* Label-4 */
        ad->label4 = elm_label_add(ad->conform);
        elm_object_text_set(ad->label4, "Pixel Height :");
        evas_object_size_hint_weight_set(ad->label4, EVAS_HINT_EXPAND, 0);
        evas_object_size_hint_align_set(ad->label4, EVAS_HINT_FILL, 0);
        elm_box_pack_end(box, ad->label4);
        evas_object_show(ad->label4);

        /* Label-5 */
        ad->label5 = elm_label_add(ad->conform);
        elm_object_text_set(ad->label5, "Platform Ver :");
        evas_object_size_hint_weight_set(ad->label5, EVAS_HINT_EXPAND, 0);
        evas_object_size_hint_align_set(ad->label5, EVAS_HINT_FILL, 0);
        elm_box_pack_end(box, ad->label5);
        evas_object_show(ad->label5);
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
