#include "textfileview.h"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	//Evas_Object *label;
	Evas_Object *entry;
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static void
app_get_resource(const char *res_file_in, char *res_path_out, int res_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(res_path_out, res_path_max, "%s%s", res_path, res_file_in);
		free(res_path);
	}
}

/*static char*
read_file(const char* filepath)
{
	FILE *fp = fopen(filepath, "r");
	if (fp == NULL)
		return NULL;

	fseek(fp, 0, SEEK_END);
	int bufsize = ftell(fp);
	rewind(fp);

	if (bufsize < 1)
		return NULL;

	char *buf = malloc(sizeof(char) * (bufsize));
	memset(buf, '\0', sizeof(buf));
	char str[200];

	while(fgets(str, 200, fp) != NULL) {
		dlog_print(DLOG_ERROR, "tag", "%s", str);
		sprintf(buf + strlen(buf), "%s", str);
	}
	fclose(fp);
	return buf;
}*/

static void
app_get_data(const char *res_file_in, char *res_path_out, int res_path_max)
{
	char *res_path = app_get_data_path();
	if (res_path) {
		snprintf(res_path_out, res_path_max, "%s%s", res_path, res_file_in);
		free(res_path);
	}
}

static void
btn_read_cb(void *data, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    char filepath[PATH_MAX] = { 0, };
    Eina_File *f;

    app_get_data("text.txt", filepath, PATH_MAX);
    f = eina_file_open(filepath, EINA_FALSE);
    if (!f)
    {
        app_get_resource("text.txt", filepath, PATH_MAX);
        f = eina_file_open(filepath, EINA_FALSE);
        if (!f)
        {
            elm_object_text_set(ad->entry, "File not found!");
            return;
        }
    }
    elm_entry_file_set(ad->entry, filepath, ELM_TEXT_FORMAT_MARKUP_UTF8);
    eina_file_close(f);
}

static char*
write_file(const char* filepath, const char* buf)
{
	FILE *fp;
	fp = fopen(filepath, "w");
	fputs(buf, fp);
	fclose(fp);
}

static void
btn_write_cb(void *data, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    char filepath[PATH_MAX] = { 0, };

    app_get_data("text.txt", filepath, PATH_MAX);
    write_file(filepath, elm_entry_entry_get(ad->entry));
    elm_entry_file_set(ad->entry, filepath, ELM_TEXT_FORMAT_MARKUP_UTF8);
}

static void
my_table_pack(Evas_Object *table, Evas_Object *child, int col, int row, int spanx, int spany,
      double h_expand, double v_expand, double h_align, double v_align)
{
    /* Create a frame around the child, for padding */
    Evas_Object *frame = elm_frame_add(table);
    elm_object_style_set(frame, "pad_small");

    evas_object_size_hint_weight_set(frame, h_expand, v_expand);
    evas_object_size_hint_align_set(frame, h_align, v_align);

    /* place child in its box */
    {
        evas_object_size_hint_weight_set(child, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        evas_object_size_hint_align_set(child, EVAS_HINT_FILL, EVAS_HINT_FILL);
        elm_object_content_set(frame, child);
        evas_object_show(child);
    }

    elm_table_pack(table, frame, col, row, spanx, spany);
    evas_object_show(frame);
}

static Evas_Object *
my_button_add(Evas_Object *parent, const char *text, Evas_Smart_Cb cb, void *cb_data)
{
    Evas_Object *btn;

    btn = elm_button_add(parent);
    elm_object_text_set(btn, text);
    evas_object_smart_callback_add(btn, "clicked", cb, cb_data);

    return btn;
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    {
        Evas_Object *tbl, *btn, *frame;

        /* Frame */
        frame = elm_frame_add(ad->win);
        elm_object_style_set(frame, "pad_medium");
        elm_object_content_set(ad->conform, frame);
        evas_object_size_hint_weight_set(frame, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        evas_object_size_hint_align_set(frame, EVAS_HINT_FILL, EVAS_HINT_FILL);
        evas_object_show(frame);

        /* Container: standard table */
        tbl = elm_table_add(ad->win);
        evas_object_size_hint_weight_set(tbl, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        evas_object_size_hint_align_set(tbl, EVAS_HINT_FILL, EVAS_HINT_FILL);
        elm_object_content_set(frame, tbl);
        evas_object_show(tbl);

        {
            /* Button-1 */
            btn = my_button_add(ad->conform, "Read", btn_read_cb, ad);
            my_table_pack(tbl, btn, 0, 0, 1, 1, EVAS_HINT_EXPAND, 0.0, EVAS_HINT_FILL, EVAS_HINT_FILL);

            /* Button-2 */
            btn = my_button_add(ad->conform, "Write", btn_write_cb, ad);
            my_table_pack(tbl, btn, 1, 0, 1, 1, EVAS_HINT_EXPAND, 0.0, EVAS_HINT_FILL, EVAS_HINT_FILL);

            /* Entry */
            ad->entry = elm_entry_add(ad->conform);
            elm_entry_scrollable_set(ad->entry, EINA_TRUE);
            elm_object_signal_emit(ad->entry, "elm,state,scroll,enabled", "");
            elm_object_text_set(ad->entry, "Please press <b>Read</> button");
            my_table_pack(tbl, ad->entry, 0, 1, 2, 1, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND, EVAS_HINT_FILL, EVAS_HINT_FILL);

            /* Disable autosave, we want to save on click only */
            elm_entry_autosave_set(ad->entry, EINA_FALSE);
        }
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
