#include "xmlparse.h"
#include <libxml/HTMLparser.h>

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
    bool value_begin;
    int value_type;
    char buffer[1024];
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

void
walkTree1(xmlNode * a_node, appdata_s *ad)
{
    xmlNode *cur_node = NULL;
    xmlChar *key = NULL;
    xmlChar *value = NULL;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next)
    {
        if(!strcmp((const char*)cur_node->name, "name"))
            ad->value_type = 1;
        if(!strcmp((const char*)cur_node->name, "math"))
            ad->value_type = 2;

        if(!strcmp((const char*)cur_node->name, "text")) {
            if( ad->value_type == 1 )
            {
                value = cur_node->content;
                strcat(ad->buffer, "Name : ");
                strcat(ad->buffer, (char*)value);
                ad->value_type = 0;
            }
            else if( ad->value_type == 2 )
            {
                value = cur_node->content;
                strcat(ad->buffer, " / Math : ");
                strcat(ad->buffer, (char*)value);
                strcat(ad->buffer, "<br/>");
                ad->value_type = 0;
            }
        }

        walkTree1(cur_node->children, ad);
    }
}

static void
btn_parse1_cb(void *data, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    const char* buf = "<name>Elsa</name><math>95</math>";

    htmlParserCtxtPtr parser = htmlCreatePushParserCtxt(NULL, NULL, NULL, 0, NULL, 0);
    htmlCtxtUseOptions(parser, HTML_PARSE_NOBLANKS | HTML_PARSE_NOERROR | HTML_PARSE_NOWARNING | HTML_PARSE_NONET);
    htmlParseChunk(parser, buf, strlen(buf), 0);

    ad->buffer[0] = '\0';
    ad->value_type = 0;
    walkTree1(xmlDocGetRootElement(parser->myDoc), ad);
    elm_object_text_set(ad->label, ad->buffer);
}

void
walkTree2(xmlDoc *doc, xmlNode * a_node, appdata_s *ad)
{
    xmlNode *cur_node = NULL;
    xmlAttr *cur_attr = NULL;
    xmlChar *key = NULL;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next)
    {
        for (cur_attr = cur_node->properties; cur_attr; cur_attr = cur_attr->next) {
            key = xmlGetProp(cur_node, cur_attr->name);

            if(!strcmp((const char*)cur_attr->name, "name"))
            {
                strcat(ad->buffer, "Name : ");
                strcat(ad->buffer, key);
            }
            if(!strcmp((const char*)cur_attr->name, "math"))
            {
                strcat(ad->buffer, " / Math : ");
                strcat(ad->buffer, key);
                strcat(ad->buffer, "<br/>");
            }

            if(key!=NULL)
            {
            	xmlFree(key);
            	key=NULL;
            }
        }
        walkTree2(doc, cur_node->children, ad);
    }
}

static void
btn_parse2_cb(void *data, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    const char* buf = "<?xml version=\"1.0\" encoding=\"utf-8\"?> <grade> <name>M.I.T</name> <student name=\"Aurora\" math=\"27\"></student> <student name=\"Piana\" math=\"88\"></student> <student name=\"Tangled\" math=\"77\"></student> </grade>";

    htmlParserCtxtPtr parser = htmlCreatePushParserCtxt(NULL, NULL, NULL, 0, NULL, 0);
    htmlCtxtUseOptions(parser, HTML_PARSE_NOBLANKS | HTML_PARSE_NOERROR | HTML_PARSE_NOWARNING | HTML_PARSE_NONET);

    htmlParseChunk(parser, buf, strlen(buf), 0);
    ad->buffer[0] = '\0';
    walkTree2(parser->myDoc, xmlDocGetRootElement(parser->myDoc), ad);
    elm_object_text_set(ad->label, ad->buffer);
}

void
walkTree3(xmlDoc *doc, xmlNode * a_node, appdata_s *ad)
{
    xmlNode *cur_node = NULL;
    xmlAttr *cur_attr = NULL;
    xmlChar *key = NULL;
    xmlChar *value = NULL;

    for (cur_node = a_node; cur_node; cur_node = cur_node->next)
    {
        if(!strcmp((const char*)cur_node->name, "student") )
            ad->value_begin = true;

        if(!strcmp((const char*)cur_node->name, "name") && ad->value_begin)
            ad->value_type = 1;
        if(!strcmp((const char*)cur_node->name, "math") && ad->value_begin)
            ad->value_type = 2;

        if(!strcmp((const char*)cur_node->name, "text")) {
            if( ad->value_type == 1 )
            {
                value = (char*)cur_node->content;
                strcat(ad->buffer, "Name : ");
                strcat(ad->buffer, (char*)value);
                ad->value_type = 0;
            }
            else if( ad->value_type == 2 )
            {
                value = (char*)cur_node->content;
                strcat(ad->buffer, " / Math : ");
                strcat(ad->buffer, (char*)value);
                strcat(ad->buffer, "<br/>");
                ad->value_type = 0;
            }
        }

        walkTree3(doc, cur_node->children, ad);
    }
}

static void
btn_parse3_cb(void *data, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    const char* buf = "<?xml version=\"1.0\" encoding=\"utf-8\"?> <grade> <name>M.I.T</name> <student><name>Obama</name><math>50</math></student> <student><name>Psy</name><math>70</math></student> <student><name>Yuna</name><math>65</math></student> </grade>";

    htmlParserCtxtPtr parser = htmlCreatePushParserCtxt(NULL, NULL, NULL, 0, NULL, 0);
    htmlCtxtUseOptions(parser, HTML_PARSE_NOBLANKS | HTML_PARSE_NOERROR | HTML_PARSE_NOWARNING | HTML_PARSE_NONET);
    htmlParseChunk(parser, buf, strlen(buf), 0);

    ad->value_begin = false;
    ad->buffer[0] = '\0';
    ad->value_type = 0;
    walkTree3(parser->myDoc, xmlDocGetRootElement(parser->myDoc), ad);

    elm_object_text_set(ad->label, ad->buffer);
}

static void
my_box_pack(Evas_Object *box, Evas_Object *child, double h_weight, double v_weight,
        double h_align, double v_align)
{
	/* create a frame we shall use as padding around the child widget */
	Evas_Object *frame = elm_frame_add(box);
	/* use the medium padding style. there is "pad_small", "pad_medium",
	 * "pad_large" and "pad_huge" available as styles in addition to the
	 * "default" frame style */
	elm_object_style_set(frame, "pad_medium");
	/* set the input weight/aling on the frame insted of the child */
	evas_object_size_hint_weight_set(frame, h_weight, v_weight);
	evas_object_size_hint_align_set(frame, h_align, v_align);
	{
		/* tell the child that is packed into the frame to be able to expand */
		evas_object_size_hint_weight_set(child, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
		/* fill the expanded area (above) as opposaed to center in it */
		evas_object_size_hint_align_set(child, EVAS_HINT_FILL, EVAS_HINT_FILL);
		/* actually put the child in the frame and show it */
		evas_object_show(child);
		elm_object_content_set(frame, child);
	}
	/* put the frame into the box instead of the child directly */
	elm_box_pack_end(box, frame);
	/* show the frame */
	evas_object_show(frame);
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	if (elm_win_wm_rotation_supported_get(ad->win)) {
		int rots[4] = { 0, 90, 180, 270 };
		elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);
	}

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    Evas_Object *box, *btn;

    /* Box */
    box = elm_box_add(ad->conform);
    elm_box_horizontal_set(box, EINA_FALSE);
    evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_object_content_set(ad->conform, box);
    evas_object_show(box);

    {
        /* Label */
        ad->label = elm_label_add(ad->conform);
        elm_object_text_set(ad->label, "<align=center>Hello EFL</>");
        my_box_pack(box, ad->label, 1.0, 1.0, -1.0, -1.0);

        /* Button-1 */
        btn = elm_button_add(ad->conform);
        elm_object_text_set(btn, "Parse1");
        evas_object_smart_callback_add(btn, "clicked", btn_parse1_cb, ad);
        my_box_pack(box, btn, 1.0, 0.0, -1.0, 1.0);

        /* Button-2 */
        btn = elm_button_add(ad->conform);
        elm_object_text_set(btn, "Parse2");
        evas_object_smart_callback_add(btn, "clicked", btn_parse2_cb, ad);
        my_box_pack(box, btn, 1.0, 0.0, -1.0, 1.0);

        /* Button-3 */
        btn = elm_button_add(ad->conform);
        elm_object_text_set(btn, "Parse3");
        evas_object_smart_callback_add(btn, "clicked", btn_parse3_cb, ad);
        my_box_pack(box, btn, 1.0, 0.0, -1.0, 1.0);
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
