#include "notifyex.h"

typedef struct appdata {
    Evas_Object *win;
    Evas_Object *conform;
    //Evas_Object *label;
    Evas_Object *box;
    Evas_Object *frame;
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static Evas_Object*
create_notify_top_timeout(appdata_s *ad)
{
    Evas_Object *notify;
    Evas_Object *label;

    const char *msg =
    		"<align=center>This notification will hide automatically in 3 seconds later.</>";

    /* Create notify (top-aligned / hide automatically) */
    notify = elm_notify_add(ad->frame);
    elm_notify_align_set(notify, EVAS_HINT_FILL, 0.0);
    elm_notify_timeout_set(notify, 3.0);

    /* Create label for notify message */
    label = elm_label_add(notify);
    evas_object_size_hint_weight_set(label, 1.0, 0.0);
    evas_object_size_hint_align_set(label, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_label_line_wrap_set(label, ELM_WRAP_WORD);
    elm_object_text_set(label, msg);
    elm_object_content_set(notify, label);
    evas_object_show(label);

    /* We do NOT show the notify yet */
    return notify;
}

static void
btn_click_cb(void *data, Evas_Object *obj, void *event_info)
{
    Evas_Object *notify = data;
    /* Raise object, i.e. place it above all other objects,
     * as it was created before some other objects (buttons).
     */
    evas_object_raise(notify);
    evas_object_show(notify);
}

static void
btn_hide_notify_cb(void *data, Evas_Object *obj, void *event_info)
{
    Evas_Object *notify = data;
    evas_object_hide(notify);
}

static Evas_Object*
create_notify_top_manual(appdata_s *ad)
{
    Evas_Object *notify;
    Evas_Object *box;
    Evas_Object *label;
    Evas_Object *btn;

    const char *msg =
    		"<align=center>Click OK to hide this notification.</>";

    /* Create notify (top-aligned / hide manually) */
    notify = elm_notify_add(ad->frame);
    elm_notify_align_set(notify, EVAS_HINT_FILL, 0.0);
    elm_notify_timeout_set(notify, 0.0);

    /* Create box for stacking notify message and button vertically */
    box = elm_box_add(notify);
    evas_object_show(box);

    /* Create label for notify message */
    label = elm_label_add(box);
    evas_object_size_hint_weight_set(label, 1.0, 0.0);
    evas_object_size_hint_align_set(label, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_label_line_wrap_set(label, ELM_WRAP_WORD);
    elm_object_text_set(label, msg);
    elm_box_pack_end(box, label);
    evas_object_show(label);

    /* Create button to hide notify */
    btn = elm_button_add(box);
    elm_object_text_set(btn, "OK");
    evas_object_size_hint_weight_set(btn, 1.0, 0.0);
    evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_box_pack_end(box, btn);
    evas_object_show(btn);
    evas_object_smart_callback_add(btn, "clicked", btn_hide_notify_cb, notify);

    elm_object_content_set(notify, box);

    /* We do NOT show the notify yet */
    return notify;
}

static Evas_Object*
create_notify_top_block(appdata_s *ad)
{
    Evas_Object *notify;
    Evas_Object *label;

    const char *msg =
    		"<align=center>Events blocked when this notification is visible."
    		"<br/>This message will be dismissed after 3 seconds.</>";

    /* Create notify (top-aligned / hide automatically / block outside events) */
    notify = elm_notify_add(ad->frame);
    elm_notify_align_set(notify, EVAS_HINT_FILL, 0.0);
    elm_notify_timeout_set(notify, 3.0);
    elm_notify_allow_events_set(notify, EINA_FALSE);

    /* Create label for notify message */
    label = elm_label_add(notify);
    evas_object_size_hint_weight_set(label, 1.0, 0.0);
    evas_object_size_hint_align_set(label, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_label_line_wrap_set(label, ELM_WRAP_WORD);
    elm_object_text_set(label, msg);
    elm_object_content_set(notify, label);
    evas_object_show(label);

    /* We do NOT show the notify yet */
    return notify;
}

static Evas_Object*
create_notify_bottom_timeout(appdata_s *ad)
{
    Evas_Object *notify;
    Evas_Object *label;

    const char *msg =
        "<align=center>This notification shows at the bottom of the screen."
        "<br/>This message will be dismissed after 3 seconds.</>";

    /* Create notify (bottom-aligned / hide automatically) */
    notify = elm_notify_add(ad->frame);
    elm_notify_align_set(notify, EVAS_HINT_FILL, 1.0);
    elm_notify_timeout_set(notify, 3.0);

    /* Create label for notify message */
    label = elm_label_add(notify);
    evas_object_size_hint_weight_set(label, 1.0, 0.0);
    evas_object_size_hint_align_set(label, EVAS_HINT_FILL, EVAS_HINT_FILL);
    elm_label_line_wrap_set(label, ELM_WRAP_WORD);
    elm_object_text_set(label, msg);
    evas_object_show(label);

    elm_object_content_set(notify, label);

    /* We do NOT show the notify yet */
    return notify;
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    /* Frame for padding */
    ad->frame = elm_frame_add(ad->win);
    elm_object_style_set(ad->frame, "pad_large");
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_object_content_set(ad->conform, ad->frame);
    evas_object_show(ad->frame);

    {
        /* Vertical box */
        ad->box = elm_box_add(ad->conform);
        elm_box_padding_set(ad->box, ELM_SCALE_SIZE(20), ELM_SCALE_SIZE(20));
        evas_object_size_hint_weight_set(ad->box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        evas_object_size_hint_align_set(ad->box, EVAS_HINT_FILL, EVAS_HINT_FILL);
        elm_object_content_set(ad->frame, ad->box);
        evas_object_show(ad->box);

        Evas_Object *notify = create_notify_top_timeout(ad);

        /* Button-1 */
        Evas_Object *btn = elm_button_add(ad->win);
        elm_object_text_set(btn, "Top / Time out");
    	evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0.0);
    	evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, 0.0);
        evas_object_smart_callback_add(btn, "clicked", btn_click_cb, notify);
        elm_box_pack_end(ad->box, btn);
        evas_object_show(btn);

        notify = create_notify_top_manual(ad);

        /* Button-2 */
        btn = elm_button_add(ad->win);
        elm_object_text_set(btn, "Top / Manual");
    	evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0.0);
    	evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, 0.0);
        evas_object_smart_callback_add(btn, "clicked", btn_click_cb, notify);
        elm_box_pack_end(ad->box, btn);
        evas_object_show(btn);

        notify = create_notify_top_block(ad);

        /* Button-3 */
        btn = elm_button_add(ad->win);
        elm_object_text_set(btn, "Top / Block");
        evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0.0);
        evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, 0.0);
        evas_object_smart_callback_add(btn, "clicked", btn_click_cb, notify);
        elm_box_pack_end(ad->box, btn);
        evas_object_show(btn);

        notify = create_notify_bottom_timeout(ad);

        /* Button-4 */
        btn = elm_button_add(ad->win);
        elm_object_text_set(btn, "Bottom / Timeout");
        evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0.0);
        evas_object_size_hint_align_set(btn, EVAS_HINT_FILL, 0.0);
        evas_object_smart_callback_add(btn, "clicked", btn_click_cb, notify);
        elm_box_pack_end(ad->box, btn);
        evas_object_show(btn);
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;
	elm_app_base_scale_set(1.8);
	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
