#include "jsonparse.h"
#include <json-glib/json-glib.h>

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static void
parse_json(appdata_s *ad)
{
    JsonParser *parser = json_parser_new();
    char buf[256];
    buf[0] = '\0';

    const char* data1 = "[11, 22, 33, 44, 55]";

    if( json_parser_load_from_data( parser, data1, strlen(data1), NULL))
    {
        JsonNode *root = json_parser_get_root (parser);
        JsonArray *temp_array = json_node_get_array ( root );
        for(int i=0; i < json_array_get_length(temp_array); i++ ) {
            sprintf(buf, "%s - %d", buf, json_array_get_int_element(temp_array, i));
        }
        dlog_print(DLOG_DEBUG, "tag", "item %s", buf);
    }

    const char* data2 = "{'time': '03:53:25 AM', 'millisec_epoch': 1362196405309, 'date': '03-02-2013'}";
    if( json_parser_load_from_data( parser, data2, strlen(data2), NULL))
    {
        JsonNode *root = json_parser_get_root (parser);
        JsonObject *obj = json_node_get_object(root);
        char* time_data = json_object_get_string_member (obj, "time");
        long long epoch_data = json_object_get_int_member (obj, "millisec_epoch");
        sprintf(buf, "%s <br/><br/> time - %s <br/> epoch - %lld", buf, time_data, epoch_data);
    }

    const char* data3 = "{'coord':{'lon':127.03, 'lat':37.5}, 'weather':[{'id':800, 'main':'Clear'}, {'id':887, 'main':'Cloudy'}]}";
    if( json_parser_load_from_data( parser, data3, strlen(data3), NULL))
    {
        JsonNode *root = json_parser_get_root (parser);
        JsonObject *obj = json_node_get_object(root);
        JsonNode *temp_node = json_object_get_member (obj, "coord");
        JsonObject *temp_object = json_node_get_object(temp_node);
        sprintf(buf, "%s <br/><br/> coord:lon - %0.2f", buf, json_object_get_double_member (temp_object, "lon"));

        temp_node = json_object_get_member ( obj,"weather" );
        JsonArray *temp_array = json_node_get_array ( temp_node );
        temp_node = json_array_get_element(temp_array, 0 );
        temp_object = json_node_get_object( temp_node );
        sprintf(buf, "%s <br/> weather:id - %d", buf, json_object_get_int_member (temp_object, "id"));
    }

    elm_object_text_set(ad->label, buf);
    //free(parser);
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	/* Label*/
	ad->label = elm_label_add(ad->conform);
	evas_object_size_hint_weight_set(ad->label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_content_set(ad->conform, ad->label);

	/* Show window after base gui is set up */
	evas_object_show(ad->win);

    parse_json(ad);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
