#include "multilang.h"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
	Evas_Object* naviframe;
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    /* Naviframe */
    ad->naviframe = elm_naviframe_add(ad->conform);
    eext_object_event_callback_add(ad->naviframe, EEXT_CALLBACK_BACK, win_back_cb, ad);
    elm_object_content_set(ad->conform, ad->naviframe);

    /* Box */
    Evas_Object *box = elm_box_add(ad->naviframe);
    elm_box_padding_set(box, 0, ELM_SCALE_SIZE(20));

    /* Push a view to naviframe */
    Elm_Object_Item *nf_it = elm_naviframe_item_push(ad->naviframe, "IDS_SELECT_ITEM", NULL, NULL, box, NULL);
    /* Mark naviframe title as translatable text */
    elm_object_item_part_text_translatable_set(nf_it, NULL, EINA_TRUE);

    {
        /* Label*/
        ad->label = elm_label_add(ad->conform);
        elm_object_text_set(ad->label, i18n_get_text("IDS_CURRENT"));
        //evas_object_size_hint_weight_set(ad->label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        //elm_object_content_set(ad->conform, ad->label);
        evas_object_size_hint_weight_set(ad->label, EVAS_HINT_EXPAND, 0.0);
        evas_object_size_hint_align_set(ad->label, 0.5, 0.0);
        elm_box_pack_end(box, ad->label);
        evas_object_show(ad->label);

        /* Button */
        Evas_Object* btn = elm_button_add(ad->conform);
        elm_object_translatable_text_set(btn, "IDS_DONE");
        evas_object_size_hint_weight_set(btn, EVAS_HINT_EXPAND, 0.0);
        evas_object_size_hint_align_set(btn, -1.0, 0.0);
        elm_box_pack_end(box, btn);
        evas_object_show(btn);

        /* Label*/
        Evas_Object *o = elm_label_add(ad->conform);
        elm_label_line_wrap_set(o, ELM_WRAP_WORD);
        elm_object_text_set(o, "This label is not translatable.<br/>"
            "Go to Settings to change the device language and see how the above items will get translated.<br/>"
            "Supported languages are: English, Korean, Russian.");
        evas_object_size_hint_weight_set(o, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        evas_object_size_hint_align_set(o, -1.0, 0.0);
        elm_box_pack_end(box, o);
        evas_object_show(o);
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	char *locale = NULL;

	/* Get the system language and set that for our app */
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);

    appdata_s* ad = user_data;
	/* ad->label text was set manually, so it needs to be reset */
    elm_object_text_set(ad->label, i18n_get_text("IDS_CURRENT"));
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
