#include "filelist.h"

#define FM_PHONE_FOLDER    "/opt/usr/media"
#define FM_MEMORY_FOLDER   "/opt/storage/sdcard"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
    Evas_Object *list;
    char *current_path;
} appdata_s;

static void read_dir(appdata_s *ad);

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static char*
get_file_name(const char* item_text, bool *is_file)
{
    if( item_text[0] == '#' )
        *is_file = true;
    else
        *is_file = false;

    if( strcmp(item_text, "..") == 0 )
        return item_text;
    return item_text + 2;
}

static char*
get_new_path(char *current_path, const char *folder_name)
{
    if( strcmp(folder_name, "..") == 0)
    {
        int pos = strlen( current_path ) - strlen( strrchr( current_path, '/') );
        current_path[pos] = '\0';
    }
    else
        sprintf(current_path, "%s/%s", current_path, folder_name);
    return current_path;
}

static void
list_item_clicked(void *data, Evas_Object *obj, void *event_info)
{
    Elm_Object_Item *it = event_info;
    const char *item_text = elm_object_item_text_get(it);

    bool is_file;
    char *file_name = get_file_name(item_text, &is_file);
    if( is_file )
        return;

    appdata_s *ad = data;
    ad->current_path = get_new_path(ad->current_path, file_name);

    read_dir( ad );
}

static void
read_dir(appdata_s *ad)
{
    DIR *dir = opendir(ad->current_path);
    if( !dir )
        return;

    struct dirent *pDirent = NULL;
    char buf[100];
    elm_list_clear(ad->list);

    if( strcmp(ad->current_path, FM_PHONE_FOLDER) != 0 )
        elm_list_item_append(ad->list, "..", NULL, NULL, list_item_clicked, ad);

    while ((pDirent = readdir(dir)) != NULL)
    {
        if( strcmp(pDirent->d_name, ".") == 0 )
            continue;
        if( strcmp(pDirent->d_name, "..") == 0 )
            continue;

        if( pDirent->d_type == DT_DIR ) {
            dlog_print(DLOG_INFO, "tag", "[Folder] %s", pDirent->d_name);
            sprintf(buf, "[ %s", pDirent->d_name);
        }
        else {
            dlog_print(DLOG_INFO, "tag", "[File] %s", pDirent->d_name);
            sprintf(buf, "# %s", pDirent->d_name);
        }
        elm_list_item_append(ad->list, buf, NULL, NULL, list_item_clicked, ad);
        //elm_list_item_append(ad->list, buf, NULL, NULL, NULL, ad);
    }
    closedir(dir);
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    {
        /* Box */
        Evas_Object *box = elm_box_add(ad->win);
        evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
        elm_object_content_set(ad->conform, box);
        evas_object_show(box);

        {
            /* List */
            ad->list = elm_list_add(ad->conform);
            elm_list_mode_set(ad->list, ELM_LIST_COMPRESS);
            evas_object_size_hint_weight_set(ad->list, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
            evas_object_size_hint_align_set(ad->list, EVAS_HINT_FILL, EVAS_HINT_FILL);
            elm_box_pack_end(box, ad->list);
            evas_object_show(ad->list);
        }
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);

    ad->current_path = calloc(PATH_MAX, sizeof(char));
    strcpy(ad->current_path, FM_PHONE_FOLDER );
    read_dir( ad );
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
