#include "drawgradiation.h"

typedef struct appdata {
    Evas_Object *win;
    Evas_Object *conform;
    //Evas_Object *label;
    Evas_Object *imgs[5];
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static Evas_Object *
create_gradient_rect(appdata_s *ad, unsigned i)
//create_gradient_rect(appdata_s *ad)
{
    /* Generate gradient data on the fly */
    const int colors[8][4] = {
        /* red to blue */
        { 255, 0, 0, 255 }, { 0, 0, 255, 255 },
        /* black to transparent */
        { 0, 0, 0, 255 }, { 0, 0, 0, 0 },
        /* green to orange */
        { 0, 255, 0, 255 }, { 255, 128, 0, 255 },
        /* yellow to cyan */
        { 255, 255, 0, 255 }, { 0, 255, 255, 255 }
    };
    /*const int colors[2][4] = {
         red to blue
        { 255, 0, 0, 255 }, { 0, 0, 255, 255 },
    };*/

    Evas_Object *img;
    unsigned int *data32;

    /* Create image object, set its image data size & type */
    Evas* canvas = evas_object_evas_get(ad->win);
    img = evas_object_image_filled_add(canvas);
    /* BGRA data */
    evas_object_image_colorspace_set(img, EVAS_COLORSPACE_ARGB8888);
    /* Size is 255x1 */
    evas_object_image_size_set(img, 255, 1);
    /* Mark image as having alpha */
    evas_object_image_alpha_set(img, EINA_TRUE);

    /* get a writable data pointer */
    data32 = evas_object_image_data_get(img, EINA_TRUE);

    for (unsigned x = 0; x < 255; x++)
    {
        int r, g, b, a;
        /* interpolate alpha */
        a = (colors[i*2][3] * (255 - x) + colors[i*2+1][3] * x) / (2 * 255);
        /* interpolate red */
        r = (colors[i*2][0] * colors[i*2][3] * (255 - x) + colors[i*2+1][0] * colors[i*2+1][3] * (x)) / (2 * 255 * 255);
        /* interpolate green */
        g = (colors[i*2][1] * colors[i*2][3] * (255 - x) + colors[i*2+1][1] * colors[i*2+1][3] * (x)) / (2 * 255 * 255);
        /* interpolate blue */
        b = (colors[i*2][2] * colors[i*2][3] * (255 - x) + colors[i*2+1][2] * colors[i*2+1][3] * (x)) / (2 * 255 * 255);
        /* write pixel value now */
        data32[x] = (a << 24) | (r << 16) | (g << 8) | b;
    }

    /* very important: set data back */
    evas_object_image_data_set(img, data32);

    evas_object_size_hint_weight_set(img, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(img, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_show(img);
    return img;
}

static Evas_Object *
create_rainbow_rect(appdata_s *ad)
{
    /* A much simpler method for gradients is to simply use an image from disk */
    Evas_Object *img;
    char path[PATH_MAX];

    /* Create image object, set its image data size & type */
    Evas* canvas = evas_object_evas_get(ad->win);
    img = evas_object_image_filled_add(evas_object_evas_get(canvas));

    snprintf(path, sizeof(path), "%s/rainbow.png", app_get_resource_path());
    dlog_print(DLOG_ERROR, LOG_TAG, "path: '%s'", path);
    evas_object_image_file_set(img, path, NULL);

    evas_object_size_hint_weight_set(img, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    evas_object_size_hint_align_set(img, EVAS_HINT_FILL, EVAS_HINT_FILL);
    evas_object_show(img);
    return img;
}

static void
create_base_gui(appdata_s *ad)
{
	/* set up policy to exit when last window is closed */
	elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

    /* Conformant */
    ad->conform = elm_conformant_add(ad->win);
    elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
    elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
    evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
    elm_win_resize_object_add(ad->win, ad->conform);
    evas_object_show(ad->conform);

    Evas_Object *box = elm_box_add(ad->conform);
    elm_box_padding_set(box, ELM_SCALE_SIZE(10), ELM_SCALE_SIZE(10));
    elm_object_content_set(ad->conform, box);
    evas_object_show(box);

    {
        //ad->imgs[0] = create_gradient_rect(ad);
        //elm_box_pack_end(box, ad->imgs[0]);
        for (unsigned i = 0; i < 4; i++)
        {
            ad->imgs[i] = create_gradient_rect(ad, i);
            elm_box_pack_end(box, ad->imgs[i]);
        }

        ad->imgs[5] = create_rainbow_rect(ad);
        elm_box_pack_end(box, ad->imgs[5]);
    }

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
