#include "mousetouchevent.h"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *label;
} appdata_s;

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_iconified_set(ad->win, EINA_TRUE);
}

static void
on_mouse_down(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    Evas_Event_Mouse_Down *ev = event_info;
    char buf[100];

    sprintf(buf, "Win Mouse down:%d,%d", ev->canvas.x, ev->canvas.y);
    elm_object_text_set(ad->label, buf);
}

static void
on_mouse_move(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    Evas_Event_Mouse_Move *ev = event_info;
    char buf[100];

    sprintf(buf, "Win Mouse move:%d,%d/%d,%d",
            ev->prev.canvas.x, ev->prev.canvas.y, ev->cur.canvas.x, ev->cur.canvas.y);
    elm_object_text_set(ad->label, buf);
}

static void
on_mouse_up(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    Evas_Event_Mouse_Up *ev = event_info;
    char buf[100];

    sprintf(buf, "Win Mouse up:%d,%d", ev->canvas.x, ev->canvas.y);
    elm_object_text_set(ad->label, buf);
}

static void
multi_down_cb(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    Evas_Event_Multi_Down *ev = (Evas_Event_Multi_Down*)event_info;
    char buf[100];

    sprintf(buf, "Multi down : %d - %d,%d", ev->device, ev->canvas.x, ev->canvas.y);
    elm_object_text_set(ad->label, buf);
}

static void
multi_move_cb(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
    appdata_s *ad = data;
    Evas_Event_Multi_Move *ev = (Evas_Event_Multi_Move*)event_info;
    char buf[100];

    sprintf(buf, "Multi move : %d - %d,%d", ev->device, ev->cur.canvas.x, ev->cur.canvas.y);
    elm_object_text_set(ad->label, buf);
}

static void
create_base_gui(appdata_s *ad)
{
    /* set up policy to exit when last window is closed */
    elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);
	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	int rots[4] = { 0, 90, 180, 270 };
	elm_win_wm_rotation_available_rotations_set(ad->win, (const int *)(&rots), 4);

	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	ad->conform = elm_conformant_add(ad->win);
	elm_win_indicator_mode_set(ad->win, ELM_WIN_INDICATOR_SHOW);
	elm_win_indicator_opacity_set(ad->win, ELM_WIN_INDICATOR_OPAQUE);
	evas_object_size_hint_weight_set(ad->conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, ad->conform);
	evas_object_show(ad->conform);

	/* Label*/
	ad->label = elm_label_add(ad->conform);
	elm_object_text_set(ad->label, "<align=center>Hello EFL</align>");
	evas_object_size_hint_weight_set(ad->label, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_content_set(ad->conform, ad->label);

    /* Mouse Touch event callback */
    evas_object_event_callback_add( ad->label, EVAS_CALLBACK_MOUSE_DOWN, on_mouse_down , ad);
    evas_object_event_callback_add( ad->label, EVAS_CALLBACK_MOUSE_MOVE, on_mouse_move , ad);
    evas_object_event_callback_add( ad->label, EVAS_CALLBACK_MOUSE_UP, on_mouse_up , ad);

    /* Multi Touch event callback */
    evas_object_event_callback_add(ad->label, EVAS_CALLBACK_MULTI_DOWN, multi_down_cb, ad);
    evas_object_event_callback_add(ad->label, EVAS_CALLBACK_MULTI_MOVE, multi_move_cb, ad);

    /* Show window after base gui is set up */
    evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
