var app = angular.module('myApp', []);
app.controller('myCtrl', function($scope) {
	var map, placesList;
	
	function cloneMessage(servermessage) {
	    var clone ={};
	    for( var key in servermessage ){
	        if(servermessage.hasOwnProperty(key)) //ensure not adding inherited props
	            clone[key]=servermessage[key];
	    }
	    return clone;
	}

	function successCallback(position) 
	{
		$scope.waypointList = [];
		var cityObj = {
				
				"location": "",
				"stopover": false
		};
		var from = document.getElementById("select-custom-0");
		var fromValue = from.options[from.selectedIndex].value;
		
		var to = document.getElementById("select-custom-1");
		var toValue = to.options[to.selectedIndex].value;
		
		if(document.getElementById("check1").checked == true){
			var obj1 = cityObj;
			obj1.location = "Dhaka";
			$scope.waypointList.push(cloneMessage(obj1));
		}
		if(document.getElementById("check2").checked == true){
			var obj2 = cityObj;
			obj2.location = "Bogra";
			$scope.waypointList.push(cloneMessage(obj2));
		}
		if(document.getElementById("check3").checked == true){
			var obj3 = cityObj;
			obj3.location = "Tangail";
			$scope.waypointList.push(cloneMessage(obj3));
		}
		if(document.getElementById("check4").checked == true){
			var obj4 = cityObj;
			obj4.location = "Faridpur";
			$scope.waypointList.push(cloneMessage(obj4));
		}
		
		tau.openPopup("#popup_toast");
	   var pyrmont = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);

	   map = new google.maps.Map(document.getElementById('map-canvas'), {
	     center: pyrmont,
	     zoom: 17
	   });

	   var directionsService = new google.maps.DirectionsService();
	   var directionsDisplay = new google.maps.DirectionsRenderer();
	   // we assume that the map is already defined and displayed
	   directionsDisplay.setMap(map);
	   var request = {
	       origin : fromValue,
	       destination : toValue,
	       waypoints:$scope.waypointList,
	       travelMode : google.maps.TravelMode.DRIVING
	   };
	   directionsService.route(request, function(result, status) {
	       if (status === google.maps.DirectionsStatus.OK) {
	           directionsDisplay.setDirections(result);
	           console.log(result.routes[0].legs[0].distance.text);
	           //$scope.distance = result.routes[0].legs[0].distance.text;
	           document.getElementById("distancePop").textContent="Distance: "+result.routes[0].legs[0].distance.text;
	       } else {
	           console.error('Unable to get directions');
	       }
	   });
	};

	function errorCallback(error) 
	{
	   var errorInfo = document.getElementById("locationInfo");

	   switch (error.code) 
	   {
	      case error.PERMISSION_DENIED:         
	         errorInfo.innerHTML = "User denied the request for Geolocation.";
	         break;
	      case error.POSITION_UNAVAILABLE:
	         errorInfo.innerHTML = "Location information is unavailable.";
	         break;
	      case error.TIMEOUT:
	         errorInfo.innerHTML = "The request to get user location timed out.";
	         break;
	      case error.UNKNOWN_ERROR:
	         errorInfo.innerHTML = "An unknown error occurred.";
	         break;
	   }
	};

	function initialize() {
		
		console.log("initialized");

		if (navigator.geolocation) 
	    {
			navigator.geolocation.getCurrentPosition(successCallback, errorCallback, 
	                {maximumAge: 60000});
	    } 
	    else 
	    {
	       document.getElementById("locationInfo").innerHTML = "Geolocation is not supported.";
	    }
	 
	}
	
	$scope.showDistance = function(){
		$scope.inputForm = false;
	     $scope.mapView = true; 
	     
	     console.log($scope.from, $scope.to);
		initialize();
	};
	
	var init = function(){
		
		$scope.inputForm = true;
	     $scope.mapView = false;
	};
	
	init();
	
	//add eventListener for tizenhwkey
	document.addEventListener('tizenhwkey', function(e) {
		if(e.keyName == "back") {
			try {
				 $scope.inputForm = true;
			     $scope.mapView = false;
				//tizen.application.getCurrentApplication().exit();
			} catch (error) {
				console.error("getCurrentApplication(): " + error.message);
			}
		}
	});

	
});



	