#ifndef __flashlight_H__
#define __flashlight_H__

#include <app.h>
#include <Elementary.h>
#include <runtime_info.h>
#include <efl_extension.h>
#include <dlog.h>
#include "notification.h"

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "flashlight"

#if !defined(PACKAGE)
#define PACKAGE "org.tizen.flashlight"
#endif

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *button;
	notification_h notification;
} appdata_s;

void change_state(bool on, appdata_s *ad);
void set_notification(appdata_s *ad);
void delete_notification(appdata_s *ad);

#endif /* __flashlight_H__ */
