/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using Xamarin.Forms;

namespace FileManager
{
    /// <summary>
    /// The custom class of the list view, to show the directory.
    /// </summary>
    public class CustomListView : ListView
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CustomListView"/> class.
        /// </summary>
        public CustomListView() : base()
        {
            // Create and define the data template.
            ItemTemplate = new DataTemplate(() =>
            {
                // Add new image.
                Image img = new Image
                {
                    WidthRequest = 64,
                    HeightRequest = 64,
                };
                img.SetBinding(Image.SourceProperty, "Icon");

                Label nameLabel = new Label();
                nameLabel.TextColor = Color.Black;
                nameLabel.FontSize = 40;
                nameLabel.HeightRequest = 60;
                nameLabel.SetBinding(Label.TextProperty, "Name");

                // Create ViewCell object.
                return new ViewCell
                {
                    View = new StackLayout
                    {
                        Padding = new Thickness(10),
                        Orientation = StackOrientation.Horizontal,
                        Children =
                            {
                                img,
                                nameLabel,
                            },
                    },
                };
            });

            RowHeight = 80;
        }

        /// <summary>
        /// Add list item for a <see cref="CustomListView"/> class instance.
        /// </summary>
        /// <param name="dataList">The <see cref="List<Data>"/> name which the list view should show.</param>
        public void AddListItems(List<Data> dataList)
        {
            ItemsSource = dataList;
        }
    }
}
